#ifndef NETMODULE_H
#define NETMODULE_H

#ifdef WIN32

#ifdef NETMODULE_EXPORTS
#define H264_DVR_API  extern "C" __declspec(dllexport)
#else
#define H264_DVR_API  extern "C" __declspec(dllimport)   //VC 
#endif

#ifndef CALL_METHOD
#define CALL_METHOD	__stdcall  //__cdecl
#endif
#define DEF_PARAM(x) = x
#define DEF_0_PARAM = 0
#else	//linux
#define Bool int
#define TYPE_USER_DATA  unsigned long
#define TYPE_USER_DATA2  long
#define LOGD printf
#ifdef OS_IOS
#define H264_DVR_API
#define DEF_PARAM(x)
#define DEF_0_PARAM
#else
#define H264_DVR_API	extern "C"
#define DEF_PARAM(x) = x
#define DEF_0_PARAM = 0
#endif
#define CALL_METHOD
#define CALLBACK
#define WORD	unsigned short
#define DWORD	unsigned long
#define LPDWORD	DWORD*
#define BOOL	int
#define TRUE	1
#define FALSE	0
#define BYTE	unsigned char
#define LONG	long
#define UINT	unsigned int
#define HDC		void*
#define HWND	void*
#define LPVOID	void*
//#define 0	0
#define LPCSTR  char*
#define LPCTSTR  const char*
#endif

#ifdef _NAMESPACE_
namespace JF_NETSDK{
#endif
enum SDK_RET_CODE
{
	H264_DVR_NOERROR				    = 0,				//ûд
	H264_DVR_SUCCESS					= 1,				//سɹ
	H264_DVR_SDK_NOTVALID				= -10000,			//Ƿ
	H264_DVR_NO_INIT					= -10001,			//SDKδʼ
	H264_DVR_ILLEGAL_PARAM				= -10002,			//ûϷ
	H264_DVR_INVALID_HANDLE				= -10003,			//Ч
	H264_DVR_SDK_UNINIT_ERROR			= -10004,			//SDK
	H264_DVR_SDK_TIMEOUT				= -10005,			//ȴʱ
	H264_DVR_SDK_MEMORY_ERROR			= -10006,			//ڴ󣬴ڴʧ
	H264_DVR_SDK_NET_ERROR				= -10007,			//
	H264_DVR_SDK_OPEN_FILE_ERROR		= -10008,			//ļʧ
	H264_DVR_SDK_UNKNOWNERROR			= -10009,			//δ֪
	H264_DVR_DEV_VER_NOMATCH			= -11000,			//յݲȷܰ汾ƥ
	H264_DVR_SDK_NOTSUPPORT				= -11001,			//汾֧

	H264_DVR_ANAS_EXIST					= -11130,			//NASַѴ
	H264_DVR_ANAS_ALIVE					= -11131,			//·ʹã޷
	H264_DVR_ANAS_FULL					= -11132,			//NASѴﵽֵֵ֧


	H264_DVR_OPEN_CHANNEL_ERROR			= -11200,			//ͨʧ,ܼ⵽豸Ѿ
	H264_DVR_CLOSE_CHANNEL_ERROR		= -11201,			//رͨʧ
	H264_DVR_SUB_CONNECT_ERROR			= -11202,			//ýʧ,豸ܲ
	H264_DVR_SUB_CONNECT_SEND_ERROR		= -11203,			//ýͨѶʧ,ܼ⵽豸Ѿ
	H264_DVR_NATCONNET_REACHED_MAX		= -11204,           //NatƵӴﵽ󣬲µNatƵ 
	H264_DVR_NOTSUPPORT					= -11205,			//汾֧
	H264_DVR_NOTVALID					= -11206,           //Ƿ,ӿѶϿ
	H264_DVR_TCPCONNET_REACHED_MAX		= -11207,			//TcpƵӴﵽ󣬲µTcpƵ
	H264_DVR_OPENEDPREVIEW				= -11208,			//ͨѾԤ(ͨĴ򿪹رҪһһӦ,򿪼Ҫرռ;һ»ʾô;Ԥͻ˿߼ϵĲӸôֵ)

	/// ûִ
	H264_DVR_NOPOWER					= -11300,			//Ȩ
	H264_DVR_PASSWORD_NOT_VALID			= -11301,			// ˺벻
	H264_DVR_LOGIN_USER_NOEXIST			= -11302,			//û
	H264_DVR_USER_LOCKED				= -11303,			// û
	H264_DVR_USER_IN_BLACKLIST			= -11304,			// û(ں)
	H264_DVR_USER_HAS_USED				= -11305,			// ûѵ½
	H264_DVR_USER_NOT_LOGIN				= -11306,			// ûûе½
	H264_DVR_CONNECT_DEVICE_ERROR		= -11307,			//豸
	H264_DVR_ACCOUNT_INPUT_NOT_VALID	= -11308,			//û벻Ϸ
	H264_DVR_ACCOUNT_OVERLAP			= -11309,			//ظ
	H264_DVR_ACCOUNT_OBJECT_NONE		= -11310,			//ڶ, ڲѯʱ
	H264_DVR_ACCOUNT_OBJECT_NOT_VALID	= -11311,			//ڶ
	H264_DVR_ACCOUNT_OBJECT_IN_USE		= -11312,			//ʹ
	H264_DVR_ACCOUNT_SUBSET_OVERLAP		= -11313,			//ӼΧ (Ȩ޳ȨޱûȨ޳Ȩ޷Χȵ)
	H264_DVR_ACCOUNT_PWD_NOT_VALID		= -11314,			//벻ȷ
	H264_DVR_ACCOUNT_PWD_NOT_MATCH		= -11315,			//벻ƥ
	H264_DVR_ACCOUNT_RESERVED			= -11316,			//ʺ


	/// ùش
	H264_DVR_OPT_RESTART				= -11400,			// úҪӦó
	H264_DVR_OPT_REBOOT					= -11401,			// Ҫϵͳ
	H264_DVR_OPT_FILE_ERROR				= -11402,			// дļ
	H264_DVR_OPT_CAPS_ERROR				= -11403,			// Բ֧
	H264_DVR_OPT_VALIDATE_ERROR			= -11404,			// Уʧ
	H264_DVR_OPT_CONFIG_NOT_EXIST		= -11405,			// õò
	
	//
	H264_DVR_CTRL_PAUSE_ERROR			= -11500,			//ͣʧ
	H264_DVR_SDK_NOTFOUND				= -11501,			//ʧܣûҵӦļ
	H264_DVR_CFG_NOT_ENABLE				= -11502,           //δ

	H264_DVR_DECORD_FAIL				= -11503,           //ʧ

	//DNSЭش
	H264_DVR_SOCKET_ERROR				= -11600,			//׽ʧ
	H264_DVR_SOCKET_CONNECT				= -11601,			//׽ʧ
	H264_DVR_SOCKET_DOMAIN				= -11602,			//ʧ
	H264_DVR_SOCKET_SEND				= -11603,			//ʧ
	H264_DVR_ARSP_NO_DEVICE				= -11604,			//ûлȡ豸Ϣ豸Ӧò
	H264_DVR_ARSP_BUSING				= -11605,			//ARSPæ
	H264_DVR_ARSP_BUSING_SELECT			= -11606,			//ARSPæ,selectʧ
	H264_DVR_ARSP_BUSING_RECVICE		= -11607,			//ARSPæ,recviceʧ
	H264_DVR_CONNECTSERVER_ERROR		= -11608,			//ӷʧ
    H264_DVR_CONNECT_AGNET     			= -11609,			//
    H264_DVR_CONNECT_NAT      			= -11610,			//͸
    H264_DVR_CONNECT_FAILED				= -11611,			//ʧ
    H264_DVR_CONNECT_FULL				= -11612,			//
	H264_DVR_CLOUD_LOGIN_ERR			= -11613,	        //Ƶ½Ĵ,˵:½ӿڵerror=-11613ʱͨH264_DVR_DEVICEINFOԱsCloudErrCodeȡ,ײӴʱϲ㲻Ӵ
	H264_DVR_NO_CONNECT_FRONT			= -11614,			//ǰ豸δӻӵǰ豸ֱδ֪
	H264_DVR_LOGIN_FULL					= -11615,			//¼Ѵﵽֵ޷ٵ¼
	H264_DVR_ARSP_USER_NOEXIST			= -11619,			//û 
	H264_DVR_ARSP_PASSWORD_ERROR		= -11620,			//˺벻
	H264_DVR_ARSP_QUERY_ERROR			= -11621,			//ѯʧ 
	//Ȩ
	H264_DVR_PIRATESOFTWARE				= -11700,			//豸
	H264_DVR_AUTH_TIMEOUT          		= -11800,			//Ȩʱ
	H264_DVR_AUTH_FILE_FAILED			= -11801,			//Ȩļʧ
	H264_DVR_GAIN_LIST_TIMEOUT			= -11802,			//ȡбʱ
	H264_DVR_AUTH_CODE_ERR				= -11803,			//Ȩ
	//
	H264_DVR_NOENOUGH_MEMORY			= -11804,			//ڴ治
	H264_DVR_INVALID_FORMAT				= -11805,			//ļʽ
	H264_DVR_UPDATE_PART_FAIL			= -11806,			//ĳʧ
	H264_DVR_INVALID_HARDWARE			= -11807,			//ӲͺŲƥ
	H264_DVR_INVALID_VENDOR				= -11808,			//ͻϢƥ
	H264_DVR_INVALID_COMPALIBLE			= -11809,			//ļݰ汾ű豸еС豸ϳ
	H264_DVR_INVALID_VERSION			= -11810,			//Ƿİ汾
	H264_DVR_INVALID_WIFI_DRIVE			= -11811,			//wifi豸ǰʹõwifiƥ
};


//̨
enum PTZ_ControlType
{
	TILT_UP = 0,					//
	TILT_DOWN,						//
	PAN_LEFT,						//
	PAN_RIGHT,						//
	PAN_LEFTTOP,					//
	PAN_LEFTDOWN,					//
	PAN_RIGTHTOP,					//
	PAN_RIGTHDOWN,					//
	ZOOM_OUT_1,						//䱶С//ZOOM_OUT/ZOOM_INVS2010ϵͳĳͻ
	ZOOM_IN_1,						//䱶
	FOCUS_FAR,						//
	FOCUS_NEAR,						//ǰ
	IRIS_OPEN,						//Ȧ
	IRIS_CLOSE,						//ȦС13

	EXTPTZ_OPERATION_ALARM,			// 
	EXTPTZ_LAMP_ON,					//ƹ⿪
	EXTPTZ_LAMP_OFF,				//ƹ
	EXTPTZ_POINT_SET_CONTROL,		//Ԥõ 
	EXTPTZ_POINT_DEL_CONTROL,		//Ԥõ 
	EXTPTZ_POINT_MOVE_CONTROL,		//תԤõ
	EXTPTZ_STARTPANCRUISE,			//ʼˮƽת		20	
	EXTPTZ_STOPPANCRUISE,			//ֹͣˮƽת	
	EXTPTZ_SETLEFTBORDER,			//߽		
	EXTPTZ_SETRIGHTBORDER,			//ұ߽	
	EXTPTZ_STARTLINESCAN,			//Զɨ迪ʼ 
	EXTPTZ_CLOSELINESCAN,			//Զɨ迪ֹͣ 
	EXTPTZ_ADDTOLOOP,				//Ԥõ㵽Ѳ	p1Ѳ·	p2Ԥõֵ	
	EXTPTZ_DELFROMLOOP,				//ɾѲԤõ	p1Ѳ·	p2Ԥõֵ	
	EXTPTZ_POINT_LOOP_CONTROL,		//ʼѲ 28
	EXTPTZ_POINT_STOP_LOOP_CONTROL,	//ֹͣѲ
	EXTPTZ_CLOSELOOP,				//Ѳ	p1Ѳ·		
	EXTPTZ_FASTGOTO,				//ٶλ	
	EXTPTZ_AUXIOPEN,				//أر//param1 μSDK_PtzAuxStatusparam2ֵ
	EXTPTZ_OPERATION_MENU,			//˵аأȷȵ
	EXTPTZ_REVERSECOMM,				//ͷת
	EXTPTZ_OPERATION_RESET,			//̨λ

	EXTPTZ_TOTAL,
};
/// ̨
enum SDK_PtzAuxStatus
{
	EXTPTZ_AUX_ON,	// 
	EXTPTZ_AUX_OFF,	// 
	EXTPTZ_AUX_NR,		
};

#define PAN_AUTO		29	/* ̨SSٶԶɨ */
//#define EXTPTZ_FASTGOTO	30	//άλ


#define NET_MAX_CHANNUM 			64			//ͨ
#define NET_DECORDR_CH              64          //ͨ
#define NET_MAX_USER_NUM			60			//û
#define NET_MAX_RIGTH_NUM			200			//Ȩ
#define NET_MAX_GROUP_NUM			50			//
#define NET_MAX_USER_LENGTH			32			//û󳤶
#define NET_MAX_COMBINE_NUM			2			//ϱͨ
#define NET_MAX_DECORDR_CH          64          //ͨ	

#define NET_MAX_DDNS_TYPE			5			//ֵ֧DDNS
#define NET_MAX_ARSP_TYPE			5
#define NET_MAX_ALARMSERVER_TYPE    5           //ֱ֧
#define NET_MAX_SYSFUNC				20			//ϵͳܸ
#define NET_MAX_PTZ_PROTOCOL_LENGTH 32			//̨Э󳤶
#define NET_N_WEEKS					7			//
#define	NET_N_TSECT					6			//ʱ
#define NET_MD_REGION_ROW			32			//̬
#define NET_COVERNUM				8			 //
#define NET_MAX_FILTERIP_NUM		64			//IPַ
#define NET_NAME_PASSWORD_LEN		64			//û󳤶
#define NET_MAX_PATH_LENGTH	        260			//·
#define NET_N_MIN_TSECT				2
#define NET_MAX_RETURNED_LOGLIST	128			//־
#define NET_MAX_MAC_LEN             32          //MACַַ󳤶
#define NET_IW_ENCODING_TOKEN_MAX   128
#define NET_MAX_AP_NUMBER           32          //SIDݶ10
#define NET_MAX_INFO_LEN		    128
#define NET_MAX_USERNAME_LENGTH		128
#define NET_MAX_SERIALNO_LENGTH		128         //ͨ
#define NET_CHANNEL_NAME_MAX_LEN    64			//ͨ󳤶
#define NET_MAX_LINE_PER_OSD_AREA   12			//һOSDʾַ

//DDNS
#define DDNS_MAX_DDNS_NAMELEN       64  		//
#define DDNS_MAX_DDNS_PWDLEN        32   		//볤
#define DDNS_MAX_DDNS_IPSIZE        64   		//IPַ
#define DDNS_MAX_DDNS_IDSIZE        32   		//豸ʶ
#define DDNS_MAX_SERIALINFO_SIZE    16 			//кԼû

#define  NET_MAX_MSK_SIZE           16			//ĴС


//
#define CAMERAPARA_MAXNUM           16    		//عĿǰ󳤶
//
#define NET_MAX_RECIVE_MSG_PHONE_COUNT 3		///<

//VGAֱ
#define VGA_MAXNUM        32       				//ֱ 
#define VGA_NAME_LENGTH   10					//ֱ 	

//ʾ豸б(豸)
#define DEV_LIST_SHOW  256

//IP SIZE
#define IP_SIZE  16
//#define  MAX_HVR_CHNCAP 16
//DDNS豸Ϣ

//ͨģʽ
#define MAX_HVR_CHNCAP_CHN		32

#define  NET_NAME_TOKEN_LEN 128

#define  NET_NAME_URL_LEN 128
#define  NET_NAME_ID_LEN 64
#define  NET_MAX_POS_FUNC_KEYWORDS 4 //POSֵ֧Ĺؼָ
#define  NET_MAX_TITLE_DOT_BUF_LEN	 64*24*24
//ӲϢ
#define NET_FSLEN 8	//IConstraint::FS_LEN

typedef struct _DDNS_INFO
{
	char ID[64];    						//豸ʶ
	char Alias[DDNS_MAX_DDNS_NAMELEN];
	char IP[DDNS_MAX_DDNS_IPSIZE];   		//IP
	char LanIP[DDNS_MAX_DDNS_IPSIZE];		//IP
	int WebPort; 							//Web˿,ĬΪ80
	int MediaPort; 							//ý˿,ĬΪ34567
	int MobilePort;  						//ֻض˿ڣĬΪ34599
	int UPNPWebPort;  						//UPNPWeb˿,UPNPΪ0
	int UPNPMediaPort; 						//UPNPý˿,UPNPΪ0
	int UPNPMobilePort; 					//UPNPֻض˿,UPNPΪ0
	int ChannelNum; 						//ͨ
	int Status; 							//״̬
	char Username[DDNS_MAX_DDNS_NAMELEN]; 	//û
	char Password[DDNS_MAX_DDNS_PWDLEN]; 	//
}DDNS_INFO,*pDDNS_INFO;

//DDNSϢѯģʽ
typedef struct _SearchMode
{
	int  nType;        								//ѯͣSearchModeType
	char szSerIP[DDNS_MAX_DDNS_IPSIZE];				//ַ
	int nSerPort;           						//˿ں
	char szSerialInfo[DDNS_MAX_SERIALINFO_SIZE];  	//ǰкţΪкţûΪû
	char szPassWord[DDNS_MAX_DDNS_PWDLEN]; 			//û½ʱ

}SearchMode;

//DDNSϢѯ
enum SearchModeType
{
	DDNS_SERIAL = 0,//к
	DDNS_USERNAME,  //û
};
//ʵʱԤչӿӵĲԤ
typedef enum _H264_DVR_RealPlayType
{
	NET_RType_Realplay = 0,		//ʵʱԤ
	NET_RType_Main_Realplay2,	//ʵʱ-ͬNET_RType_Realplay
	NET_RType_Main_Realplay3,
	NET_RType_Sub_Realplay_1,	//ʵʱ-1
	NET_RType_Sub_Realplay_2,	//ʵʱ-2
	NET_RType_Sub_Realplay_3,	//ʵʱ-3

	NET_RType_Multiplay_1,		//໭Ԥ1
	NET_RType_Multiplay_4,		//໭Ԥ4
	NET_RType_Multiplay_6,		//໭Ԥ6
	NET_RType_Multiplay_8,		//໭Ԥ8
	NET_RType_Multiplay_9,		//໭Ԥ9
	NET_RType_Multiplay_12,		//໭Ԥ12
	NET_RType_Multiplay_16,		//໭Ԥ16
} NET_RealPlayType;

/// ϱģʽ
enum NetCombinType
{
	NET_COMBIN_NONE,
	NET_COMBIN_1,
	NET_COMBIN_2,
	NET_COMBIN_3,
	NET_COMBIN_4,
	NET_COMBIN_5,
	NET_COMBIN_6,
	NET_COMBIN_7,
	NET_COMBIN_8,
	NET_COMBIN_9,
	NET_COMBIN_10,
	NET_COMBIN_11,
	NET_COMBIN_12,
	NET_COMBIN_13,
	NET_COMBIN_14,
	NET_COMBIN_15,
	NET_COMBIN_16,
	NET_COMBIN_1_4,
	NET_COMBIN_5_8,
	NET_COMBIN_9_12,
	NET_COMBIN_13_16,
	NET_COMBIN_1_8,
	NET_COMBIN_9_16,
	NET_COMBIN_1_9,
	NET_COMBIN_8_16,
	NET_COMBIN_1_16
};

//Щṹöṩⲿʹãпܻ豸Ǳ߶2,ԶǰSDK_
enum SDK_CAPTURE_SIZE_t {
	SDK_CAPTURE_SIZE_D1,		///< 720*576(PAL)	720*480(NTSC)
	SDK_CAPTURE_SIZE_HD1,		///< 352*576(PAL)	352*480(NTSC)
	SDK_CAPTURE_SIZE_BCIF,		///< 720*288(PAL)	720*240(NTSC)
	SDK_CAPTURE_SIZE_CIF,		///< 352*288(PAL)	352*240(NTSC)
	SDK_CAPTURE_SIZE_QCIF,		///< 176*144(PAL)	176*120(NTSC)
	SDK_CAPTURE_SIZE_VGA,		///< 640*480(PAL)	640*480(NTSC)
	SDK_CAPTURE_SIZE_QVGA,		///< 320*240(PAL)	320*240(NTSC)
	SDK_CAPTURE_SIZE_SVCD,		///< 480*480(PAL)	480*480(NTSC)
	SDK_CAPTURE_SIZE_QQVGA,		///< 160*128(PAL)	160*128(NTSC)
	SDK_CAPTURE_SIZE_ND1 = 9,   ///< 240*192
	SDK_CAPTURE_SIZE_650TVL,    ///< 926*576
	SDK_CAPTURE_SIZE_720P,      ///< 1280*720
	SDK_CAPTURE_SIZE_1_3M,      ///< 1280*960
	SDK_CAPTURE_SIZE_UXGA ,     ///< 1600*1200
	SDK_CAPTURE_SIZE_1080P,     ///< 1920*1080
	SDK_CAPTURE_SIZE_WUXGA,     ///< 1920*1200
	SDK_CAPTURE_SIZE_2_5M,      ///< 1872*1408
	SDK_CAPTURE_SIZE_3M,        ///< 2048*1536
	SDK_CAPTURE_SIZE_5M,        ///< 3744*1408
	SDK_CAPTURE_SIZE_NR =19,
	SDK_CAPTURE_SIZE_1080N = 19,///< 960*1080
	SDK_CAPTURE_SIZE_4M,        ///< 2592*1520
	SDK_CAPTURE_SIZE_6M,		///< 30722048
	SDK_CAPTURE_SIZE_8M,		///< 32642448
	SDK_CAPTURE_SIZE_12M,		///< 4000*3000
	SDK_CAPTURE_SIZE_4K,		///< 4096 * 2160ͨ/3840*2160˼
	SDK_CAPTURE_SIZE_EXT_V2_NR =25,
	SDK_CAPTURE_SIZE_720N = 25,  	///< 640*720
	SDK_CAPTURE_SIZE_WSVGA,			///< 1024*576
	SDK_CAPTURE_SIZE_RES2,      	///< 0*0
	SDK_CAPTURE_SIZE_RES3,      	///< 0*0
	SDK_CAPTURE_SIZE_RES4,      	///< 0*0
	SDK_CAPTURE_SIZE_RES5,      	///< 0*0
	SDK_CAPTURE_SIZE_RES6,      	///< 0*0
	SDK_CAPTURE_SIZE_EXT_V3_NR,
};

/// ģʽ
enum SDK_capture_brc_t {
	SDK_CAPTURE_BRC_CBR,			///< ̶
	SDK_CAPTURE_BRC_VBR,			///< ɱ
	SDK_CAPTURE_BRC_MBR,			///< 
	SDK_CAPTURE_BRC_NR				///< öٵģʽĿ
};

/// ѹʽ
enum SDK_CAPTURE_COMP_t {
	SDK_CAPTURE_COMP_DIVX_MPEG4,	///< DIVX MPEG4
	SDK_CAPTURE_COMP_MS_MPEG4,		///< MS MPEG4
	SDK_CAPTURE_COMP_MPEG2,			///< MPEG2
	SDK_CAPTURE_COMP_MPEG1,			///< MPEG1
	SDK_CAPTURE_COMP_H263,			///< H.263
	SDK_CAPTURE_COMP_MJPG,			///< MJPG
	SDK_CAPTURE_COMP_FCC_MPEG4,		///< FCC MPEG4
	SDK_CAPTURE_COMP_H264,			///< H.264
	SDK_CAPTURE_COMP_H265,			///< H.265
	SDK_CAPTURE_COMP_NR				///< öٵѹ׼Ŀ
};

/// ͨ
enum SDK_CAPTURE_CHANNEL_t {
	SDK_CHL_MAIN_T = 0,		///< ͨ		1 
	SDK_CHL_2END_T = 1,		///< ͨ		2 
	SDK_CHL_3IRD_T = 2,		///< ͨ		3 
	SDK_CHL_4RTH_T = 3,		///< ͨ		4 
	SDK_CHL_JPEG_T = 4,		///< ͨ		JPEGץͼ 
	SDK_CHL_FUNCTION_NUM
};
/// Ƶ
enum SDK_AudioEncodeTypes
{
	SDK_AUDIO_ENCODE_NONE = 0,
	SDK_AUDIO_ENCODE_G729_8KBIT,
	SDK_AUDIO_ENCODE_G726_16KBIT,
	SDK_AUDIO_ENCODE_G726_24KBIT,
	SDK_AUDIO_ENCODE_G726_32KBIT,
	SDK_AUDIO_ENCODE_G726_40KBIT,
	SDK_AUDIO_ENCODE_PCM_8TO16BIT,
	SDK_AUDIO_ENCODE_PCM_ALAW,
	SDK_AUDIO_ENCODE_PCM_ULAW,
	SDK_AUDIO_ENCODE_ADPCM8K16BIT,
	SDK_AUDIO_ENCODE_ADPCM16K16BIT,
	SDK_AUDIO_ENCODE_G711_ALAW,
	SDK_AUDIO_ENCODE_MPEG2_LAYER1,
	SDK_AUDIO_ENCODE_AMR8K16BIT,
	SDK_AUDIO_ENCODE_G711_ULAW,
	SDK_AUDIO_ENCODE_IMA_ADPCM_8K16BIT,
	SDK_AUDIO_ENCODE_TYPES_NR,
};


typedef enum _SDK_CONFIG_TYPE
{
	E_SDK_CONFIG_NOTHING = 0,
	E_SDK_CONFIG_USER,					//ûϢȨбûбб   ӦṹUSER_MANAGE_INFO
	E_SDK_CONFIG_ADD_USER,				//û---ӦṹUSER_INFO
	E_SDK_CONFIG_MODIFY_USER,			//޸û---ӦṹCONF_MODIFYUSER
	E_SDK_CONFIG_DELETE_USER,			//ӦṹUSER_INFO
	E_SDK_CONFIG_ADD_GROUP,				//---ӦṹUSER_GROUP_INFO
	E_SDK_CONFIG_MODIFY_GROUP,			//޸---ӦṹCONF_MODIFYGROUP
	E_SDK_COFIG_DELETE_GROUP,			//Ӧṹ---USER_GROUP_INFO
	E_SDK_CONFIG_MODIFY_PSW,			//޸---Ӧṹ_CONF_MODIFY_PSW
	E_SDK_CONFIG_ABILITY_SYSFUNC = 9,	//ֵ֧繦---ӦṹSDK_SystemFunction
	E_SDK_CONFIG_ABILTY_ENCODE = 10,	//Ȼñ---ӦṹCONFIG_EncodeAbility
	E_SDK_CONFIG_ABILITY_PTZPRO,		//̨Э---ӦṹSDK_PTZPROTOCOLFUNC
	E_SDK_COMFIG_ABILITY_COMMPRO,		//Э---ӦṹSDK_COMMFUNC
	E_SDK_CONFIG_ABILITY_MOTION_FUNC,	//̬---ӦṹSDK_MotionDetectFunction
	E_SDK_CONFIG_ABILITY_BLIND_FUNC,	//Ƶڵ---ӦṹSDK_BlindDetectFunction
	E_SDK_CONFIG_ABILITY_DDNS_SERVER,	//DDNS֧---ӦṹSDK_DDNSServiceFunction
	E_SDK_CONFIG_ABILITY_TALK,			//Խ---ӦṹSDK_DDNSServiceFunction
	E_SDK_CONFIG_SYSINFO = 17,			//ϵͳϢ---ӦṹH264_DVR_DEVICEINFO
	E_SDK_CONFIG_SYSNORMAL,				//ͨ---ӦṹSDK_CONFIG_NORMAL
	E_SDK_CONFIG_SYSENCODE,				//---ӦṹSDK_EncodeConfigAll
	E_SDK_CONFIG_SYSNET = 20,			//---ӦṹSDK_CONFIG_NET_COMMON
	E_SDK_CONFIG_PTZ,					//̨ҳ---ӦṹSDK_STR_PTZCONFIG_ALL
	E_SDK_CONFIG_COMM,					//ҳ---ӦṹSDK_CommConfigAll
	E_SDK_CONFIG_RECORD,				//¼ý---ӦṹSDK_RECORDCONFIG
	E_SDK_CONFIG_MOTION,				//̬ҳ---ӦṹSDK_MOTIONCONFIG
	E_SDK_CONFIG_SHELTER,				//Ƶڵ---ӦṹSDK_BLINDDETECTCONFIG
	E_SDK_CONFIG_VIDEO_LOSS,  			//Ƶʧ---ӦṹSDK_VIDEOLOSSCONFIG
	E_SDK_CONFIG_ALARM_IN,				//---ӦṹSDK_ALARM_INPUTCONFIG
	E_SDK_CONFIG_ALARM_OUT,				//---ӦṹSDK_AlarmOutConfigAll
	E_SDK_CONFIG_DISK_MANAGER,			//Ӳ̹---ӦṹSDK_StorageDeviceControl
	E_SDK_CONFIG_OUT_MODE = 30,			//ģʽ---ӦṹSDK_VideoWidgetConfigAll
	E_SDK_CONFIG_CHANNEL_NAME,			//ͨ---ӦṹSDK_ChannelNameConfigAll
	E_SDK_CONFIG_AUTO,					//Զά---ӦṹSDK_AutoMaintainConfig
	E_SDK_CONFIG_DEFAULT,     			//ָĬϽ---ӦṹSDK_SetDefaultConfigTypes
	E_SDK_CONFIG_DISK_INFO,				//ӲϢ---ӦṹSDK_StorageDeviceInformationAll
	E_SDK_CONFIG_LOG_INFO,				//ѯ־---ӦṹSDK_LogList
	E_SDK_CONFIG_NET_IPFILTER,			//---ӦṹSDK_NetIPFilterConfig
	E_SDK_CONFIG_NET_DHCP,				//DHCP---ӦṹSDK_NetDHCPConfigAll
	E_SDK_CONFIG_NET_DDNS,				//DDNSϢ---ӦṹSDK_NetDDNSConfigALL
	E_SDK_CONFIG_NET_EMAIL,				//EMAIL---ӦṹSDK_NetEmailConfig
	E_SDK_CONFIG_NET_MULTICAST = 40,	//鲥---ӦṹSDK_NetMultiCastConfig
	E_SDK_CONFIG_NET_NTP,				//NTP---ӦṹSDK_NetNTPConfig
	E_SDK_CONFIG_NET_PPPOE,				//PPPOE---ӦṹSDK_NetPPPoEConfig
	E_SDK_CONFIG_NET_DNS,				//DNS---ӦṹSDK_NetDNSConfig
	E_SDK_CONFIG_NET_FTPSERVER,			//FTP---ӦṹSDK_FtpServerConfig
	E_SDK_CONFIG_SYS_TIME,				//ϵͳʱ---ӦṹSDK_SYSTEM_TIME(ӿH264_DVR_SetSystemDateTimeҲʵ)
	E_SDK_CONFIG_CLEAR_LOG,				//־(ӿH264_DVR_ControlDVR)											
	E_SDK_REBOOT_DEV,					//豸(ӿH264_DVR_ControlDVR)												
	E_SDK_CONFIG_ABILITY_LANG,			//֧---ӦṹSDK_MultiLangFunction
	E_SDK_CONFIG_VIDEO_FORMAT,																	
	E_SDK_CONFIG_COMBINEENCODE = 50,	//ϱ---ӦṹSDK_CombineEncodeConfigAll
	E_SDK_CONFIG_EXPORT,				//õ														
	E_SDK_CONFIG_IMPORT,				//õ
	E_SDK_LOG_EXPORT,					//־														
	E_SDK_CONFIG_COMBINEENCODEMODE, 	//ϱģʽ---ӦṹSDK_CombEncodeModeAll
	E_SDK_WORK_STATE,					//״̬---SDK_DVR_WORKSTATE(ӿH264_DVR_GetDVRWorkStateҲԻȡ)															
	E_SDK_ABILITY_LANGLIST, 			//ʵֵ֧Լ---ӦṹSDK_MultiLangFunction									
	E_SDK_CONFIG_NET_ARSP,				//ARSP---ӦṹSDK_NetARSPConfigAll
	E_SDK_CONFIG_SNAP_STORAGE,			//ץͼ---ӦṹSDK_SnapshotConfig
	E_SDK_CONFIG_NET_3G, 				//3G---ӦṹSDK_Net3GConfig
	E_SDK_CONFIG_NET_MOBILE = 60, 		//ֻ---ӦṹSDK_NetMoblieConfig
	E_SDK_CONFIG_UPGRADEINFO, 			//ȡϢ//ļ---ӦṹSDK_UpgradeInfo
	E_SDK_CONFIG_NET_DECODER,			//ַV1()---ӦṹSDK_NetDecoderConfigAll
	E_SDK_ABILITY_VSTD, 				//ʵֵ֧Ƶʽ---ӦṹSDK_MultiVstd
	E_SDK_CONFIG_ABILITY_VSTD,			//֧Ƶʽ---ӦṹSDK_MultiVstd
	E_SDK_CONFIG_NET_UPNP, 				//UPUN---ӦṹSDK_NetUPNPConfig
	E_SDK_CONFIG_NET_WIFI,				//WIFI---ӦṹSDK_NetWifiConfig
	E_SDK_CONFIG_NET_WIFI_AP_LIST,		//wifiб---ӦṹSDK_NetWifiDeviceAll
	E_SDK_CONFIG_SYSENCODE_SIMPLIIFY, 	//򻯵ı---ӦṹSDK_EncodeConfigAll_SIMPLIIFY
	E_SDK_CONFIG_ALARM_CENTER,  		//澯---ӦṹSDK_NetAlarmServerConfigAll
	E_SDK_CONFIG_NET_ALARM = 70,		//澯---ӦṹSDK_NETALARMCONFIG_ALL																		
	E_SDK_CONFIG_NET_MEGA,     			//Żͨ---ӦṹSDK_CONFIG_NET_MEGA
	E_SDK_CONFIG_NET_XINGWANG, 			//---ӦṹSDK_CONFIG_NET_XINGWANG
	E_SDK_CONFIG_NET_SHISOU,   			//---ӦṹSDK_CONFIG_NET_SHISOU
	E_SDK_CONFIG_NET_VVEYE,    			//VVEYE---ӦṹSDK_CONFIG_NET_VVEYE
	E_SDK_CONFIG_NET_PHONEMSG,  		//---ӦṹSDK_NetShortMsgCfg
	E_SDK_CONFIG_NET_PHONEMEDIAMSG,  	//---ӦṹSDK_NetMultimediaMsgCfg
	E_SDK_VIDEO_PREVIEW,				//
	E_SDK_CONFIG_NET_DECODER_V2,		//ַV2()---ӦṹSDK_NetDecorderConfigAll_V2
	E_SDK_CONFIG_NET_DECODER_V3,		//ַV3---ӦṹSDK_NetDecorderConfigAll_V3
	E_SDK_CONFIG_ABILITY_SERIALNO = 80,	//к---ӦṹSDK_AbilitySerialNo(Բ豸к(),кſԴӵ½ӿڻȡ)
	E_SDK_CONFIG_NET_RTSP,    			//RTSP---ӦṹSDK_NetRTSPConfig
	E_SDK_GUISET,              			//GUI---ӦṹSDK_GUISetConfig
	E_SDK_CATCHPIC,               		//ץͼ												
	E_SDK_VIDEOCOLOR,             		//Ƶɫ---ӦṹSDK_VideoColorConfigAll
	E_SDK_CONFIG_COMM485,				//485Э---ӦṹSDK_STR_RS485CONFIG_ALL
	E_SDK_COMFIG_ABILITY_COMMPRO485, 	//485Э---ӦṹSDK_COMMFUNC
	E_SDK_CONFIG_SYS_TIME_NORTC,		//ϵͳʱnoRtc---ӦṹSDK_SYSTEM_TIME
	E_SDK_CONFIG_REMOTECHANNEL,   		//Զͨ---
	E_SDK_CONFIG_OPENTRANSCOMCHANNEL , 	//͸---ӦṹTransComChannel
	E_SDK_CONFIG_CLOSETRANSCOMCHANNEL = 90,//ر͸
	E_SDK_CONFIG_SERIALWIRTE,  			//д͸Ϣ
	E_SDK_CONFIG_SERIALREAD,   			//ȡ͸Ϣ
	E_SDK_CONFIG_CHANNELTILE_DOT,		//Ϣ-޸IPCͨҪϢ---ӦṹSDK_TitleDot
	E_SDK_CONFIG_CAMERA,           		//---ӦṹSDK_CameraParam
	E_SDK_CONFIG_ABILITY_CAMERA,    	//ع---ӦṹSDK_CameraAbility
	E_SDK_CONFIG_BUGINFO,    			//													
	E_SDK_CONFIG_STORAGENOTEXIST,		//Ӳ̲---ӦṹSDK_VIDEOLOSSCONFIG
	E_SDK_CONFIG_STORAGELOWSPACE, 		//Ӳ---ӦṹSDK_StorageLowSpaceConfig								
	E_SDK_CONFIG_STORAGEFAILURE, 		//Ӳ̳---ӦṹSDK_StorageFailConfig
	E_SDK_CFG_NETIPCONFLICT = 100,   	//IPͻ---ӦṹSDK_VIDEOLOSSCONFIG
	E_SDK_CFG_NETABORT,  				//쳣---ӦṹSDK_VIDEOLOSSCONFIG
	E_SDK_CONFIG_CHNSTATUS, 			//ͨ״̬---ӦṹSDK_NetDecorderChnStatusAll
	E_SDK_CONFIG_CHNMODE,  				//ͨģʽ---ӦṹSDK_NetDecorderChnModeConfig
	E_SDK_CONFIG_NET_DAS,    			//ע---ӦṹSDK_DASSerInfo
	E_SDK_CONFIG_CAR_INPUT_EXCHANGE,    //ⲿϢ복״̬ĶӦϵ---ӦṹSDK_CarStatusExchangeAll			
	E_SDK_CONFIG_DELAY_TIME,       		//ϵͳʱ---ӦṹSDK_CarDelayTimeConfig
	E_SDK_CONFIG_NET_ORDER,             //ȼ---ӦṹSDK_NetOrderConfig
	E_SDK_CONFIG_ABILITY_NETORDER , 	//ȼ---ӦṹSDK_NetOrderFunction
	E_SDK_CONFIG_CARPLATE,				//ƺ---ӦṹSDK_CarPlates
	E_SDK_CONFIG_LOCALSDK_NET_PLATFORM = 110, //ƽ̨Ϣ---ӦṹSDK_LocalSdkNetPlatformConfig
	E_SDK_CONFIG_GPS_TIMING,            //GPSУʱ---ӦṹSDK_GPSTimingConfig
	E_SDK_CONFIG_VIDEO_ANALYZE, 		//Ƶ(DVR)---ӦṹSDK_ANALYSECONFIG
	E_SDK_CONFIG_GODEYE_ALARM,			//۽Ӿϵͳ---ӦṹSDK_GodEyeConfig
	E_SDK_CONFIG_NAT_STATUS_INFO,   	//nat״̬Ϣ---ӦṹSDK_NatStatusInfo	
	E_SDK_CONFIG_BUGINFOSAVE,     		//()									 
	E_SDK_CONFIG_MEDIA_WATERMARK,		//ˮӡ---ӦṹSDK_WaterMarkConfigAll
	E_SDK_CONFIG_ENCODE_STATICPARAM,	//̬---ӦṹSDK_EncodeStaticParamAll
	E_SDK_CONFIG_LOSS_SHOW_STR,		    //Ƶʧʾַ
	E_SDK_CONFIG_DIGMANAGER_SHOW,	    //ͨʾ---ӦṹSDK_DigManagerShowStatus
	E_SDK_CONFIG_ABILITY_ANALYZEABILITY = 120,//ܷ---ӦṹSDK_ANALYZEABILITY
	E_SDK_CONFIG_VIDEOOUT_PRIORITY,   //ʾHDMI VGAȼ
	E_SDK_CONFIG_NAT,		  		  //NATܣMTUֵ---ӦṹSDK_NatConfig
	E_SDK_CONFIG_CPCINFO,		      //CPCϢ---ӦṹSDK_CPCDataAll
	E_SDK_CONFIG_STORAGE_POSITION,    // ¼洢豸---ӦṹSDK_RecordStorageType
	E_SDK_CONFIG_ABILITY_CARSTATUSNUM,//״̬---ӦṹSDK_CarStatusNum
	E_SDK_CFG_VPN,					//VPN---ӦṹSDK_VPNConfig
	E_SDK_CFG_VIDEOOUT,				//VGAƵֱ---ӦṹSDK_VGAresolution
	E_SDK_CFG_ABILITY_VGARESOLUTION,//ֵ֧VGAֱб---ӦṹSDK_VGAResolutionAbility
	E_SDK_CFG_NET_LOCALSEARCH,      //豸豸˵ľ豸---ӦṹSDK_NetDevList
	E_SDK_CFG_NETPLAT_KAINENG = 130,//ͻ---ӦṹSDK_CONFIG_KAINENG_INFO
	E_SDK_CFG_ENCODE_STATICPARAM_V2,//DVR̬---ӦṹSDK_EncodeStaticParamV2
	E_SDK_ABILITY_ENC_STATICPARAM,	//̬---ӦṹSDK_EncStaticParamAbility ()
	E_SDK_CFG_C7_PLATFORM,          //C7ƽ̨---ӦṹSDK_C7PlatformConfig
	E_SDK_CFG_MAIL_TEST,            //ʼ---ӦṹSDK_NetEmailConfig
	E_SDK_CFG_NET_KEYBOARD,         //̷---ӦṹSDK_NetKeyboardConfig
	E_SDK_ABILITY_NET_KEYBOARD,		//Э---ӦṹSDK_NetKeyboardAbility  
	E_SDK_CFG_SPVMN_PLATFORM,       //28181Э---ӦṹSDK_ASB_NET_VSP_CONFIG	
	E_SDK_CFG_PMS,				    //ֻ---ӦṹSDK_PMSConfig
	E_SDK_CFG_OSD_INFO,             //ĻʾϢ---ӦṹSDK_OSDInfoConfigAll
	E_SDK_CFG_KAICONG = 140,        //ͻ---ӦṹSDK_KaiCongAlarmConfig
	E_SDK_CFG_DIGITAL_REAL,			//ֵ֧ͨģʽ---ӦṹSDK_VideoChannelManage
	E_SDK_ABILITY_PTZCONTROL,		//PTZ---ӦṹSDK_PTZControlAbility
	E_SDK_CFG_XMHEARTBEAT,			//ӦṹSDK_XMHeartbeatConfig
	E_SDK_CFG_MONITOR_PLATFORM,		//ƽ̨---ӦṹSDK_MonitorPlatformConfig
	E_SDK_CFG_PARAM_EX,				//ͷչ---ӦṹSDK_CameraParamEx
	E_SDK_CFG_NETPLAT_ANJU_P2P,		//P2P---ӦṹSDK_NetPlatformCommonCfg  
	E_SDK_GPS_STATUS,				//GPSϢ---ӦṹSDK_GPSStatusInfo 
	E_SDK_WIFI_STATUS,				//WifiϢ---ӦṹSDK_WifiStatusInfo
	E_SDK_3G_STATUS,  				//3GϢ---ӦṹSDK_WirelessStatusInfo
	E_SDK_DAS_STATUS = 150, 		//ע״̬---ӦṹSDK_DASStatusInfo 
	E_SDK_ABILITY_DECODE_DELEY,		//---ӦṹSDK_DecodeDeleyTimePrame
	E_SDK_CFG_DECODE_PARAM,     	//ʱ---ӦṹSDK_DecodeParam
	E_SDK_CFG_VIDEOCOLOR_CUSTOM,    //SDK_VIDEOCOLOR_PARAM_CUSTOM
	E_SDK_ABILITY_ONVIF_SUB_PROTOCOL,//onvifЭ---ӦṹSDK_AbilityMask   
	E_SDK_CONFIG_EXPORT_V2,      	//豸Ĭã
	E_SDK_CFG_CAR_BOOT_TYPE,      	//ؿػģʽ---ӦṹSDK_CarBootTypeConfig
	E_SDK_CFG_IPC_ALARM,			//IPC籨---ӦṹSDK_IPCAlarmConfigAll
	E_SDK_CFG_NETPLAT_TUTK_IOTC,	//TUTK IOTCƽ̨---ӦṹSDK_NetPlatformCommonCfg
	E_SDK_CFG_BAIDU_CLOUD,     		//ٶ---ӦṹSDK_BaiduCloudCfg
	E_SDK_CFG_PMS_MSGNUM = 160,		//ֻ---ӦṹSDK_PhoneInfoNum
	E_SDK_CFG_IPC_IP,           	//DVRȥ޸豸IP---ӦṹSDK_IPSetCfg
	E_SDK_ABILITY_DIMEN_CODE,       //ά---ӦṹSDK_DimenCodeAll
	E_SDK_CFG_MOBILE_WATCH, 	 	//йֻƽ̨---ӦṹSDK_MobileWatchCfg	
	E_SDK_CFG_BROWSER_LANGUAGE,   	//ʹʱʹõ---ӦṹSDK_BrowserLanguageType
	E_SDK_CFG_TIME_ZONE,			//ʱ---ӦṹSDK_TimeZone
	E_SDK_CFG_NETBJTHY,       		//ͻ---ӦṹSDK_MonitorPlatformConfig
	E_SDK_ABILITY_MAX_PRE_RECORD,   //Ԥ¼ʱ1~30---ӦṹSDK_AbilityMask
	E_SDK_CFG_DIG_TIME_SYN,			//ͨʱͬ(ǰͬʽ)---ӦṹSDK_TimeSynParam
	E_SDK_CONFIG_OSDINFO_DOT,		//3OSD
	E_SDK_CFG_NET_POS = 170,		//POS---ӦṹSDK_NetPosConfigAll
	E_SDK_CFG_CUSTOMIZE_OEMINFO,	//OEMͻ汾Ϣ---ӦṹSDK_CustomizeOEMInfo
	E_SDK_CFG_DIGITAL_ENCODE, 		//ͨ---ӦṹSDK_EncodeConfigAll_SIMPLIIFY
	E_SDK_CFG_DIGITAL_ABILITY, 		//ͨı---ӦṹSDK_DigitDevInfo
	E_SDK_CFG_ENCODECH_DISPLAY,		//IE˱ʾǰͨ---ӦṹSDK_EncodeChDisplay
	E_SDK_CFG_RESUME_PTZ_STATE,		//̨״̬---ӦṹSDK_ResumePtzState
	E_SDK_CFG_LAST_SPLIT_STATE,   	//һεĻָģʽָ֮ǰķָģʽ
	E_SDK_CFG_SYSTEM_TIMING_WORK,   //豸ʱػʱáԶάҳҪó½ܿ
	E_SDK_CFG_GBEYESENV,			//ƽ̨---ӦṹSDK_NetPlatformCommonCfg
	E_SDK_ABILITY_AHD_ENCODE_L, 	//AHDL---ӦṹSDK_AHDEncodeLMask
	E_SDK_CFG_SPEEDALARM = 180,		//ٶȱ---ӦṹSDK_SpeedAlarmConfigAll
	E_SDK_CFG_CORRESPONDENT_INFO,	//ûԶ---ӦṹSDK_CorrespondentOwnInfo
	E_SDK_SET_OSDINFO,				//OSDϢ---ӦṹSDK_OSDInfo,(ֻ֧ģͨ)
	E_SDK_SET_OSDINFO_V2,			//OSDϢӣ---ӦṹSDK_OSDInfoConfigAll(ֻ֧ģͨ)
	E_SDK_ABILITY_SUPPORT_EXTSTREAM,//ָ֧¼---ӦṹSDK_AbilityMask
	E_SDK_CFG_EXT_RECORD,			//---ӦṹSDK_RECORDCONFIG_ALL/SDK_RECORDCONFIG
	E_SDK_CFG_APP_DOWN_LINK,		//û---ӦṹSDK_AppDownloadLink
	E_SDK_CFG_EX_USER_MAP,			//ڱ---ӦṹSDK_UserMap
	E_SDK_CFG_TRANS_COMM_DATA, 		//ϴUDPTCPTCP֧˫ͨ---ӦṹSDK_NetTransCommData
	E_SDK_EXPORT_LANGUAGE,			//Ե
	E_SDK_IMPORT_LANGUAGE = 190,	//Ե
	E_SDK_DELETE_LANGUAGE,			//ɾ
	E_SDK_CFG_UPGRADE_VERSION_LIST,	//ļб---ӦṹSDK_CloudUpgradeList
	E_SDK_CFG_GSENSORALARM,			//GSENSOR
	E_SDK_CFG_USE_PROGRAM,			//ͻС---ӦṹSDK_NetUseProgram
	E_SDK_CFG_FTP_TEST,             //FTP---ӦṹSDK_FtpServerConfig
	E_SDK_CFG_FbExtraStateCtrl,  	//Ʒ¼Ƶ״̬---ӦṹSDK_FbExtraStateCtrl
	E_SDK_CFG_PHONE,				//ֻ
	E_SDK_PicInBuffer,				//ֻץͼ, 
	E_SDK_GUARD,					// 
	E_SDK_UNGUARD = 200,			//
	E_SDK_CFG_START_UPGRADE,		//ʼ
	E_SDK_CFG_AUTO_SWITCH,			//ʱ---ȡöH264_DVR_GetDevConfig_Json,ʹH264_DVR_SetDevConfig_Json(ʱĸʽܲõ.doc)(ӿڼJsonӿ,ü) "Name":"PowerSocket.AutoSwitch"
	E_SDK_CFG_POWER_SOCKET_SET,		//Ʋ---Jsonӿ "Name":"OPPowerSocketGet"
	E_SDK_CFG_AUTO_ARM,				//Ķʱ---Jsonӿ "Name":"PowerSocket.AutoArm"
	E_SDK_CFG_WIFI_MODE,			//Wifiģʽãг¼лAPģʽ---ӦṹSDK_NetWifiMode
	E_SDK_CFG_CIENT_INFO,			//ֻͻϢ---Jsonӿ "Name":"PowerSocket.ClientInfo"
	E_SDK_CFG_ATHORITY,				//SDK_Authority---Jsonӿ "Name":"PowerSocket.Authority"
	E_SDK_CFG_ARM ,					//SDK_Arm---Jsonӿ "Name":"PowerSocket.Arm"
	E_SDK_CFG_AUTOLIGHT,			//ҹƵĶʱع --Jsonӿ "Name" : "PowerSocket.AutoLight",
	E_SDK_CFG_LIGHT = 210,			//ʹܺͽֹҹƵĶӦ---Jsonӿ "Name" : "PowerSocket.Light",
	E_SDK_CFG_WORKRECORD,			//еͳ---Jsonӿ "Name" : "PowerSocket.WorkRecord",
	E_SDK_CFG_SYSTEMTIME,			//ʱ ,ӵʱ,ӵʱ,Ͷʱ --Jsonӿ "Name":"System.Time"
	E_SDK_CFG_USB,					//usbӿڿƹ---Jsonӿ "Name":"PowerSocket.Usb"
	E_SDK_CFG_NETPLAT_BJHONGTAIHENG,//̩ƽ̨---ӦṹSDK_CONFIG_NET_BJHONGTAIHENG
	E_SDK_CFG_CLOUD_STORAGE,		//ƴ洢---ӦṹSDK_CloudRecordConfigAll
	E_SDK_CFG_IDLE_PTZ_STATE,       //̨ж---ӦṹSDK_PtzIdleStateAll
	E_SDK_CFG_CAMERA_CLEAR_FOG,	    //ȥ---ӦṹSDK_CameraClearFogAll
	E_SDK_CFG_WECHATACCOUNT,		//---Ӧjson "Name":"PowerSocket.WechatAccount"
	E_SDK_CFG_WECHATRENEW,			//---Ӧjson "Name":"PowerSocket.WechatRenew" 
	E_SDK_CFG_POWERSOCKET_WIFI = 220,//---Ӧjson "Name":"PowerSocket.WiFi"
	E_SDK_CFG_CAMERA_MOTOR_CONTROL, //---ӦṹSDK_CameraMotorCtrl
	E_SDK_CFG_ENCODE_ADD_BEEP,		//ñÿ30beep---ӦṹSDK_EncodeAddBeep
	E_SDK_CFG_DATALINK,			    //datalinkͻеִгʹ---Ӧṹ SDK_DataLinkConfig
	E_SDK_CFG_FISH_EYE_PARAM,	    //۹ܲ---ӦṹSDK_FishEyeParam
	E_SDK_OPERATION_SET_LOGO,	    //ƵϵȳҵLOGO---ӦṹSDK_SetLogo
	E_SDK_CFG_SPARSH_HEARTBEAT,		//Sparshͻ---Ӧṹ SDK_SparshHeartbeat
	E_SDK_CFG_LOGIN_FAILED,			//¼ʧʱʼʹýṹ:¼ṹ---Ӧṹ SDK_VIDEOLOSSCONFIG
	E_SDK_CFG_NETPLAT_SPVMN_NAS,	//ճͻnas---ӦṹSDK_SPVMN_NAS_SERVER
	E_SDK_CFG_DDNS_APPLY,			//ddns ܲ---ӦṹSDK_NetDDNSConfigALL
	E_SDK_OPERATION_NEW_UPGRADE_VERSION_REQ = 230,	///°汾ѯ---ӦṹSDK_CloudUpgradeVersionRep
	E_SDK_CFG_IPV6_ADDRESS,			//ipv6------ӦĽṹSDK_IPAddressV6
	E_SDK_CFG_DDNS_IPMSG,         	//DDNSIPַ
	E_SDK_CFG_ONLINE_UPGRADE,		//-----ӦĽṹSDK_OnlineUpgradeCfg
	E_SDK_CFG_CONS_SENSOR_ALARM,    //òƷ433-----ӦSDK_ConsSensorAlarmCfg
	E_SDK_OPEARTION_SPLIT_CONTROL,  //ָģʽ-----ӦĽṹSDK_SplitControl
	E_SDK_CFG_Netinfo_TRANS_COMM,	//Netinfo_cctvͻӴݵָ-----ӦĽṹSDK_NetinfoNetTransComm
	E_SDK_CFG_RECORD_ENABLE,       	//Ƿ׼ÿʼ¼ץͼձͻͨڿƿ͹ر¼
	E_SDK_CFG_NAS,					//nas		//SDK_NAS_LIST
	E_SDK_CFG_NKB_DEVICE_LIST,		//豸
	E_SDK_CFG_PARKING_PORT = 240,	//ϵͳ˿ں  SDK_PortService
	E_SDK_CFG_NET_GBEYES,			///<Ųȫƽ̨ SDK_GbEyesCfg
	E_SDK_CFG_GLOBALEYE,			//ȫ SDK_DefaultResponse
	E_SDK_OPERATION_FISHEYE_MODIFY_CENTER,	//ԲУ SDK_Point
	E_SDK_OPERATION_UTC_TIME_SETTING = 244,	//UTCʱ---ӦṹSDK_SYSTEM_TIME
	E_SDK_CFG_INTELBRAS_SPECIAL_INFO,		//interbras tcp˿ں-----SDK_IntelBrasSpecialInfo
	E_SDK_CFG_SPVMN_PLATFORM_SIP,			//28181Эsip忨ip-------SDK_SIP_NET_IP_CONFIG
	E_SDK_CFG_FISH_LENS_PARAM,			//~R^------SDK_FishLensParam
}SDK_CONFIG_TYPE;


/// ¼
enum SDK_EventCodeTypes
{
	SDK_EVENT_CODE_INIT = 0,
	SDK_EVENT_CODE_LOCAL_ALARM = 1,		//ر(ⲿ)
	SDK_EVENT_CODE_NET_ALARM,			//籨
	SDK_EVENT_CODE_MANUAL_ALARM,		//ֶ
	SDK_EVENT_CODE_VIDEO_MOTION,		//̬
	SDK_EVENT_CODE_VIDEO_LOSS,			//Ƶʧ
	SDK_EVENT_CODE_VIDEO_BLIND,			//Ƶڵ
	SDK_EVENT_CODE_VIDEO_TITLE,		
	SDK_EVENT_CODE_VIDEO_SPLIT,
	SDK_EVENT_CODE_VIDEO_TOUR,
	SDK_EVENT_CODE_STORAGE_NOT_EXIST,	//洢豸
	SDK_EVENT_CODE_STORAGE_FAILURE,		//洢豸ʧ
	SDK_EVENT_CODE_LOW_SPACE,			//洢豸
	SDK_EVENT_CODE_NET_ABORT,
	SDK_EVENT_CODE_COMM,
	SDK_EVENT_CODE_STORAGE_READ_ERROR,	//洢豸
	SDK_EVENT_CODE_STORAGE_WRITE_ERROR,	//洢豸д
	SDK_EVENT_CODE_NET_IPCONFLICT,		//ipͻ
	SDK_EVENT_CODE_ALARM_EMERGENCY,
	SDK_EVENT_CODE_DEC_CONNECT,	
	SDK_EVENT_CODE_UPGRADE,
	SDK_EVENT_CODE_BACK_UP,
	SDK_EVENT_CODE_SHUT_DOWN,
	SDK_EVENT_CODE_REBOOT,
	SDK_EVENT_CODE_NEWFILE,
	SDK_EVENT_CODE_VideoAnalyze,
	SDK_EVENT_CODE_IPC_ALARM,
	SDK_EVENT_CODE_SPEED_ALARM,
	SDK_EVENT_CODE_GSENSOR_AlARM,
	SDK_EVENT_CODE_LOGIN_FAILED,		//¼ʧ
	SDK_EVENT_CODE_SERIAL_ALARM,
	SDK_EVENT_CODE_CONSSENSOR_ALARM, 	//Ʒ󶨵ⲿ豸
	SDK_EVENT_CODE_NR,
};
//! õ
enum SDK_ENCODE_TYPE_BY_RECORD
{
	SDK_ENCODE_TYPE_TIM = 0,
	SDK_ENCODE_TYPE_MTD = 1,
	SDK_ENCODE_TYPE_ALM = 2,
	SDK_ENCODE_TYPE_NUM = 3,
	SDK_ENCODE_TYPE_SNAP_TIMER = 0,
	SDK_ENCODE_TYPE_SNAP_TRIGGER = 1,
};
#define SDK_EXTRATYPES 3 //

//紫
enum SDK_TransferPolicy
{
	SDK_TRANSFER_POLICY_AUTO,			///< Ӧ
	SDK_TRANSFER_POLICY_QUALITY,		///< 
	SDK_TRANSFER_POLICY_FLUENCY,		///< 
	SDK_TRANSFER_POLICY_TRANSMISSION,	///< 
	SDK_TRANSFER_POLICY_NR,
};

/// 紫Э
enum SDK_NetTransProtocolType
{
	SDK_NET_TRANS_PRO_TCP = 0,
	SDK_NET_TRANS_PRO_UDP = 1,
};


typedef struct {
	int left;
	int top;
	int right;
	int bottom;
}sdkRect;

/// ƵʽԽ
typedef struct SDK_AudioInFormatConfig
{
	int iBitRate;	   ///< СkbpsΪλ192kbps128kbps
	int iSampleRate;   ///< ʣHzΪλ44100Hz
	int iSampleBit;    ///< λ
	int iEncodeType;   ///< 뷽ʽAudioEncodeTypes
}SDK_AudioInFormatConfig;

//Խʽ
typedef enum __TALK_CODING_TYPE
{
	TALK_DEFAULT = 0,
	TALK_PCM = 1,		//PCM
	TALK_G711a,			//G711a
	TALK_AMR,			//AMR
	TALK_G711u,			//G711u
	TALK_G726,			//G726
}TALK_CODING_TYPE;
//Խ
typedef struct H264_DVR_TALKDECODE_INFO
{
	TALK_CODING_TYPE		encodeType;		//
	int						nAudioBit;		//ʵʵֵʾ8λ ֵΪ8
	unsigned int			dwSampleRate;	//ʣ16k ֵΪ16000
	char					reserved[64];
}H264_DVR_TALKDECODE_INFO;


/// ϵͳʱṹ
typedef struct SDK_SYSTEM_TIME{
	int  year;		///< ꡣ   
	int  month;		///< £January = 1, February = 2, and so on.   
	int  day;		///< ա   
	int  wday;		///< ڣSunday = 0, Monday = 1, and so on   
	int  hour;		///< ʱ   
	int  minute;	///< ֡   
	int  second;	///< 롣   
	int  isdst;		///< ʱʶ   
}SDK_SYSTEM_TIME;

//¼ؽṹ
typedef struct tagSDK_TIMESECTION
{
	//!ʹ
	int enable;
	//!ʼʱ:Сʱ
	int startHour;
	//!ʼʱ:
	int	startMinute;
	//!ʼʱ:
	int	startSecond;
	//!ʱ:Сʱ
	int	endHour;
	//!ʱ:
	int	endMinute;
	//!ʱ:
	int	endSecond;
}SDK_TIMESECTION;

typedef struct{
	int dwYear;		//
	int dwMonth;	//
	int dwDay;		//
	int dwHour;		//ʱ
	int dwMinute;	//
    int dwSecond;	//
}H264_DVR_TIME,*LPH264_DVR_TIME;

//ʱṹ
typedef struct _NEW_NET_TIME
{
	unsigned int second		:6;		//		1-60		
	unsigned int minute		:6;		//		1-60		
	unsigned int hour		:5;		//	ʱ	1-24		
	unsigned int day		:5;		//		1-31		
	unsigned int month		:4;		//		1-12		
	unsigned int year		:6;		//		2000-2063	
}NEW_NET_TIME, *LPNET_TIME;
///< ʱṹ
typedef struct DSTPoint
{
	int	iYear;
	int	iMonth;
	int	iWeek;		///<1:first  to2 3 4 -1:last one   0:ʾʹðռķ[-1,4]
	int	iWeekDay;	///<weekday from sunday=0	[0, 6]
	int Hour;
	int Minute;
}DSTPoint;

typedef struct SDK_VIDEO_FORMAT
{
	int		iCompression;			//  ѹģʽ(Ƶʽ) enum SDK_CAPTURE_COMP_t 	
	int		iResolution;			//  ֱ öSDK_CAPTURE_SIZE_t
	int		iBitRateControl;		//   öSDK_capture_brc_t
	int		iQuality;				//  Ļ 1-6		
	int		nFPS;					//  ֵ֡NTSC/PAL,ʾһ֡		
	int		nBitRate;				//  0-4096k,бҪɿͻ˱棬豸ֻʵʵֵ±ꡣ
	int		iGOP;					//  I֮֡ļʱ䣬2-12 
} SDK_VIDEO_FORMAT;

typedef struct  SDK_AUDIO_FORMAT
{
	int		nBitRate;				//  kbps	
	int		nFrequency;				//  Ƶ	
	int		nMaxVolume;				//  ֵ
}SDK_AUDIO_FORMAT;

// ýʽ
typedef struct SDK_MEDIA_FORMAT
{
	SDK_VIDEO_FORMAT vfFormat;		//  Ƶʽ 			
	SDK_AUDIO_FORMAT afFormat;		//  Ƶʽ 
	bool	bVideoEnable;			//  Ƶ 
	bool	bAudioEnable;			//  Ƶ 	
} SDK_MEDIA_FORMAT;

typedef union {	//IP addr
	unsigned char	c[4];
	unsigned short	s[2];
	unsigned int 	l;
}CONFIG_IPAddress;








///////////////////ûʺŹؽṹ/////////////////////////////////
typedef struct _OPR_RIGHT
{
	char name[NET_MAX_USER_LENGTH];
}OPR_RIGHT;

typedef struct _USER_INFO
{
	int			rigthNum;
	char		rights[NET_MAX_RIGTH_NUM][NET_MAX_USER_LENGTH];
	char		Groupname[NET_MAX_USER_LENGTH];
	char		memo[NET_MAX_USER_LENGTH];
	char		name[NET_MAX_USER_LENGTH];
	char		passWord[NET_MAX_USER_LENGTH];
	bool		reserved;		//Ƿ
	bool		shareable;		//ûǷ 1-ã0-
}USER_INFO;

typedef struct _USER_GROUP_INFO
{
	int			rigthNum;
	char		memo[NET_MAX_USER_LENGTH]; 
	char		name[NET_MAX_USER_LENGTH];
	char		rights[NET_MAX_RIGTH_NUM][NET_MAX_USER_LENGTH];	//Ȩб
}USER_GROUP_INFO;

//ûϢýṹ
typedef struct _USER_MANAGE_INFO
{
	int					rigthNum;
	OPR_RIGHT			rightList[NET_MAX_RIGTH_NUM];
	int					groupNum;
	USER_GROUP_INFO		groupList[NET_MAX_GROUP_NUM];
	int					userNum;
	USER_INFO			userList[NET_MAX_USER_NUM];
}USER_MANAGE_INFO;

//޸û
typedef struct _CONF_MODIFYUSER
{
	char UserName[NET_MAX_USER_LENGTH];
	USER_INFO User;
}CONF_MODIFYUSER;

//޸
typedef struct _CONF_MODIFYGROUP
{
	char GroupName[NET_MAX_USER_LENGTH];
	USER_GROUP_INFO Group;
}CONF_MODIFYGROUP;


/// ޸û
struct _CONF_MODIFY_PSW
{
	char sUserName[NET_MAX_USER_LENGTH];
	char Password[NET_MAX_USER_LENGTH];
    char NewPassword[NET_MAX_USER_LENGTH];
};

//ͨҳṹ
typedef struct _SDK_CONFIG_NORMAL
{
	SDK_SYSTEM_TIME sysTime;		//ϵͳʱ

	int  iLocalNo;				///< :[0, 998] */
	int  iOverWrite;			///< Ӳʱ "OverWriteiOverWrite=1", "StopRecordiOverWrite=0" */		
	char cIranCalendarEnable;	///< Ƿ1ʾã0ʾ
	char cFontSize;				///< ʸС
	char reserved[2];
	char sMachineName[64];		///< 
	int  iVideoStartOutPut;		///< ģʽ */
	int  iAutoLogout;			///< ز˵Զע()	[0, 120]

	int  iVideoFormat;			///< Ƶʽ:PAL:0, NTSC:1, SECAM */
	int  iLanguage;				///< ѡ:English, SimpChinese, TradChinese, Italian, Spanish, Japanese, Russian, French, German */	
	int  iDateFormat;			///< ڸʽ:YYMMDD, MMDDYY, DDMMYY */
	int  iDateSeparator;		///< ڷָ:., -, / */
	int  iTimeFormat;			///< ʱʽ:12, 24 */
	int  iDSTRule;				///< ʱ 
	int  iWorkDay;				///< 
	DSTPoint dDSTStart;
	DSTPoint dDSTEnd;
}SDK_CONFIG_NORMAL;


//±
// 
typedef struct SDK_CONFIG_ENCODE
{
	SDK_MEDIA_FORMAT dstMainFmt[SDK_ENCODE_TYPE_NUM];	//  ʽ 	
	SDK_MEDIA_FORMAT dstExtraFmt[SDK_EXTRATYPES];		//  ʽ 
	SDK_MEDIA_FORMAT dstSnapFmt[SDK_ENCODE_TYPE_NUM];	//  ץͼʽ 
}SDK_CONFIG_ENCODE;

typedef struct  SDK_EncodeConfigAll
{
	SDK_CONFIG_ENCODE vEncodeConfigAll[NET_MAX_CHANNUM];
}SDK_EncodeConfigAll;


// 򻯰汾
/// ýʽ
typedef struct SDK_MEDIA_FORMAT_SIMPLIIFY
{
	SDK_VIDEO_FORMAT vfFormat;		//  Ƶʽ 			
	bool	bVideoEnable;			//  Ƶ 
	bool	bAudioEnable;			//  Ƶ 	
}SDK_MEDIA_FORMAT_SIMPLIIFY;

/// 
typedef struct SDK_CONFIG_ENCODE_SIMPLIIFY
{
	SDK_MEDIA_FORMAT dstMainFmt;	//  ʽ 	
	SDK_MEDIA_FORMAT dstExtraFmt;	//  ʽ 
}SDK_CONFIG_ENCODE_SIMPLIIFY;

/// ȫͨ
typedef struct SDK_EncodeConfigAll_SIMPLIIFY
{
	SDK_CONFIG_ENCODE_SIMPLIIFY vEncodeConfigAll[NET_MAX_CHANNUM];
}SDK_EncodeConfigAll_SIMPLIIFY;


typedef struct  SDK_CombineEncodeConfigAll
{
	SDK_CONFIG_ENCODE vEncodeConfigAll[NET_MAX_COMBINE_NUM];
}SDK_CombineEncodeConfigAll;

/// ϱģʽ
typedef struct SDK_CombEncodeParam
{
	int iEncodeMode;	 //CombineEncodeMode
}SDK_CombEncodeParam;

typedef struct SDK_CombEncodeModeAll
{
	SDK_CombEncodeParam vEncodeParam[NET_MAX_COMBINE_NUM];
}SDK_CombEncodeModeAll;

//!Ƶṹ
typedef struct  SDK_VIDEO_WIDGET
{
	unsigned int rgbaFrontground;	///< ǰMakeRGB͸	
	unsigned int rgbaBackground;	///< ĺMakeRGB͸	
	sdkRect	rcRelativePos;			///< ߾ı*8191
	bool	bPreviewBlend;			///< Ԥ,Ƿʾ1ʾ 0
	bool	bEncodeBlend;			///< 
}SDK_VIDEO_WIDGET;

//!Ƶ
typedef struct SDK_CONFIG_VIDEOWIDGET
{
	SDK_VIDEO_WIDGET	dstCovers[NET_COVERNUM];
	SDK_VIDEO_WIDGET	ChannelTitle; //ͨ
	SDK_VIDEO_WIDGET	TimeTitle;	  //豸ʱ
	struct 
	{
		char strName[NET_NAME_PASSWORD_LEN];
#ifdef WIN32
 		__int64 iSerialNo;	
#else
		long long iSerialNo;	
#endif
	}ChannelName;			///< ͨ
	int		iCoverNum;		///< ǰͨмӵ */
}SDK_CONFIG_VIDEOWIDGET;

/// Ƶ(ģʽԻ)
typedef struct SDK_VideoWidgetConfigAll
{
	SDK_CONFIG_VIDEOWIDGET vVideoWidegetConfigAll[NET_MAX_CHANNUM];
}SDK_VideoWidgetConfigAll;

//Ƶɫ
typedef struct SDK_VIDEOCOLOR_PARAM
{
	int	nBrightness;		///< 	0-100
	int	nContrast;			///< Աȶ	0-100
	int	nSaturation;		///< Ͷ	0-100
	int	nHue;				///< ɫ	0-100
	int	mGain;				///< 	0-100 ڣλ1ʾԶ		
	int	mWhitebalance;		///< Զ׵ƽƣbit7λʾԶ.0x0,0x1,0x2ֱ,,ߵȼ
	int nAcutance;          ///<    0-15
}SDK_VIDEOCOLOR_PARAM;
///< Ƶɫ
typedef struct SDK_VIDEOCOLOR
{
	SDK_TIMESECTION			tsTimeSection;		/// ʱ
	SDK_VIDEOCOLOR_PARAM	dstColor;			/// ɫ
	int					iEnable;
}SDK_VIDEOCOLOR;

typedef struct SDK_CONFIG_VIDEOCOLOR
{
	SDK_VIDEOCOLOR dstVideoColor[NET_N_MIN_TSECT];
}SDK_CONFIG_VIDEOCOLOR;

typedef struct SDK_VideoColorConfigAll
{
	SDK_CONFIG_VIDEOCOLOR vVideoColorAll[NET_MAX_CHANNUM];
}SDK_VideoColorConfigAll;


/// ͨƱ
typedef struct SDK_ChannelNameConfigAll
{
	char channelTitle[NET_MAX_CHANNUM][NET_NAME_PASSWORD_LEN];
}SDK_ChannelNameConfigAll;

//ģʽ
typedef struct SDK_GUISetConfig
{
	int iWindowAlpha;			///< ͸	[128, 255]
	bool bTimeTitleEn;			///< ʱʾʹ
	bool bChannelTitleEn;		///< ͨʾʹ	
	bool bAlarmStatus;			///<  ״̬
	bool bRecordStatus;			///<  ¼״̬ʾʹ
	bool bChanStateRecEn;		///< ¼־ʾʹ
	bool bChanStateVlsEn;		///< Ƶʧ־ʾʹ
	bool bChanStateLckEn;		///< ͨ־ʾʹ	
	bool bChanStateMtdEn;		///< ̬־ʾʹ
	bool bBitRateEn;			///< ʾʹ
	bool bRemoteEnable;			///< ңʹ
	bool bDeflick;				///< 
}SDK_GUISetConfig;


////!ͨ
typedef struct SDK_CONFIG_NET_COMMON
{
	//!
	char HostName[NET_NAME_PASSWORD_LEN];
	//!IP
	CONFIG_IPAddress HostIP;
	//!
	CONFIG_IPAddress Submask;
	//!IP
	CONFIG_IPAddress Gateway;
	//!HTTP˿
	int HttpPort;
	//!TCP˿
	int TCPPort;	
	//!SSL˿
	int SSLPort;
	//!UDP˿
	int UDPPort;
	//!
	int MaxConn;
	//!Э {"TCP","UDP","MCAST",}
	int MonMode;
	//!޶ֵ
	int MaxBps;
	//!
	//char TransferPlan[NET_NAME_PASSWORD_LEN];
	int TransferPlan;

	//!Ƿø¼ز
	bool bUseHSDownLoad;

	//!MACַ
	char sMac[NET_MAX_MAC_LEN];
}SDK_CONFIG_NET_COMMON;

 typedef enum SDK_DevType
 {
 	SDK_DEV_TYPE_IPC,
 	SDK_DEV_TYPE_DVR,
	SDK_DEV_TYPE_HVR,
	SDK_DEV_TYPE_POEIPC,
	SDK_DEV_TYPE_NVR,
	SDK_DEV_TYPE_RTSPIPC,
 	SDK_DEV_TYPE_NR
 }SDK_DevType;


////!ͨ --
typedef struct SDK_CONFIG_NET_COMMON_V2
{
	//!
	char HostName[NET_NAME_PASSWORD_LEN];
	//!IP
	CONFIG_IPAddress HostIP;
	//!
	CONFIG_IPAddress Submask;
	//!IP
	CONFIG_IPAddress Gateway;
	char pLocalLinkAddr[32];	//·ַ
	char pAddr[64];				//ipv6ַ
	char pGateway[64];
	//!HTTP˿
	int HttpPort;
	//!TCP˿
	int TCPPort;	
	//!SSL˿
	int SSLPort;
	//!UDP˿
	int UDPPort;
	//!
	int MaxConn;
	//!Э {"TCP","UDP","MCAST",}
	int MonMode;
	//!޶ֵ
	int MaxBps;
	//!
	//char TransferPlan[NET_NAME_PASSWORD_LEN];
	int  TransferPlan;						///
	bool bUseHSDownLoad;					///Ƿø¼ز
	char sMac[NET_MAX_MAC_LEN];				///MACַ
	char sSn[NET_MAX_MAC_LEN]; 				///к
#ifndef WIN32
	int  DeviceType;   						///豸,ֻǲͨ豸
#endif

	int ChannelNum;			///ͨ
	int	Device_Type;		///豸ͣenum SDK_DevType
	char Resume[56];		///

}SDK_CONFIG_NET_COMMON_V2;

////!IP --
typedef struct SDK_CONFIG_NET_COMMON_V3
{
    char HostName[NET_NAME_PASSWORD_LEN];	/// 
    CONFIG_IPAddress HostIP;				///IP
    CONFIG_IPAddress Submask;				///
    CONFIG_IPAddress Gateway;				///IP  
    int  HttpPort;							///HTTP˿   
    int  TCPPort;							///TCP˿   
    int  SSLPort;							///SSL˿
    int  UDPPort;							///UDP˿  
    int  MaxConn;							///
    int  MonMode;							///Э {"TCP","UDP","MCAST",?}
    int  MaxBps;								///޶ֵ
    //char TransferPlan[NET_NAME_PASSWORD_LEN];
    int  TransferPlan;						///
    bool bUseHSDownLoad; 					///Ƿø¼ز
    char sMac[NET_MAX_MAC_LEN];				///MACַ
    char UserName[NET_NAME_PASSWORD_LEN];	///豸û
    char Password[NET_NAME_PASSWORD_LEN];	///豸
    char LocalMac[NET_MAX_MAC_LEN];
    int  nPasswordType;
	char Resume[92];						///
}SDK_CONFIG_NET_COMMON_V3;

//DHCP
#define SDK_MAX_ETH_NUM 4
typedef struct SDK_NetDHCPConfig
{
    bool bEnable;
    char ifName[32];
}SDK_NetDHCPConfig;
/// DHCP
typedef struct SDK_NetDHCPConfigAll
{
    SDK_NetDHCPConfig vNetDHCPConfig[SDK_MAX_ETH_NUM];
}SDK_NetDHCPConfigAll;

///< DNS
typedef struct SDK_NetDNSConfig
{
    CONFIG_IPAddress		PrimaryDNS;
    CONFIG_IPAddress		SecondaryDNS;
}SDK_NetDNSConfig;
///< ṹ
typedef struct SDK_RemoteServerConfig
{
    char ServerName[NET_NAME_PASSWORD_LEN];		///< 
    CONFIG_IPAddress ip;						///< IPַ
    int Port;									///< ˿ں
    char UserName[NET_NAME_PASSWORD_LEN];		///< û
    char Password[NET_NAME_PASSWORD_LEN];		///< 
    bool Anonymity;								///< Ƿ¼
}SDK_RemoteServerConfig;
///< IPȨ
typedef struct SDK_NetIPFilterConfig
{
    bool Enable;											///< Ƿ
    CONFIG_IPAddress BannedList[NET_MAX_FILTERIP_NUM];		///< б
    CONFIG_IPAddress TrustList[NET_MAX_FILTERIP_NUM];		///< б
}SDK_NetIPFilterConfig;

///< 鲥
typedef struct SDK_NetMultiCastConfig
{
    bool Enable;						///< Ƿ
    SDK_RemoteServerConfig Server;		///< 鲥
}SDK_NetMultiCastConfig;

///< pppoe
typedef struct SDK_NetPPPoEConfig
{
    bool Enable;						///< Ƿ
    SDK_RemoteServerConfig Server;		///< PPPOE
    CONFIG_IPAddress addr;				///< źõIPַ
}SDK_NetPPPoEConfig;

///< DDNS
typedef struct SDK_NetDDNSConfig
{
    bool Enable;							///< Ƿ
    bool Online;							///< Ƿ
    char DDNSKey[NET_NAME_PASSWORD_LEN];	///< DDNS, Ŀǰ: YouTang
    char HostName[NET_NAME_PASSWORD_LEN];	///< 
    SDK_RemoteServerConfig Server;			///< DDNS
    
}SDK_NetDDNSConfig;

///< DDNS
typedef struct SDK_NetDDNSConfigALL
{
    SDK_NetDDNSConfig ddnsConfig[NET_MAX_DDNS_TYPE];
}SDK_NetDDNSConfigALL;

///< FTP
typedef struct SDK_FtpServerConfig{
    bool bEnable;        					///< ʹ
    SDK_RemoteServerConfig Server;			///< FTP
    char cRemoteDir[NET_MAX_PATH_LENGTH];	///< ԶĿ¼
    int  iMaxFileLen;						///< ļ󳤶
}SDK_FtpServerConfig;

///< NTP
typedef struct SDK_NetNTPConfig
{
    ///< Ƿ
    bool Enable;
    ///< PPPOE
    SDK_RemoteServerConfig Server;
    ///< 
    int  UpdatePeriod;
    ///< ʱ
    int  TimeZone;
}SDK_NetNTPConfig;
#define  NET_MAX_EMAIL_TITLE_LEN 64
#define  NET_MAX_EMAIL_RECIEVERS  5
#define  NET_EMAIL_ADDR_LEN  64

///< EMAIL
typedef struct SDK_NetEmailConfig
{
    ///< Ƿ
    bool Enable;
    ///< smtp ַʹַʽ
    ///< ip,Ҳ
    SDK_RemoteServerConfig Server;
    bool bUseSSL;
    ///< ͵ַ
    char SendAddr[NET_EMAIL_ADDR_LEN];
    ///< ˵ַ
    char Recievers[NET_MAX_EMAIL_RECIEVERS][NET_EMAIL_ADDR_LEN];
    ///< ʼ
    char Title[NET_MAX_EMAIL_TITLE_LEN];
    ///< emailЧʱ
    SDK_TIMESECTION Schedule[NET_N_MIN_TSECT];
}SDK_NetEmailConfig;

///< ARSP(ע)
typedef struct SDK_NetARSPConfig
{
    bool bEnable;							///< Ƿ
    char sARSPKey[NET_NAME_PASSWORD_LEN];	///< DNS
    int  iInterval;							///< ʱ
    char sURL[NET_NAME_PASSWORD_LEN];    	///< 
    SDK_RemoteServerConfig Server;			///< DDNS
    int  nHttpPort;                  		///< HTTP˿
}SDK_NetARSPConfig;

typedef struct SDK_NetARSPConfigAll
{
    SDK_NetARSPConfig vNetARSPConfigAll[NET_MAX_ARSP_TYPE];
}SDK_NetARSPConfigAll;

///< ַ
typedef struct SDK_NetDecoderConfig
{
    bool Enable;							///< Ƿ
    char UserName[NET_NAME_PASSWORD_LEN];	///< DDNS, Ŀǰ: YouTang
    char PassWord[NET_NAME_PASSWORD_LEN];	///< 
    char Address[NET_NAME_PASSWORD_LEN];
    int  Protocol;
    int  Port;								///< Ӷ˿
    int  Channel;							///< ͨ
    int  Interval;                       	///< Ѳļʱ(s)
}SDK_NetDecoderConfig;

/// ͨĽַ
typedef struct SDK_NetDecoderConfigAll
{
    SDK_NetDecoderConfig vNetDecoderConfig[NET_MAX_DECORDR_CH];
}SDK_NetDecoderConfigAll;


/// ַV2汾
typedef struct SDK_NetDecoderConfig_V2
{
    int nTotalNum;            //ЧΪNET_MAX_CHANNUM
    SDK_NetDecoderConfig vNetDecoderConfig[NET_MAX_CHANNUM];
}SDK_NetDecoderConfig_V2;

/// ͨĽַV2汾
typedef struct SDK_NetDecoderConfigAll_V2
{
    SDK_NetDecoderConfig_V2 vNetDecoderArray[NET_MAX_DECORDR_CH];
}SDK_NetDecoderConfigAll_V2;


/// ͨ
enum SDK_CaptureChannelTypes 
{
	SDK_CAPTURE_CHN_MAIN = 0,		///< ͨ		1 
	SDK_CAPTURE_CHN_2END = 1,		///< ͨ		2 
	SDK_CAPTURE_CHN_3IRD = 2,		///< ͨ		3 
	SDK_CAPTURE_CHN_4RTH = 3,		///< ͨ		4 
	SDK_CAPTURE_CHN_JPEG = 4,		///< ͨ		JPEGץͼ 
	SDK_CAPTURE_CHN_NR,
};

///< ַ
typedef struct SDK_NetDecorderConfigV3
{
    bool Enable;							///< Ƿ
    char UserName[NET_NAME_PASSWORD_LEN];	///< DDNS, Ŀǰ: YouTang
    char PassWord[NET_NAME_PASSWORD_LEN];	///< 
    char Address[NET_NAME_URL_LEN];
    int  Protocol;							///enum SDK_TransferProtocol_V2
    int  Port;								///< Ӷ˿
    int  Channel;							///< ͨ
    int  Interval;                       	///< Ѳļʱ(s),0:ʾ
    char ConfName[NET_NAME_PASSWORD_LEN];	///<
    int  DevType;							///<豸
    int  StreamType;						///<ӵ enum SDK_CaptureChannelTypes
	char MainRtspUrl[NET_NAME_URL_LEN];		///<rtspЭʱʾǰ豸ַ
	char SubRtspUrl[NET_NAME_URL_LEN];		///<rtspЭʱʾǰ豸ĸַ
}SDK_NetDecorderConfigV3;

/**/
enum SDK_DecorderConnType
{
    SDK_CONN_SINGLE = 0, 	/**/
    SDK_CONN_MULTI = 1,		/*Ѳ*/
    SDK_CONN_TYPE_NR,
};

/*ͨ*/
typedef struct SDK_NetDigitChnConfig
{
    bool Enable;									/*ͨǷ*/
    int  ConnType;									/*ͣȡDecoderConnectTypeֵ*/
    int  TourIntv;									/*ʱѲ*/
    unsigned int SingleConnId;						/*ʱID, 1ʼ0ʾЧ*/
    bool EnCheckTime;								/*ʱ*/
    SDK_NetDecorderConfigV3 NetDecorderConf[32]; 	/*豸ͨñ*/
    int  nNetDeorde; 								/* жٸ */
	bool EnSynchResolution;							//ֱͬʹܿ,0ʾ򿪣1ʾر
}SDK_NetDigitChnConfig;

/*ͨ*/
typedef struct SDK_NetDecorderConfigAll_V3
{
    SDK_NetDigitChnConfig DigitChnConf[NET_MAX_DECORDR_CH];
}SDK_NetDecorderConfigAll_V3;

typedef struct SDK_HVR_CHNCAP
{
    int nD1Chn;					// ֵ֧D1·
    int n960HChn;				// ֵ֧960H·
    int n720PChn;				// ֵ֧720P·
    int n1080PChn;				// ֵ֧1080P·
    int nCIFChn;				//ֵ֧CIFͨ
    int nHD1Chn;				//ֵ֧HD1ͨ
    unsigned char nPlayChn; 	//ֻ֧ط·
    unsigned char nDigiTalChn; 	//֧ͨ·
    unsigned char n960PChn; 	//ֵ֧960Pͨ
    unsigned char n3MChn; 		//ֵ֧3Mͨ
    unsigned char n5MChn; 		//ֵ֧5Mͨ
    unsigned char nWUXGAChn; 	//ֵ֧WUXGAͨ
    unsigned char n1080NChn;	//֧1080Nͨ
    unsigned char n4MChn;		//֧4Mͨ
    //unsigned char nResChar[2]; //
}SDK_HVR_CHNCAP, *SDK_PHVR_CHNCAP;

typedef struct SDK_HVR_CHNCAPV2
{
    unsigned char nD1Chn;		// ֵ֧D1·
    unsigned char n960HChn;		// ֵ֧960H·
    unsigned char n720PChn;		// ֵ֧720P·
    unsigned char n1080PChn;	// ֵ֧1080P·
    unsigned char nCIFChn;		//ֵ֧CIFͨ
    unsigned char nHD1Chn;		//ֵ֧HD1ͨ
    unsigned char nPlayChn; 	//ֻ֧ط·
    unsigned char nDigiTalChn; 	//֧ͨ·
    unsigned char n960PChn; 	//ֵ֧960Pͨ
    unsigned char n3MChn; 		//ֵ֧3Mͨ
    unsigned char n5MChn; 		//ֵ֧5Mͨ
    unsigned char nWUXGAChn; 	//ֵ֧WUXGAͨ
    unsigned char n1080NChn;	//֧1080Nͨ
    unsigned char n4MChn;		//֧4Mͨ
    unsigned char n720NChn;		//֧720Nͨ
	unsigned char nWSVGAChn;	//֧WSVGA(1024*576)ͨ
	unsigned char n4KChn;		//ֵ֧4Kͨ
	unsigned char n3M_NChn;		//ֵ֧3M_Nͨ
	unsigned char n4M_NChn;		//ֵ֧4M_Nͨ
	unsigned char n5M_NChn;		//ֵ֧5M_Nͨ
	unsigned char n4K_NChn;		//ֵ֧4K_Nͨ
	unsigned char nRes[11];
}SDK_HVR_CHNCAPV2, *SDK_PHVR_CHNCAPV2;

typedef struct SDK_CAPTURE_HVRCAP  	//CAPTURE_HVRCAPV2Ϊ˼ϵı
{
    SDK_HVR_CHNCAP DigitalCap;		// ֵ֧ͨϢ
    SDK_HVR_CHNCAP AnalogCap;		// ֵ֧ģͨϢ
}SDK_CAPTURE_HVRCAP, *SDK_PCAPTURE_HVRCAP;

typedef struct SDK_CAPTURE_HVRCAPV2
{
    SDK_HVR_CHNCAPV2 DigitalCap;	// ֵ֧ͨϢ
    SDK_HVR_CHNCAPV2 AnalogCap;		// ֵ֧ģͨϢ
}SDK_CAPTURE_HVRCAPV2, *SDK_PCAPTURE_HVRCAPV2;

typedef struct SDK_CAPTURE_TOTAL_HVRCAP //CAPTURE_TOTAL_HVRCAPV2Ϊ˼ϵı
{
    int		nHVRCap;									// ʵֵ֧ģʽ
    SDK_CAPTURE_HVRCAP	HVRCap[MAX_HVR_CHNCAP_CHN];		// ģʽĻ
}SDK_CAPTURE_TOTAL_HVRCAP, *SDK_PCAPTURE_TOTAL_HVRCAP;

typedef struct SDK_CAPTURE_TOTAL_HVRCAPV2
{
    int		nHVRCap;									// ʵֵ֧ģʽ
    SDK_CAPTURE_HVRCAPV2	HVRCap[MAX_HVR_CHNCAP_CHN];	// ģʽĻ
}SDK_CAPTURE_TOTAL_HVRCAPV2, *SDK_PCAPTURE_TOTAL_HVRCAPV2;

//ͨģʽ
typedef struct SDK_NetDecorderChnModeConfig
{
    SDK_CAPTURE_TOTAL_HVRCAPV2 	HVRTotalCap;
    int HVRCurCapMode;
}SDK_NetDecorderChnModeConfig;


/*ͨ״̬*/
typedef struct SDK_NetDecorderChnStatus
{
    char ChnName[NET_NAME_PASSWORD_LEN];
    char pMaxResName[50];
    char pCurResName[50];
    char pStatus[50];
}SDK_NetDecorderChnStatus;

/*ͨ״̬*/
typedef struct SDK_NetDecorderChnStatusAll
{
    SDK_NetDecorderChnStatus ChnStatusAll[NET_MAX_DECORDR_CH];
}SDK_NetDecorderChnStatusAll;

//Pos豸
enum SDK_PosDevType
{
    SDK_POS_TYPE_MANY_LINES, //ܽŰƷϢһ͹
    SDK_POS_TYPE_ONE_LINE,   //ÿͳһƷͰѸƷϢ͹
    SDK_POS_NR
};

//ֱʽ
enum SDK_WordEncode
{
    SDK_WORD_ENCODE_GB2312,  //ֱGB2312
    SDK_WORD_ENCODE_UNICODE, // Unicode
    SDK_WORD_ENCODE_UTF8,    //UTF-8
};

#define SDK_MAX_POS_FUNC_KEYWORDS 4
// pos
typedef struct SDK_NetPosConfig
{
    bool Enable;			/*posͨʹ*/
    int  Devtype;			//pos
    int  Protocol;			//ͨЭ
    int  Port;				//Э˿ں
    bool SnapEnable;		//ץʹ
    int  StartLine;			//յϢӶпʼʾ
    int  WordEncodeType;	//ֱʽöֵ WordEncodeType ʾ
    bool KeyWordEnable; 	//ؼд־ʹ
    char SearchWrod[SDK_MAX_POS_FUNC_KEYWORDS][16]; //Ҫӵ־ĵ
    int  HideTime;         	//ͨʾposϢʱ,λ룬0ʾԶ
    int  res;				//
}SDK_NetPosConfig;
//pos
typedef struct SDK_NetPosConfigAll
{
    SDK_NetPosConfig PosConfig[MAX_HVR_CHNCAP_CHN];
}SDK_NetPosConfigAll;


///< 3G
typedef struct SDK_Net3GConfig
{
    bool bEnable;			  				///< ģʹܱ־
    int  iNetType;			  				///< 
    char sAPN[NET_NAME_PASSWORD_LEN];		///< 
    char sDialNum[NET_NAME_PASSWORD_LEN];   ///< ź
    char sUserName[NET_NAME_PASSWORD_LEN];  ///< û
    char sPassword[NET_NAME_PASSWORD_LEN];  ///< 
    CONFIG_IPAddress addr;			  		///< źõIPַ
}SDK_Net3GConfig;

///< ֻð
typedef struct SDK_NetMoblieConfig
{
    bool bEnable;						///< Ƿ
    SDK_RemoteServerConfig Server;		///< 
}SDK_NetMoblieConfig;

//RTSP
typedef struct SDK_NetRTSPConfig
{
    bool bServer;
    bool bClient;
    SDK_RemoteServerConfig Server;		///< ģʽ
    SDK_RemoteServerConfig Client;		///< ͻģʽ
}SDK_NetRTSPConfig;

///< UPNP
typedef struct SDK_NetUPNPConfig
{
    bool bEnable;				///< ʹܱ־
    bool bState;				///< ״̬, 1: OK 0: NOK
    int  iHTTPPort;				///< HTTPӳĶ˿
    int  iMediaPort;			///< ýӳĶ˿
    int  iMobliePort;			///< ֻӳĶ˿
}SDK_NetUPNPConfig;

///< WIFI
typedef struct SDK_NetWifiConfig
{
    bool bEnable;
    char sSSID[36];            	///< SSID Number
    int  nChannel;             	///< channel
    char sNetType[32];         	///< Infra, Adhoc
    char sEncrypType[32];      	///< NONE, WEP, TKIP, AES
    char sAuth[32];            	///< OPEN, SHARED, WEPAUTO, WPAPSK, WPA2PSK, WPANONE, WPA, WPA2
    int  nKeyType;             	///< 0:Hex 1:ASCII
    char sKeys[NET_IW_ENCODING_TOKEN_MAX];
    CONFIG_IPAddress HostIP;	///< host ip
    CONFIG_IPAddress Submask;	///< netmask
    CONFIG_IPAddress Gateway;	///< gateway
}SDK_NetWifiConfig;

enum SDK_RSSI_SINGNAL
{
    SDK_RSSI_NO_SIGNAL,    //<= -90db
    SDK_RSSI_VERY_LOW,     //<= -81db
    SDK_RSSI_LOW,          //<= -71db
    SDK_RSSI_GOOD,         //<= -67db
    SDK_RSSI_VERY_GOOD,    //<= -57db
    SDK_RSSI_EXCELLENT     //<= -57db
};

typedef struct SDK_NetWifiDevice
{
    char sSSID[36];            //SSID Number
    int  nRSSI;                //SEE SDK_RSSI_SINGNAL
    int  nChannel;
    char sNetType[32];         //Infra, Adhoc
    char sEncrypType[32];      //NONE, WEP, TKIP, AES
    char sAuth[32];            //OPEN, SHARED, WEPAUTO, WPAPSK, WPA2PSK, WPANONE, WPA, WPA2
}SDK_NetWifiDevice;

typedef struct SDK_NetWifiDeviceAll
{
    int nDevNumber;
    SDK_NetWifiDevice vNetWifiDeviceAll[NET_MAX_AP_NUMBER];
}SDK_NetWifiDeviceAll;

///< 
typedef struct SDK_NetAlarmCenterConfig
{
    bool bEnable;									///< Ƿ
    char sAlarmServerKey[NET_NAME_PASSWORD_LEN];	///< Э,
    SDK_RemoteServerConfig Server;					///< ķ
    bool bAlarm;
    bool bLog;
}SDK_NetAlarmCenterConfig;

typedef struct SDK_NetAlarmServerConfigAll
{
    SDK_NetAlarmCenterConfig vAlarmServerConfigAll[NET_MAX_ALARMSERVER_TYPE];
}SDK_NetAlarmServerConfigAll;


//Żͨ
typedef struct SDK_CONFIG_NET_MEGA
{
    bool bEnable;
    bool bNetManEnable;
    CONFIG_IPAddress ServerIP;
    int  iServerPort;
    char sDeviceId[32];
    char sUserName[24];
    char sPasswd[32];
    int  iMaxCon;
    int  iVideoPort;
    int  iAudioPort;
    int  iMsgPort;
    int  iUpdatePort;
}SDK_CONFIG_NET_MEGA;

// ƽ̨
typedef struct SDK_CONFIG_NET_XINGWANG
{
    bool bEnable;
    bool bSyncTime;
    bool bSubStream;
    CONFIG_IPAddress ServerIP;
    int  iServerPort;
    int  iDownLoadPort;
    char sPasswd[32];
    char szSID[32];
}SDK_CONFIG_NET_XINGWANG;

// ƽ̨
typedef struct SDK_CONFIG_NET_SHISOU
{
    bool bEnable;
    SDK_RemoteServerConfig Server;
    char szSID[NET_MAX_USERNAME_LENGTH];
}SDK_CONFIG_NET_SHISOU;

// VVEYEƽ̨
typedef struct SDK_CONFIG_NET_VVEYE
{
    bool bEnable;
    bool bCorpEnable;            //ֻʹҵʱҪServer
    SDK_RemoteServerConfig Server;
    char szDeviceName[NET_MAX_USERNAME_LENGTH];
}SDK_CONFIG_NET_VVEYE;

// Ϣ
enum SDK_AlarmCenterMsgType
{
    SDK_ALARMCENTER_ALARM,
    SDK_ALARMCENTER_LOG,
};

// Ϣ
enum SDK_AlarmCenterStatus
{
    SDK_AC_START,
    SDK_AC_STOP,
};

// 澯Ϣ
typedef struct SDK_NetAlarmCenterMsg
{
    CONFIG_IPAddress HostIP;			///< 豸IP
    int  nChannel;                  	///< ͨ
    int  nType;                     	///<  AlarmCenterMsgType
    int  nStatus;                   	///< ״̬ AlarmCenterStatus
    SDK_SYSTEM_TIME Time;           	///< ʱ
    char sEvent[NET_MAX_INFO_LEN];  	///< ¼
    char sSerialID[NET_MAX_MAC_LEN]; 	///< 豸к
    char sDescrip[NET_MAX_INFO_LEN];  	///< 
}SDK_NetAlarmCenterMsg;

/// Ϣ
typedef struct SDK_EncodeInfo
{
    bool bEnable;						///< ʹ
    bool bHaveAudio;					///< Ƿ֧Ƶ
    int  iStreamType;					///< ͣcapture_channel_t
    unsigned int uiCompression;			///< capture_comp_t
    unsigned int uiResolution;			///< SDK_CAPTURE_SIZE_t
}SDK_EncodeInfo;

/// 
typedef struct CONFIG_EncodeAbility
{
    unsigned int iMaxEncodePower;							///< ֵ֧
    int iChannelMaxSetSync;									///< ÿֱͨǷҪͬ 0-ͬ, 1 -ͬ
    unsigned int nMaxPowerPerChannel[NET_MAX_CHANNUM];		///< ÿֵ֧ͨ߱
    unsigned int ImageSizePerChannel[NET_MAX_CHANNUM];		///< ÿֵ֧ͨͼֱ
    unsigned int ExImageSizePerChannel[NET_MAX_CHANNUM];	///< ÿֵ֧ͨĸͼֱ
    SDK_EncodeInfo vEncodeInfo[SDK_CHL_FUNCTION_NUM];		///< Ϣ,ʱ4
    SDK_EncodeInfo vCombEncInfo[SDK_CHL_FUNCTION_NUM];		///< ϱϢ,ʱ4
    int	iMaxBps;											///< Kbps
    unsigned int ExImageSizePerChannelEx[NET_MAX_CHANNUM][SDK_CAPTURE_SIZE_EXT_V3_NR];	///< ÿֵ֧ͨĸͼֱ
}CONFIG_EncodeAbility;

// Э
enum SDK_CommProtocol
{
    SDK_CONSOLE = 0,
    SDK_KEYBOARD,
    SDK_COM_TYPES,
};
/// Э
typedef struct SDK_COMMFUNC
{
    //ÿЭ64ַ
    int nProNum;
    char vCommProtocol[100][32];
}SDK_COMMFUNC;

/// ̨Э
typedef struct SDK_PTZPROTOCOLFUNC
{
    //ÿЭ64ַ
    int nProNum;
    char vPTZProtocol[100][NET_MAX_PTZ_PROTOCOL_LENGTH];
}SDK_PTZPROTOCOLFUNC;

/// ڵ
typedef struct SDK_BlindDetectFunction
{
    int iBlindConverNum;	///< ڵ
}SDK_BlindDetectFunction;

/// 
typedef struct SDK_MotionDetectFunction
{
    int iGridRow;
    int iGridColumn;
}SDK_MotionDetectFunction;

/// ֵ֧DDNS
typedef struct SDK_DDNSServiceFunction
{
    int  nTypeNum;
    char vDDNSType[NET_MAX_DDNS_TYPE][64];
}SDK_DDNSServiceFunction;

/// ֧
typedef struct SDK_MultiLangFunction
{
    //ÿЭ64ַ
    int nLangNum;
    char vLanguageName[128][64];
}SDK_MultiLangFunction;

/// ֵ֧Ƶʽ
typedef struct SDK_MultiVstd
{
    //ÿЭ3ַ
    int nVstdNum;
    char vVstdName[3][64];
}SDK_MultiVstd;

/// 빦
enum SDK_EncodeFunctionTypes
{
    SDK_ENCODE_FUNCTION_TYPE_DOUBLE_STREAM,		///< ˫
    SDK_ENCODE_FUNCTION_TYPE_COMBINE_STREAM,	///< ϱ빦
    SDK_ENCODE_FUNCTION_TYPE_SNAP_STREAM,		///< ץͼ
    SDK_ENCODE_FUNCTION_TYPE_WATER_MARK,		///< ˮӡ
    SDK_ENCODE_FUNCTION_TYPE_IFRAME_RANGE,		///< I֡
    SDK_ENCODE_FUNCTION_TYPE_LOW_BITRATE,   	///< 
    SDK_ENCODE_FUNCTION_TYPE_NR,
};

/// 
enum SDK_AlarmFucntionTypes
{
    SDK_ALARM_FUNCTION_TYPE_MOTION_DETECT,		///< ̬
    SDK_ALARM_FUNCTION_TYPE_BLIND_DETECT,		///< ڵ
    SDK_ALARM_FUNCTION_TYPE_LOSS_DETECT,		///< ʧ
    SDK_ALARM_FUNCTION_TYPE_LOCAL_ALARM,		///< ر
    SDK_ALARM_FUNCTION_TYPE_NET_ALARM,			///< 籨
    SDK_ALARM_FUNCTION_TYPE_IP_CONFLICT,		///< IPַͻ
    SDK_ALARM_FUNCTION_TYPE_NET_ABORT,			///< 쳣
    SDK_ALARM_FUNCTION_TYPE_STORAGE_NOTEXIST,	///< 洢豸
    SDK_ALARM_FUNCTION_TYPE_STORAGE_LOWSPACE,	///< 洢豸
    SDK_ALARM_FUNCTION_TYPE_STORAGE_FAILURE,	///< 洢豸ʧ
    SDK_ALARM_FUNCTION_TYPE_VIDEOANALYSE,		///< Ƶ
    SDK_ALARM_FUNCTION_TYPE_NET_ABORT_EXTEND,	///< 쳣չ
    SDK_ALARM_FUNCTION_TYPE_IPC_ALARM,			///< IPC
	SDK_ALARM_FUNCTION_TYPE_CONSUMER_433ALARM,	// òƷ433豸
	SDK_ALARM_FUNCTION_TYPE_CONSUMER_REMOTE, 	// òƷ2.4G ң
    SDK_ALARM_FUNCTION_TYPE_NR
};

/// 
enum SDK_NetServerTypes
{
    SDK_NET_SERVER_TYPES_IPFILTER,			///< ׺
    SDK_NET_SERVER_TYPES_DHCP,				///< DHCP
    SDK_NET_SERVER_TYPES_DDNS,				///< DDNS
    SDK_NET_SERVER_TYPES_EMAIL,				///< Email
    SDK_NET_SERVER_TYPES_MULTICAST,			///< ಥ
    SDK_NET_SERVER_TYPES_NTP,				///< NTP
    SDK_NET_SERVER_TYPES_PPPOE,
    SDK_NET_SERVER_TYPES_DNS,
    SDK_NET_SERVER_TYPES_ARSP,				///< ע
    SDK_NET_SERVER_TYPES_3G,            	///< 3G
    SDK_NET_SERVER_TYPES_MOBILE=10,     	///< ֻ
    SDK_NET_SERVER_TYPES_UPNP,				///< UPNP
    SDK_NET_SERVER_TYPES_FTP,				///< FTP
    SDK_NET_SERVER_TYPES_WIFI,          	///< WIFI
    SDK_NET_SERVER_TYPES_ALARM_CENTER,  	///< 澯
    SDK_NET_SERVER_TYPES_NETPLAT_MEGA,  	///< Żͨ
    SDK_NET_SERVER_TYPES_NETPLAT_XINWANG,  	///< 
    SDK_NET_SERVER_TYPES_NETPLAT_SHISOU,  	///< 
    SDK_NET_SERVER_TYPES_NETPLAT_VVEYE,  	///< 
    SDK_NET_SERVER_TYPES_RTSP,     			///< RTSP
    SDK_NET_SERVER_TYPES_PHONEMSG=20,     	///< ֻϢ
    SDK_NET_SERVER_TYPES_PHONEMULTIMEDIAMSG,///< ֻϢ
    SDK_NET_SERVER_TYPES_DAS,          		///< ע
    SDK_NET_SERVER_TYPES_LOCALSDK_PLATFORM, ///< ƽ̨Ϣ
    SDK_NET_SERVER_TYPES_GOD_EYE,			///< ۽Ӿϵͳ
    SDK_NET_SERVER_TYPES_NAT,				///< NAT͸MTU
    SDK_NET_SERVER_TYPES_VPN,     			///< VPN
    SDK_NET_SERVER_TYPES_NET_KEYBOARD,		///< 
    SDK_NET_SERVER_TYPES_SPVMN,				///< 28181Э
    SDK_NET_SERVER_TYPES_PMS,      			///< ֻ
    SDK_NET_SERVER_TYPE_KAICONG,			///< 
    SDK_NET_SERVER_TYPE_PROTOCOL_MAC,		///< ֧MACЭ
    SDK_NET_SERVER_TYPE_XMHEARTBEAT, 		///< 
    SDK_NET_SERVER_TYPES_MONITOR_PLATFORM, 	///< ƽ̨
    SDK_NET_SERVER_TYPES_ANJUP2P,			///< 
    SDK_NET_SERVER_TYPES_TUTKIOTC,			///< TUTK IOTCƽ̨
    SDK_NET_SERVER_TYPES_BAIDUCLOUD, 		///< ٶ
    SDK_NET_SERVER_TYPES_MOBILWATCH,		///< ֻ
	SDK_NET_SERVER_TYPES_BJLTHY,			///< ڷʷƽ̨
    SDK_NET_SERVER_TYPES_OPENVPN,			///< openvpn
    SDK_NET_SERVER_TYPES_PROTOCOL_NAT,		///< ֧NATЭ
    SDK_NET_SERVER_TYPES_PLATFORM_GBEYES,	///< ֻ֧ݵ
	SDK_NET_SERVER_TYPES_GBEYES,			///< Ųȫƽ̨
    SDK_NET_SERVER_TYPES_DATALINK,			///< DataLinkͻִгʹ
    SDK_NET_SERVER_TYPES_WIFI_MODE,			///< Ƿ֧wifiģʽ
	SDK_NET_SERVER_TYPES_IPV6,				///< ֧ipv6
	SDK_NET_SERVER_TYPES_PMS_V2,			///< °PMSҳ
	SDK_NET_SERVER_TYPES_4G,				///< ߲ŵЭǷʾ4G
	SDK_NET_SERVER_TYPES_SPVMN_SIP,			// 28181ʾSIP 忨ַ
    SDK_NET_SERVER_TYPES_NR,
};

/// Ԥ
enum SDK_PreviewTypes
{
    SDK_PREVIEW_TYPES_TOUR,		///< Ѳ
    SDK_PREVIEW_TYPES_TALK,		///< GUI
    SDK_PREVIEW_TYPES_NR
};

///
enum SDK_CommTypes
{
    SDK_COMM_TYPES_RS485,		///<485
    SDK_COMM_TYPES_RS232,		///<232
    SDK_COMM_TYPES_NR
};

//뷨
enum SDK_InPutMethod
{
    SDK_NO_SUPPORT_CHINESE,		//֧
    SDK_NO_SUPPORT_NR
};

//бǩʾ
enum SDK_TipShow
{
    SDK_NO_BEEP_TIP_SHOW,  		//ʾ
    SDK_NO_FTP_TIP_SHOW,  		//FTPʾ
    SDK_NO_EMAIL_TIP_SHOW,  	//EMAILʾ
    SDK_NO_TIP_SHOW_NR
};
///ع
enum SDK_MobileCar
{
    SDK_MOBILEDVR_STATUS_EXCHANGE,			//״̬
    SDK_MOBILEDVR_DELAY_SET,	  			//ʱ
    SDK_MOBILEDVR_CARPLATE_SET,
    SDK_MOBILEDVR_GPS_TIMING,	  			//GPSУʱ
    SDK_MOBILEDVR_DVR_BOOT_TYPE_SET,
    SDK_MOBILEDVR_NR
};

///
enum SDK_OtherFunction
{
    SDK_OTHER_DOWNLOADPAUSE,				//¼ͣ
    SDK_OTHER_USB_SUPPORT_RECORD,			//USB֧¼
    SDK_OTHER_SD_SUPPORT_RECORD,			//SD֧¼
    SDK_OTHER_ONVIF_CLIENT_SUPPORT,			//Ƿ֧ONVIFͻ
    SDK_OTHER_NET_LOCALSEARCH_SUPPORT,		//Ƿ֧Զ
    SDK_OTHER_MAXPLAYBACK_SUPPORT, 			//Ƿ֧طͨʾ
    SDK_OTHER_NVR_SUPPORT, 					//ǷרҵNVR
    SDK_OTHER_C7_PLATFORM_SUPPORT,			//֧C7ƽ̨
    SDK_OTHER_MAIL_TEST_SUPPORT,			//֧ʼ
    SDK_OTHER_SHOW_OSD_INFO,            	//֧ʾ3OSDϢ
    SDK_OTHER_HIDE_DIGITAL, 				//ͨģʽι
    SDK_OTHER_ACUTANCE_HORIZONTAL,			//
    SDK_OTHER_ACUTANCE_VERTIAL,
    SDK_OTHER_BROAD_TRENDS,					//̬
    SDK_OTHER_NO_TALK,						//Խ
    SDK_OTHER_ALTER_DIGITAL_NAME,			//޸ͨ
    SDK_OTHER_SHOW_CONNECT_STATUS,      	//֧ʾwifi 3G עȵ״̬
    SDK_OTHER_SUPPORT_ECACT_SEEK,			//ֻ֧طž׼λ
    SDK_OTHER_UPLOAD_TITLEANDSTATE,			//ͨͨ״̬ϴ
    SDK_OTHER_NO_HDD_RECORD,				//Ӳ¼
    SDK_OTHER_MUSICFILE_PLAY,				//Ƶļ
    SDK_OTHER_SUPPORT_SET_DIG_IP,			//ǰip
    SDK_OTHER_VERSION_PRODUCT_TYPE,			//֧ڰ汾Ϣʾ豸ͺ
    SDK_OTHER_SUPPORT_CAMERA_IMG_STYLE,		//֧ͼ
    SDK_OTHER_SUPPORT_TITLE_ABILITY,		//֧޸onvif
    SDK_OTHER_SUPPORT_DIMEN_CODE,			//ֶ֧ά
	SDK_OTHER_STORAGE_NAS_SUPPORT,			//Ƿ֧NAS洢
    SDK_OTHER_SHOWFALSE_CHECKTIME,			//νʱͬ
    SDK_OTHER_SUPPORT_TIME_ZONE, 			//ʱ
    SDK_OTHER_SHOW_ALARM_LEVEL_REGION,		//ʾͨܵȺ
    SDK_OTHER_SUPPORT_POS,					//֧POS
    SDK_OTHER_HDD_LOWSPACE_USE_MB,			//Ӳ̿ռ䲻㱨MB
    SDK_OTHER_SUPPORT_CUSTOMIZE_OEMINFO,	//OEMͻ汾Ϣ
    SDK_OTHER_DIGITAL_ENCODE,				//ͨ
    SDK_OTHER_RESUME_PTZ_STATE,				//ָ̨״̬
    SDK_OTHER_SUPPORT_SNAP_CFG,				//֧ץͼ
    SDK_OTHER_ABNORMITY_SEND_EMAIL,			//洢豸ڼ洢쳣洢ռ䲻㷢ʼ
    SDK_OTHER_SUPPORT_DIGITAL_PRE,			//֧ͨԤ¼
    SDK_OTHER_SUPPORT_WRITE_LOG, 			//ҳǷд־ѡ
    SDK_OTHER_SUPPORT_CHANGE_ONVIF_PORT,	//֧޸onvif˿
    SDK_OTHER_SUPPORT_COMM_DATA_UPLOAD,  	//ִ֧ϴָ
    SDK_OTHER_SUPPORT_TEXT_PASSWORD,		//¼
    SDK_OTHER_SUPPORT_CLOUD_UPGRADE,		// ֧
    SDK_OTHER_SUPPORT_USER_PROGRAM,			//֧ͻС
    SDK_OTHER_SUPPORT_MODIFY_FRONT_CFG,		//֧޸ǰ
    SDK_OTHER_SUPPORT_FTP_TEST,    			//³֧FTP֧FTPԣϳ֧֡
    SDK_OTHER_SUPPORT_PTZ_IDLE_STATE, 		//̨ʱִкֲ
	SDK_OTHER_SUPPORT_IMP_RCD,				//webǷṩؼ¼ѡ	
	SDK_OTHER_SUPPORT_CAMERA_MOTOR_CTRL, 	//ֻ֧
	SDK_OTHER_SUPPORT_ENCODE_ADD_BEEP,		// Ƶÿ30beep
	SDK_OTHER_SUPPORT_FISH_EYE,	        	//۹
	SDK_OTHER_SUPPORT_SPVMN_NAS_SERVER,		//ճͻnas
	SDK_OTHER_SUPPORT_SMALL_CHN_TITLE_FONT,  //IE˴12*18ͨ
	SDK_OTHER_SUPPORT_CFG_CLOUD_UPGRADE, 	//֧µ
	SDK_OTHER_SUPPORT_STORAGE_FAIL_REBOOT,	//ȫӲ̳Զ
	SDK_OTHER_SUPPORT_SPLIT_CONTROL,		//֧CMSͻ˻ָ
	SDK_OTHER_RTSP_CLIENT_SUPPORT,			 //ͨǷ֧ͨRTSPǰ豸
	SDK_OTHER_LOW_LUX_MODE,					//΢ģʽ
	SDK_OTHER_SUPPORT_Switch_Resolution,	//޸ǰֱͨ
	SDK_OTHER_LOW_MOTION,					//˶
	SDK_OTHER_SUPPORT_CORRIDOR_MODE,       //֧ģʽ
	SDK_OTHER_NR
};

///ֵ֧ϵͳ
typedef struct SDK_SystemFunction
{
    bool vEncodeFunction[SDK_ENCODE_FUNCTION_TYPE_NR];	///< 빦SDK_EncodeFunctionTypes
    bool vAlarmFunction[SDK_ALARM_FUNCTION_TYPE_NR];	///< AlarmFucntionTypes
    bool vNetServerFunction[SDK_NET_SERVER_TYPES_NR];	///< NetServerTypes
    bool vPreviewFunction[SDK_PREVIEW_TYPES_NR];		///< ԤPreviewTypes
    bool vCommFunction[SDK_COMM_TYPES_NR];				///< SDK_CommTypes
    bool vInputMethodFunction[SDK_NO_SUPPORT_NR];  		///< 뷨SDK_InPutMethod>
    bool vTipShowFunction[SDK_NO_TIP_SHOW_NR];          ///< ǩʾSDK_TipShow>
    bool vMobileCarFunction[SDK_MOBILEDVR_NR];			///< ع
    bool vOtherFunction[SDK_OTHER_NR];					///< OtherFunction
}SDK_SystemFunction;

typedef struct SDK_COMMATTRI
{
    int	iDataBits;	// λȡֵΪ5,6,7,8
    int	iStopBits;	// ֹͣλ
    int	iParity;	// Уλ
    int	iBaudRate;	// ʵʲ
}SDK_COMMATTRI;

// 
typedef struct SDK_CONFIG_COMM_X
{
    char iProtocolName[32];		// Э:Console
    int iPortNo;				// ˿ں
    SDK_COMMATTRI aCommAttri;	// 
}SDK_CONFIG_COMM_X;

typedef struct SDK_CommConfigAll
{
    SDK_CONFIG_COMM_X vCommConfig[SDK_COM_TYPES];
}SDK_CommConfigAll;


// ̨
typedef struct SDK_STR_CONFIG_PTZ
{
    char sProtocolName[NET_MAX_PTZ_PROTOCOL_LENGTH];	// Э
    int	ideviceNo;										// ̨豸ַ
    int	iNumberInMatrixs;								// ھеͳһ
    int iPortNo;										// ڶ˿ں	[1, 4]
    SDK_COMMATTRI dstComm;								// 
}SDK_STR_CONFIG_PTZ;

//̨ͨЭ
typedef struct SDK_STR_PTZCONFIG_ALL
{
    SDK_STR_CONFIG_PTZ ptzAll[NET_MAX_CHANNUM];
}SDK_STR_PTZCONFIG_ALL;

//RS485
typedef struct SDK_STR_RS485CONFIG_ALL
{
    SDK_STR_CONFIG_PTZ ptzAll[NET_MAX_CHANNUM];
}SDK_STR_RS485CONFIG_ALL;


typedef struct SDK_CONFIG_WORKSHEET
{
    SDK_TIMESECTION	tsSchedule[NET_N_WEEKS][NET_N_TSECT];	/*!< ʱ */
}SDK_CONFIG_WORKSHEET;

/// ¼ģʽ
enum SDK_RecordModeTypes
{
    SDK_RECORD_MODE_CLOSED,		///< ر¼
    SDK_RECORD_MODE_MANUAL,		///< ֶ¼
    SDK_RECORD_MODE_CONFIG,		///< ¼
    SDK_RECORD_MODE_NR,
};

///< ¼
typedef struct SDK_RECORDCONFIG
{
    int iPreRecord;										///< Ԥ¼ʱ䣬Ϊʱʾر
    bool bRedundancy;									///< ࿪
    //bool bSnapShot;										///< տ
    int iPacketLength;									///< ¼ȣӣ[1, 255]
    int iRecordMode;									///< ¼ģʽ0 رգ1 ֹ 2 
    SDK_CONFIG_WORKSHEET wcWorkSheet;					///< ¼ʱ
    unsigned int typeMask[NET_N_WEEKS][NET_N_TSECT];	///< ¼
}SDK_RECORDCONFIG;

//¼ýṹ
typedef struct SDK_RECORDCONFIG_ALL
{
    SDK_RECORDCONFIG vRecordConfigAll[NET_MAX_CHANNUM];
}SDK_RECORDCONFIG_ALL;

///< ͼƬ
typedef struct SDK_SnapshotConfig
{
    int iPreSnap;										///< ԤץͼƬ
    bool bRedundancy;									///< ࿪
    int iSnapMode;										///< ¼ģʽRecordModeTypes
    SDK_CONFIG_WORKSHEET wcWorkSheet;					///< ¼ʱ
    unsigned int typeMask[NET_N_WEEKS][NET_N_TSECT];	///< ¼룬enum RecordTypes
}SDK_SnapshotConfig;

typedef struct SDK_SnapshotConfigAll
{
    SDK_SnapshotConfig vSnapshotConfigAll[NET_MAX_CHANNUM];
}SDK_SnapshotConfigAll;


//ؽṹ
//  ̨ṹ
typedef struct SDK_PtzLinkConfig
{
    int iType;		// 
    int iValue;		// ͶӦֵ
}SDK_PtzLinkConfig;

#define CHANNELNAME_MAX_LEN 64  //ͨ󳤶

//Ҫݶͨ豸Ҫ޸Ľṹ
typedef struct SDK_EventHandler
{
	unsigned char	dwRecord[NET_MAX_MSK_SIZE];		// ¼ 
    int		iRecordLatch;							// ¼ʱ10?300 sec
	unsigned char	dwTour[NET_MAX_MSK_SIZE];		// Ѳ 	
	unsigned char	dwSnapShot[NET_MAX_MSK_SIZE];	// ץͼ 
	unsigned char	dwAlarmOut[NET_MAX_MSK_SIZE];	// ͨ 
	unsigned char	dwMatrix[NET_MAX_MSK_SIZE];		//  
    int		iEventLatch;							// ʼʱʱ䣬sΪλ
    int		iAOLatch;								// ʱ10?300 sec
    SDK_PtzLinkConfig PtzLink[NET_MAX_CHANNUM];		// ̨
    SDK_CONFIG_WORKSHEET schedule;					// ¼ʱ
    
    bool	bRecordEn;				// ¼ʹ
    bool	bTourEn;				// Ѳʹ
    bool	bSnapEn;				// ץͼʹ
    bool	bAlarmOutEn;			// ʹ
    bool	bPtzEn;
    
    // ̨ʹ
    bool	bTip;					// Ļʾʹ
    bool	bMail;					// ʼ
    bool	bMessage;				// Ϣ
    bool	bBeep;					// 
    bool	bVoice;					// ʾ
    bool	bFTP;					// FTP
    bool	bMatrixEn;				// ʹ
    bool	bLog;					// ־ʹ
    bool	bMessagetoNet;			// Ϣϴʹ
    
    bool    bShowInfo;              // ǷGUIϺͱʾϢ
    unsigned char    dwShowInfoMask[NET_MAX_MSK_SIZE];	// ҪʾϢͨ //Ҫݶͨ豸Ҫ޸Ľṹ
    char    pAlarmInfo[CHANNELNAME_MAX_LEN];			//ҪʾıϢ
    
    bool    bShortMsg;              //Ͷ
    bool    bMultimediaMsg;         //Ͳ
}SDK_EventHandler;

enum SDK_ANALYSE_MODE
{
    SDK_ANALYSE_TRIPWIRE = 0, //
    SDK_ANALYSE_PERIMETER     //ܽ
};
/** ܽģʽ */
enum SDK_URP_PERIMETER_MODE_E
{
    SDK_URP_PMODE_INTRUSION = 0,	/**<  */
    SDK_URP_PMODE_ENTER,			/**<  */
    SDK_URP_PMODE_EXIT				/**< 뿪 */
};

/** ߽ */
#define SDK_MAX_BOUNDARY_POINT_NUM 8
#define SDK_MAX_POINT_NUM 4
#define SDK_NAME_BUF_SIZE 16

/**  */
typedef struct URP_SDK_POINT_S
{
    short X;					/**< x */
    short Y;					/**< y */
}URP_SDK_POINT_S;

/** ߽ṹ */
typedef struct SDK_URP_LINE_S
{
    URP_SDK_POINT_S stStartPt;			/**< ߶ */
    URP_SDK_POINT_S stEndPt;			/**< ߶յ */
}SDK_URP_LINE_S;

typedef struct SDK_URP_POLYGON_REGION_S
{
    int iValid;
    int iPointNum;
    URP_SDK_POINT_S astPoint[SDK_MAX_BOUNDARY_POINT_NUM];
}SDK_URP_POLYGON_REGION_S;

/** URP߽ܽ */
typedef struct SDK_URP_PERIMETER_LIMIT_BOUNDARY_S
{
    int      iBoundaryPtNum;										/**< ߽Ŀ */
    URP_SDK_POINT_S   astBoundaryPts[SDK_MAX_BOUNDARY_POINT_NUM];	/**< ߽㼯 */
}SDK_URP_PERIMETER_LIMIT_BOUNDARY_S;

/** URPܽƲ */
typedef struct SDK_URP_PERIMETER_LIMIT_PARA_S
{
    int iMinDist;						/**< Сؾ */
    int iMinTime;						/**< ʱ */
    int	iDirectionLimit;				/**< Ƿ */
    int iForbiddenDirection;			/**< ֹǶ(λ: Ƕ) */
    SDK_URP_PERIMETER_LIMIT_BOUNDARY_S stBoundary;	/**< ߽ܽ */
}SDK_URP_PERIMETER_LIMIT_PARA_S;

/** URPܽ */
typedef struct SDK_URP_PERIMETER_RULE_PARA_S
{
    int iTypeLimit;					/**< Ŀ */
    int iTypeHuman;					/**< Ŀ(޶ʱʹ) */
    int iTypeVehicle;				/**< Ŀ𣺳 */
    int iMode;						/**< ܽģʽ */
    SDK_URP_PERIMETER_LIMIT_PARA_S stLimitPara;	/**< ܽƲ */
}SDK_URP_PERIMETER_RULE_PARA_S;

// ----------------------------------------------------------------------
//  ݽṹ
/** URP */
#define SDK_URP_MAX_TRIPWIRE_CNT 8

/** URP߽ṹ */
typedef struct SDK_URP_TRIPWIRE_S
{
    int     iValid;						/**< ǷЧ */
    int    iIsDoubleDirection;			/**< ʾðǷΪ˫(0: , 1: ) */
    int     iForbiddenDirection;		/**< ֹ߽*/
    SDK_URP_LINE_S	stLine;				/**< λ */
}SDK_URP_TRIPWIRE_S;

/** URPƲ */
typedef struct SDK_URP_TRIPWIRE_LIMIT_PARA_S
{
    int iMinDist;						/**< Сؾ */
    int iMinTime;						/**< ʱ */
}SDK_URP_TRIPWIRE_LIMIT_PARA_S;

/** URP߹ */
typedef struct SDK_URP_TRIPWIRE_RULE_PARA_S
{
    int iTypeLimit;						/**< Ŀ */
    int iTypeHuman;						/**< Ŀ(޶ʱʹ) */
    int iTypeVehicle;					/**< Ŀ𣺳 */
    SDK_URP_TRIPWIRE_S astLines[SDK_URP_MAX_TRIPWIRE_CNT];	/**<  */
    SDK_URP_TRIPWIRE_LIMIT_PARA_S stLimitPara;				/**< Ʋ */
}SDK_URP_TRIPWIRE_RULE_PARA_S;


/** URPĿȼ */
enum SDK_SENSITIVITY_LEVEL_E
{
    SDK_HIGH_LEVEL_SENSITIVITY,         /**<  */
    SDK_MIDDLE_LEVEL_SENSITIVITY,		/**<  */
    SDK_LOW_LEVEL_SENSITIVITY			/**<  */
};

/** 㷨ģ */

enum SDK_MODULE_TYPE
{
    SDK_MODULE_TYPE_PEA = 0,
    SDK_MODULE_TYPE_OSC,
    SDK_MODULE_TYPE_AVD,
    SDK_MODULE_TYPE_ALL
};

// ----------------------------------------------------------------------
// 濪ʼԶṹ

typedef struct SDK_PEA_RULE_S
{
    int iShowTrack;						/// Ƿʾ켣
    int iShowRule;						/// Ƿʾ
    int iLevel;							/// 伶ȣ0߼Ĭֵ1м2ͼ
    int iPerimeterEnable;				/// ܽʹ
    SDK_URP_PERIMETER_RULE_PARA_S	stPerimeterRulePara;/**< ܽ */
    int iTripWireEnable;				/// ߹ʹ
    SDK_URP_TRIPWIRE_RULE_PARA_S	stTripwireRulePara;	/**< ߼ */
}SDK_PEA_RULE_S;

/// 㷨ṹ
typedef struct SDK_CAPS					/// 1ʾֶ֧ͨӦ㷨0ʾ֧֡
{
    int dwPEA;
    int dwAVD;
    int dwVFD;
    int dwAAI;
    int dwOSC;
    int iResv[3];
}SDK_CAPS;

typedef struct SDK_PEA_STATUS_S
{
    int dwPerimeter;					/// ּ״̬˰ߺܽ,uintֵǸͨ״̬롣
    /// ͨڵλͨڸλ1ޱ0ڵͨ0
    int iResv[4];
    int avdStatue;
}SDK_PEA_STATUS_S;


//Ʒ-begin
#define NET_MAX_OSC_NUM 4
#define NET_MAX_POINT_NUM 4
#define NET_NAME_BUF_SIZE 16

typedef struct SDK_URP_OSC_SPECL_REGIONS_S
{
    int nValid; 						//ǷЧ
    char chName[NET_NAME_BUF_SIZE]; 	//
    SDK_URP_POLYGON_REGION_S stOscRg; 	//Ҫ
    SDK_URP_POLYGON_REGION_S astSubRgA; //еЧ
    SDK_URP_POLYGON_REGION_S astSubRgB; //еЧ
    SDK_URP_POLYGON_REGION_S astSubRgC; //еЧ
}SDK_URP_OSC_SPECL_REGIONS_S;

typedef struct SDK_URP_OSC_LMT_PARA_S
{
    int nTimeMin; //ʱԼ
    int nSizeMin; //Сߴ
    int nSizeMax; //ߴ
}SDK_URP_OSC_LMT_PARA_S;

typedef struct SDK_URP_OSC_RULE_PARA_S
{
    int nSceneType; 					//
    int nCameraType; 					//
    SDK_URP_OSC_SPECL_REGIONS_S astSpclRgs[NET_MAX_OSC_NUM]; //Ҫ
    SDK_URP_OSC_LMT_PARA_S stOscPara; 	//һЩԼ
}SDK_URP_OSC_RULE_PARA_S;

typedef struct SDK_OSC_RULE_S
{
    int iShowTrack;									/// Ƿʾ켣
    int iShowRule;									/// Ƿʾ
    int iLevel;										/// 伶0ǾĬֵ1ͼ2м3: ߼
    int iAbandumEnable;		   						/// Ʒʹ
    SDK_URP_OSC_RULE_PARA_S stObjAbandumRulePara; 	/// Ʒ
    int iStolenEnable;								/// Ʒʹ
    SDK_URP_OSC_RULE_PARA_S stObjStolenRulePara;   	/// Ʒ
    int iNoParkingEnable;							/// Ƿͣʹ
    SDK_URP_OSC_RULE_PARA_S stNoParkingRulePara;   	/// Ƿͣ
}SDK_OSC_RULE_S;


typedef struct SDK_AVD_RULE_S
{
    int iLevel;						    /// ȵλ1-5ֵԽԽԽױ
    int itBrightAbnmlEnable;			///< 쳣ʹ
    int iClarityEnable;					///< ȼʹ
    int iNoiseEnable;					///< ʹ
    int iColorEnable;					///< ƫɫʹ
    int iFreezeEnable;					///< 涳ʹ
    int iNosignalEnable;				///< źȱʧʹ
    int iChangeEnable;					///< 任ʹ
    int iInterfereEnable;				///< Ϊżʹ
    int iPtzLoseCtlEnable;				///< PTZʧؼʹ
}SDK_AVD_RULE_S;

/**  */
typedef struct SDK_URP_IMP_POINT_S
{
    short s16X;				/**< x */
    short s16Y;				/**< y */
}SDK_URP_IMP_POINT_S;

typedef struct SDK_CPC_RULE_S
{
    SDK_URP_IMP_POINT_S stRulePoint[4];	///Ҫ4
    int s32Sizemin;			///С(0,height/2)
    int s32Sizemax;			///(sizemin, height/2)
    int s32Countmax;		///Ŀ[1~15],
    int s32Sensitivity;		/// ȵλ1-5ֵԽԽԽױ
    unsigned int u32Flag;	///־λжϽĬ0
    int s32EnterDirection;	///ķ
}SDK_CPC_RULE_S;

//㷨Ĺü
typedef struct SDK_RULECONFIG
{
    SDK_PEA_RULE_S stRulePea;   //ܽ
    SDK_OSC_RULE_S stRuleOSC; 	//ƷơǷͣ
    SDK_AVD_RULE_S stRuleAVD;	//쳣Ƶź
    SDK_CPC_RULE_S stRuleCPC; 	//ͷ㷨
}SDK_RULECONFIG;


//һܷͨ
typedef struct SDK_ANALYSECONFIG
{
    bool         bEnable;      		//ǷƵ
    int          moduleType;   		//ʹõ㷨ģ
    SDK_EventHandler hEvent;  		//¼
    SDK_RULECONFIG   stRuleConfig; 	//㷨Ĺ
}SDK_ANALYSECONFIG;

//ܷͨ
typedef struct SDK_ANALYSECONFIG_ALL
{
    SDK_ANALYSECONFIG vAnalyzeAll[NET_MAX_CHANNUM];
}SDK_ANALYSECONFIG_ALL;

//ܷ //Ҫݶͨ豸Ҫ޸Ľṹ
typedef struct SDK_ANALYZEABILITY
{
	unsigned char uIntelPEA[NET_MAX_MSK_SIZE];	//PEA֧֣λӦͨ
    UINT uAlgorithmPEA;							//PEAֵ֧㷨ͣ
	unsigned char uIntelOSC[NET_MAX_MSK_SIZE]; 	//OSC֧֣λӦͨ
    UINT uAlgorithmOSC;							//OSCֵ֧㷨
	unsigned char uIntelAVD[NET_MAX_MSK_SIZE]; 	//AVD֧֣λӦͨ
    UINT uAlgorithmAVD;							//AVDֵ֧㷨
	unsigned char uIntelCPC[NET_MAX_MSK_SIZE]; 	//֧֣λӦͨ
    UINT uAlgorithmCPC;							//CPCֵ֧㷨
}SDK_ANALYZEABILITY;



///< ̬
typedef struct SDK_MOTIONCONFIG
{
    bool bEnable;								// ̬⿪
    int iLevel;									// 
    unsigned int mRegion[NET_MD_REGION_ROW];	// ÿһʹһƴ
    SDK_EventHandler hEvent;					// ̬
}SDK_MOTIONCONFIG;

/// ȫ̬ͨ
typedef struct SDK_MOTIONCONFIG_ALL
{
    SDK_MOTIONCONFIG vMotionDetectAll[NET_MAX_CHANNUM];
}SDK_MOTIONCONFIG_ALL;

///< ڵ
typedef struct SDK_BLINDDETECTCONFIG
{
    bool	bEnable;			///< ڵ⿪
    int		iLevel;				///< ȣ1?6
    SDK_EventHandler hEvent;	///< ڵ
}SDK_BLINDDETECTCONFIG;

/// ȫͨڵ
typedef struct SDK_BLINDDETECTCONFIG_ALL
{
    SDK_BLINDDETECTCONFIG vBlindDetectAll[NET_MAX_CHANNUM];
}SDK_BLINDDETECTCONFIG_ALL;

///< ¼ṹ
typedef struct SDK_VIDEOLOSSCONFIG
{
    bool bEnable;				///< ʹ
    SDK_EventHandler hEvent;	///< 
}SDK_VIDEOLOSSCONFIG;

/// ͨĻʱṹ
typedef struct SDK_VIDEOLOSSCONFIG_ALL
{
    SDK_VIDEOLOSSCONFIG vGenericEventConfig[NET_MAX_CHANNUM];
}SDK_VIDEOLOSSCONFIG_ALL;

///< 
typedef struct SDK_ALARM_INPUTCONFIG
{
    bool	bEnable;			///< 뿪
    int		iSensorType;		///< ͳ or 
    SDK_EventHandler hEvent;	///< 
}SDK_ALARM_INPUTCONFIG;

///< ͨı
typedef struct SDK_ALARM_INPUTCONFIG_ALL
{
    SDK_ALARM_INPUTCONFIG vAlarmConfigAll[NET_MAX_CHANNUM];
}SDK_ALARM_INPUTCONFIG_ALL;

///< ·
typedef struct SDK_NETALARMCONFIG
{
    bool bEnable;				///< ʹ
    SDK_EventHandler hEvent;	///< 
}SDK_NETALARMCONFIG;

/// ͨ·ṹ
typedef struct SDK_NETALARMCONFIG_ALL
{
    SDK_NETALARMCONFIG vNetAlarmConfig[NET_MAX_CHANNUM];
}SDK_NETALARMCONFIG_ALL;

///< ر
typedef struct SDK_AlarmOutConfig
{
    int nAlarmOutType;		///< : ,ֶ,ر
    int nAlarmOutStatus;    ///< ״̬: 0: 1;պ
}SDK_AlarmOutConfig;

//< Ӳ¼ʣ
enum SDK_StorageLowSpaceType
{
    SDK_PERSENT = 0,
    SDK_MB,
    SDK_GB,
};

///< Ӳ¼ṹ
typedef struct SDK_StorageLowSpaceConfig
{
    bool bEnable;
    int iLowerLimit;			///< Ӳʣ, ٷ
    SDK_EventHandler hEvent;	///< 
    bool bRecordTimeEnable;
    int iRecordTime;			///<¼
    int iLowerLimitSpace;		///< ӲʣMBGBΪλ
    int EnableType;				///< 0Ϊðٷֱȣ1ΪMBöStorageLowSpaceType
}SDK_StorageLowSpaceConfig;

///< ͨı
typedef struct SDK_AlarmOutConfigAll
{
    SDK_AlarmOutConfig vAlarmOutConfigAll[NET_MAX_CHANNUM];
}SDK_AlarmOutConfigAll;

/// ͨĽַV2汾
typedef struct SDK_AbilitySerialNo
{
    char serialNo[NET_MAX_SERIALNO_LENGTH];
    char productType[NET_MAX_SERIALNO_LENGTH];
}SDK_AbilitySerialNo;

///< Ϣṹ
typedef struct SDK_DriverInformation
{
    int		iDriverType;				///< 
    bool	bIsCurrent;					///< ǷΪǰ
    unsigned int	uiTotalSpace;		///< MBΪλ
    unsigned int	uiRemainSpace;		///< ʣMBΪλ
    int		iStatus;					///< ־ļϵͳʼʱ
    int		iLogicSerialNo;				///< ߼
    SDK_SYSTEM_TIME  tmStartTimeNew;	///< ¼ʱεĿʼʱ
    SDK_SYSTEM_TIME	 tmEndTimeNew;		///< ¼ʱεĽʱ
    SDK_SYSTEM_TIME	 tmStartTimeOld;	///< ¼ʱεĿʼʱ
    SDK_SYSTEM_TIME	 tmEndTimeOld;		///< ¼ʱεĽʱ
	char		fsType[NET_FSLEN];		///<ļ
}SDK_DriverInformation;
enum
{
    SDK_MAX_DRIVER_PER_DISK = 4,		///< ÿķ
    SDK_MAX_DISK_PER_MACHINE = 8,		///< ֧8Ӳ
};
//Ӳ̹
typedef struct SDK_STORAGEDISK
{
    int		iPhysicalNo;
    int		iPartNumber;		// 
    SDK_DriverInformation diPartitions[SDK_MAX_DRIVER_PER_DISK];
}SDK_STORAGEDISK;

typedef struct SDK_StorageDeviceInformationAll
{
    int iDiskNumber;
    SDK_STORAGEDISK vStorageDeviceInfoAll[SDK_MAX_DISK_PER_MACHINE];
}SDK_StorageDeviceInformationAll;

/// 洢豸
enum SDK_StorageDeviceControlTypes
{
    SDK_STORAGE_DEVICE_CONTROL_SETTYPE,		///< 
    SDK_STORAGE_DEVICE_CONTROL_RECOVER,		///< ָ
    SDK_STORAGE_DEVICE_CONTROL_PARTITIONS,	///< 
    SDK_STORAGE_DEVICE_CONTROL_CLEAR,		///< 
   
	SDK_STORAGE_DEVICE_CONTROL_ADDNAS,		///<NAS
	SDK_STORAGE_DEVICE_CONTROL_CHANGENAS,	///޸NAS
	SDK_STORAGE_DEVICE_CONTROL_DELNAS,		///<ɾNAS
 	SDK_STORAGE_DEVICE_CONTROL_NR,
};

/// 
enum SDK_StorageDeviceClearTypes
{
    SDK_STORAGE_DEVICE_CLEAR_DATA,			///< ¼
    SDK_STORAGE_DEVICE_CLEAR_PARTITIONS,	///< 
    SDK_STORAGE_DEVICE_CLEAR_NR,
};

/// 
enum SDK_FileSystemDriverTypes
{
	SDK_DRIVER_READ_WRITE	= 0,	///< д
	SDK_DRIVER_READ_ONLY	= 1,	///< ֻ
	SDK_DRIVER_EVENTS		= 2,	///< ¼
	SDK_DRIVER_REDUNDANT	= 3,	///< 
	SDK_DRIVER_SNAPSHOT		= 4,	///< 
	SDK_DRIVER_TYPE_NR		= 5,	///< ͸
	SDK_DRIVER_UNUSED		= 0xff,	///< ûʹõṹ
};

/// 洢豸
typedef struct SDK_StorageDeviceControl
{
    int iAction;	///< enum SDK_StorageDeviceControlTypes
    int iSerialNo;	///< к
    int iPartNo;    ///< 
    int iType;		///< enum SDK_StorageDeviceClearTypesSDK_FileSystemDriverTypes
    int iPartSize[4/*MAX_DRIVER_PER_DISK*/];	///< ĴС
}SDK_StorageDeviceControl;

/// 豸
typedef enum SDK_DeviceType
{
    SDK_DEVICE_TYPE_DVR,	///< ͨDVR豸
    SDK_DEVICE_TYPE_NVS,	///< NVS豸
    SDK_DEVICE_TYPE_IPC,	///< IPC豸
    SDK_DEVICE_TYPE_HVR,	///<dvr
    SDK_DEVICE_TYPE_IVR,	///<dvr
    SDK_DEVICE_TYPE_MVR,	///<dvr
    SDK_DEVICE_TYPE_NR
}SDK_DeviceType;

/// 豸Ϣ
typedef struct _H264_DVR_DEVICEINFO
{
    char sSoftWareVersion[64];	///< 汾Ϣ
    char sHardWareVersion[64];	///< Ӳ汾Ϣ
    char sEncryptVersion[64];	///< ܰ汾Ϣ
    SDK_SYSTEM_TIME tmBuildTime;///< ʱ
    char sSerialNumber[64];		///< 豸к
    int byChanNum;				///< Ƶͨ
    int iVideoOutChannel;		///< Ƶͨ
    int byAlarmInPortNum;		///< ͨ
    int byAlarmOutPortNum;		///< ͨ
    int iTalkInChannel;			///< Խͨ
    int iTalkOutChannel;		///< Խͨ
    int iExtraChannel;			///< չͨ
    int iAudioInChannel;		///< Ƶͨ
    int iCombineSwitch;			///< ϱָͨģʽǷ֧л
    int iDigChannel;			///<ͨ
    unsigned int uiDeviceRunTime;///<ϵͳʱ
    SDK_DeviceType deviceTye;	///豸
    char sHardWare[64];			///<豸ͺ
    char uUpdataTime[20];		///<  2013-09-03 14:15:13
    unsigned int uUpdataType;	///<
	int nLanguage;//ҵID,0Ӣ 1 2ķ 3 4 5 6
    char sCloudErrCode[NET_MAX_PATH_LENGTH];//Ƶ½
	int status[32];
	//ж¹ǲͨתģôշ3
	//صơ
	//status[0] ·:0ƣ nn·
	//status[1]ơ0 :ơ1Ʋܹۿ
	//status[2]ʱ䡣0:ơn:nӡ
	//status[3]ʣĿǰΪĵ0:ơ1:ΪCIF 6֡ 100K 
	//status[4]λ䡣
	//status[0]status[1]ڴ˴֡
	//status[2]status[3]ڴĹ
}H264_DVR_DEVICEINFO,*LPH264_DVR_DEVICEINFO;

//ص
typedef struct H264_DVR_ACTIVEREG_INFO
{
    char deviceSarialID[64];		//豸кţ64λֵ0
    H264_DVR_DEVICEINFO deviceInfo;	//豸Ϣ
    char IP[IP_SIZE];   			//IP
}H264_DVR_ACTIVEREG_INFO;
///< Զά
typedef struct SDK_AutoMaintainConfig
{
    int iAutoRebootDay;				///< Զ
    int iAutoRebootHour;			///< ʱ	[0, 23]
    int iAutoDeleteFilesDays;		///< Զɾļʱ[0, 30]
}SDK_AutoMaintainConfig;

/// Ĭ
enum SDK_DefaultConfigKinds
{
    SDK_DEFAULT_CFG_GENERAL,		// ͨ
    SDK_DEFAULT_CFG_ENCODE,			// 
    SDK_DEFAULT_CFG_RECORD,			// ¼
    SDK_DEFAULT_CFG_NET_SERVICE,	// 
    SDK_DEFAULT_CFG_NET_COMMON,		// ͨ
    SDK_DEFAULT_CFG_ALARM,			// 
    SDK_DEFAULT_CFG_PTZCOMM,		// ̨
    SDK_DEFAULT_CFG_USERMANAGER,	// û
    SDK_DEFAULT_CFG_PREVIEW,		// Ԥ
    SDK_DEFAULT_CFG_CAMERA_PARAM,   // ͷ
    SDK_DEFAULT_CFG_END,
};

/// ָĬ
typedef struct SDK_SetDefaultConfigTypes
{
    bool vSetDefaultKinds[SDK_DEFAULT_CFG_END];
}SDK_SetDefaultConfigTypes;


typedef struct H264_DVR_CLIENTINFO{
    int nChannel;	//ͨ
    int nStream;	//0ʾΪ1ʾ
    int nMode;		//0TCPʽ,1UDPʽ,2ಥʽ,3 - RTPʽ4-Ƶֿ(TCP)
    int nComType;	//ֻϱͨЧ, ϱͨƴͼģʽ
    void* hWnd;
    
#ifndef OS_IOS
    H264_DVR_CLIENTINFO()
    {
        hWnd=0;
    }
#endif
    
}*LPH264_DVR_CLIENTINFO;


enum SDK_File_Type
{
    SDK_RECORD_ALL = 0,
    SDK_RECORD_ALARM = 1, //ⲿ¼
    SDK_RECORD_DETECT,	  //Ƶ¼
    SDK_RECORD_REGULAR,	  //ͨ¼
    SDK_RECORD_MANUAL,	  //ֶ¼
    SDK_RECORD_KEY,		  //ؼ¼
    SDK_PIC_ALL = 10,
    SDK_PIC_ALARM,		  //ⲿͼƬ
    SDK_PIC_DETECT,		  //ƵͼƬ
    SDK_PIC_REGULAR,      //ͨͼƬ
    SDK_PIC_MANUAL,       //ֶͼƬ
    SDK_PIC_IDXIMG,		  //ͼƬ
    SDK_TYPE_NUM
};

//ѯ¼
typedef struct H264_DVR_FINDINFO
{
    int nChannelN0;			//ͨ
    int nFileType;			//ļ, SDK_File_Type
    H264_DVR_TIME startTime;//ʼʱ
    H264_DVR_TIME endTime;	//ʱ
    char szFileName[32];	//ļΪյĻϵͳֵϵͳ
    void *hWnd;				
    int  StreamType;		//ѯ,:0,:1
#ifndef OS_IOS
    H264_DVR_FINDINFO()
    {
        hWnd=0;
        StreamType =0;
    }
#endif
}H264_DVR_FINDINFO;

//¼ļؽṹ
typedef struct H264_DVR_FILE_DATA
{
    int ch;						//ͨ
    int size;					//ļС
    char sFileName[108];		//ļ
    SDK_SYSTEM_TIME stBeginTime;//ļʼʱ
    SDK_SYSTEM_TIME stEndTime;	//ļʱ
    void *hWnd;					//ھ
    int StreamType;				//ǻط0Ǹ1
#ifndef OS_IOS
    H264_DVR_FILE_DATA()
    {
        hWnd=0;
        StreamType =0;
    };
#endif
}H264_DVR_FILE_DATA;

//طŶ
enum SDK_PlayBackAction
{
    SDK_PLAY_BACK_PAUSE,		/*<! ͣط */
    SDK_PLAY_BACK_CONTINUE,		/*<! ط */
    SDK_PLAY_BACK_SEEK,			/*<! طŶλʱsΪλ */
    SDK_PLAY_BACK_FAST,	        /*<! ٻط */
    SDK_PLAY_BACK_SLOW,	        /*<! ٻط */
    SDK_PLAY_BACK_SEEK_PERCENT, /*<! طŶλٷֱ */
};

//ʱβѯ
typedef struct SDK_SearchByTime
{
    int nHighChannel;			///< 33~64¼ͨ
    int nLowChannel;			///< 1~32¼ͨ
    int nFileType;              ///< ļ, SDK_File_Type
    SDK_SYSTEM_TIME stBeginTime;///< ѯʼʱ
    SDK_SYSTEM_TIME stEndTime;	///< ѯʱ
    int    iSync;               ///< ǷҪͬ
    unsigned int	nHighStreamType;///< 33~64¼,λΪ01
    unsigned int nLowStreamType;///< 1~32¼,λΪ01
}SDK_SearchByTime;

//ÿͨ¼Ϣ
typedef struct SDK_SearchByTimeInfo
{
    int iChannel;			    ///< ¼ͨ
    ///< ¼¼720ֽڵ5760λʾһе1440
    ///< 0000:¼ 0001:F_COMMON 0002:F_ALERT 0003:F_DYNAMIC 0004:F_CARD 0005:F_HAND
    unsigned char cRecordBitMap[720];
}SDK_SearchByTimeInfo;

typedef struct SDK_SearchByTimeResult
{
    int nInfoNum;										 ///< ͨ¼¼Ϣ
    SDK_SearchByTimeInfo ByTimeInfo[NET_MAX_CHANNUM];    ///< ͨ¼¼Ϣ
}SDK_SearchByTimeResult;

//Ϣ
typedef struct SDK_ALARM_INFO
{
    int nChannel;
    int iEvent; //¼:öSDK_EventCodeTypes
    int iStatus;//0:ʼ1:
    SDK_SYSTEM_TIME SysTime;
	char pExtInfo[128]; //Ϣߺͽ߶ԸֱͽиʽԼ
}SDK_AlarmInfo;

/// ־ѯ
typedef struct SDK_LogSearchCondition
{
    int nType;						///< ־
    int iLogPosition;				///< ϴβѯĽʱ־ָ
    SDK_SYSTEM_TIME stBeginTime;	///< ѯ־ʼʱ
    SDK_SYSTEM_TIME stEndTime;		///< ѯ־ʱ
}SDK_LogSearchCondition;


typedef struct SDK_LogItem
{
    char sType[24];				///< ־
    char sUser[32];				///< ־û
    char sData[68];				///< ־
    SDK_SYSTEM_TIME stLogTime;	///< ־ʱ
    int  iLogPosition;			///< ϴβѯĽʱ־ָ
}SDK_LogItem;

//־Ϣ
typedef struct SDK_LogList
{
    int iNumLog;
    SDK_LogItem Logs[NET_MAX_RETURNED_LOGLIST];
}SDK_LogList;

/// Խʽ
typedef struct SDK_AudioInFormatConfigAll
{
    SDK_AudioInFormatConfig vAudioInFormatConfig[SDK_AUDIO_ENCODE_TYPES_NR];
}SDK_AudioInFormatConfigAll;

/// 澯״̬
typedef struct SDK_DVR_ALARMSTATE
{
	unsigned char iVideoMotion[NET_MAX_MSK_SIZE];	///< ƶ״̬,ʾͨ,bit0ͨһ,Դ 1: и澯 0: ޸澯
	unsigned char iVideoBlind[NET_MAX_MSK_SIZE];	///< Ƶڵ״̬,ʾͨ,bit0ͨһ,Դ 1: и澯 0: ޸澯
	unsigned char iVideoLoss[NET_MAX_MSK_SIZE];		///< Ƶʧ״̬,ʾͨ,bit0ͨһ,Դ 1: и澯 0: ޸澯
	unsigned char iAlarmIn[NET_MAX_MSK_SIZE];		///< 澯״̬,ʾͨ,bit0ͨһ,Դ 1: и澯 0: ޸澯
	unsigned char iAlarmOut[NET_MAX_MSK_SIZE];		///< 澯״̬,ʾͨ,bit0ͨһ,Դ 1: и澯 0: ޸澯
}SDK_DVR_ALARMSTATE;

// ͨ״̬
typedef struct SDK_DVR_CHANNELSTATE
{
    bool bRecord; ///< Ƿ¼
    int iBitrate;	///< ǰ
}SDK_DVR_CHANNELSTATE;

// DVR״̬
typedef struct SDK_DVR_WORKSTATE
{
    SDK_DVR_CHANNELSTATE vChnState[NET_MAX_CHANNUM];
    SDK_DVR_ALARMSTATE vAlarmState;
}SDK_DVR_WORKSTATE;


/// ֵ, 
enum SDK_NetKeyBoardValue
{
    SDK_NET_KEY_0, SDK_NET_KEY_1, SDK_NET_KEY_2, SDK_NET_KEY_3, SDK_NET_KEY_4, SDK_NET_KEY_5, SDK_NET_KEY_6, SDK_NET_KEY_7, SDK_NET_KEY_8, SDK_NET_KEY_9,
    SDK_NET_KEY_10, SDK_NET_KEY_11, SDK_NET_KEY_12, SDK_NET_KEY_13, SDK_NET_KEY_14, SDK_NET_KEY_15, SDK_NET_KEY_16, SDK_NET_KEY_10PLUS,SDK_NET_KEY_DIGIT,
    SDK_NET_KEY_UP = 20,     // ϻ̨
    SDK_NET_KEY_DOWN,        // »̨
    SDK_NET_KEY_LEFT,        // ̨
    SDK_NET_KEY_RIGHT,       // һ̨
    SDK_NET_KEY_SHIFT,
    SDK_NET_KEY_PGUP,        // һҳ
    SDK_NET_KEY_PGDN,        // һҳ
    SDK_NET_KEY_RET,         // ȷ
    SDK_NET_KEY_ESC,         // ȡ˳
    SDK_NET_KEY_FUNC,        // л뷨
    SDK_NET_KEY_PLAY,        // /ͣ
    SDK_NET_KEY_BACK,        // 
    SDK_NET_KEY_STOP,        // ֹͣ
    SDK_NET_KEY_FAST,        // 
    SDK_NET_KEY_SLOW,        // 
    SDK_NET_KEY_NEXT,        // һļ
    SDK_NET_KEY_PREV,        // һļ
	SDK_NET_KEY_PAUSE,		 // ͣ
	SDK_NET_KEY_FUNC_A,		 // ܼA
	SDK_NET_KEY_FUNC_B,	     // ܼB(ƷϣABĹܻ豸Ĳͬвͬı)
    SDK_NET_KEY_REC = 40,    // ¼
    SDK_NET_KEY_SEARCH,      // ¼ѯ
    SDK_NET_KEY_INFO,        // ϵͳϢ
    SDK_NET_KEY_ALARM,       // 澯
    SDK_NET_KEY_ADDR,        // ңַ
    SDK_NET_KEY_BACKUP,      // 
    SDK_NET_KEY_SPLIT,       // ָģʽлÿһлһģʽ
    SDK_NET_KEY_SPLIT1,      // 
    SDK_NET_KEY_SPLIT4,      // Ļ
    SDK_NET_KEY_SPLIT8,      // ˻
    SDK_NET_KEY_SPLIT9,      // Ż
    SDK_NET_KEY_SPLIT16,     // 16
    SDK_NET_KEY_SHUT,        // ػ
    SDK_NET_KEY_MENU,        // ˵
    SDK_NET_KEY_SPLIT25,	 // 25
    SDK_NET_KEY_SPLIT36,     // 36
    SDK_NET_KEY_PTZ = 60,    // ̨ģʽ
    SDK_NET_KEY_TELE,        // 䱶
    SDK_NET_KEY_WIDE,        // 䱶
    SDK_NET_KEY_IRIS_SMALL,  // Ȧ
    SDK_NET_KEY_IRIS_LARGE,  // Ȧ
    SDK_NET_KEY_FOCUS_NEAR,  // ۽Զ
    SDK_NET_KEY_FOCUS_FAR,   // ۽
    SDK_NET_KEY_BRUSH,       // ˢ
    SDK_NET_KEY_LIGHT,       // ƹ
    SDK_NET_KEY_SPRESET,     // Ԥõ
    SDK_NET_KEY_GPRESET,     // תԤõ
    SDK_NET_KEY_DPRESET,     // Ԥõ
    SDK_NET_KEY_PATTERN,     // ģʽ
    SDK_NET_KEY_AUTOSCAN,    // Զɨ迪ʼ
    SDK_NET_KEY_AUTOTOUR,    // ԶѲ
    SDK_NET_KEY_AUTOPAN,     // ɨʼ/
};

/// ״̬
enum SDK_NetKeyBoardState
{
    SDK_NET_KEYBOARD_KEYDOWN,	// 
    SDK_NET_KEYBOARD_KEYUP,		// ɿ
};

typedef struct SDK_NetKeyBoardData
{
    int iValue; //öSDK_NetKeyBoardValue
    int iState; //öSDK_NetKeyBoardState
}SDK_NetKeyBoardData;

// Ϣȡ
typedef struct SDK_UpgradeInfo
{
    char szSerial[64];
    char szHardware[64];
    char szVendor[64];
    unsigned int uiLogoArea[2];
	char szLogoPartType[64];
}SDK_UpgradeInfo;

/// 籨
typedef struct SDK_NetAlarmInfo
{
    int iEvent;   //Ŀǰδʹ
    int iState;   //ÿbitʾһͨ,bit0:һͨ,0-ޱ 1-б, 
}SDK_NetAlarmInfo;

typedef enum SERIAL_TYPE
{
    RS232 = 0,
    RS485 = 1,
}SERIAL_TYPE;


enum MEDIA_PACK_TYPE
{
    FILE_HEAD =	0,	    		// ļͷ
    VIDEO_I_FRAME = 1,			// ƵI֡
    VIDEO_B_FRAME =	2,			// ƵB֡
    VIDEO_P_FRAME = 3,			// ƵP֡
    VIDEO_BP_FRAME = 4,			// ƵBP֡
    VIDEO_BBP_FRAME	= 5,		// ƵB֡B֡P֡
    VIDEO_J_FRAME = 6,			// ͼƬ֡
    AUDIO_PACKET = 10,			// Ƶ
};

typedef struct
{
    int		       nPacketType;			// ,MEDIA_PACK_TYPE
    char*	       pPacketBuffer;		// ַ
    unsigned int   dwPacketSize;		// ĴС
    
    // ʱ
    int		       nYear;				// ʱ:
    int		       nMonth;				// ʱ:
    int		       nDay;				// ʱ:
    int		       nHour;				// ʱ:ʱ
    int		       nMinute;				// ʱ:
    int		       nSecond;				// ʱ:
    unsigned int   dwTimeStamp;			// ʱλλΪ
    unsigned int   dwTimeStampHigh;    	//ʱλλΪ
    unsigned int   dwFrameNum;          //֡
    unsigned int   dwFrameRate;         //֡
    unsigned short uWidth;              //ͼ
    unsigned short uHeight;             //ͼ߶
    unsigned int   Reserved[6];     	//
} PACKET_INFO_EX;


typedef struct SDK_OEMInfo
{
    int nOEMID;                     	//OEM ID
    char sCompanyName[NET_MAX_USERNAME_LENGTH]; //˾
    char sTel[NET_MAX_USERNAME_LENGTH];         //绰
    char sAddr[NET_MAX_USERNAME_LENGTH];        //ַ
}SDK_OEMInfo;
typedef struct __TransComChannel//͸
{
    SERIAL_TYPE TransComType;	//SERIAL_TYPE
    unsigned int baudrate;
    unsigned int databits;
    unsigned int stopbits;
    unsigned int parity;
} TransComChannel;
typedef enum SDK_State_Type
{
    DEV_STATE_DDNS=0,
}SDK_State_Type;

//.....

//ع
typedef struct SDK_ExposureCfg
{
    int  level;    			//عȼ
    unsigned int leastTime;	//Զعʱ޻ֶعʱ䣬λ΢
    unsigned int mostTime; 	//Զعʱޣλ΢
}SDK_ExposureCfg;

//
typedef struct SDK_GainCfg
{
    int gain;    //Զ(Զ)̶ֵ
    int autoGain;//ԶǷã0:  1:
}SDK_GainCfg;

//
typedef struct SDK_CameraParam
{
    unsigned int whiteBalance;      //ƽ
    unsigned int dayNightColor;     //ҹģʽȡֵвɫԶлͺڰ
    int elecLevel;             		//οƽֵ
    unsigned int apertureMode;      //ԶȦģʽ
    unsigned int BLCMode;           //ⲹģʽ
    SDK_ExposureCfg exposureConfig;	//ع
    SDK_GainCfg     gainConfig;    	//
    
    unsigned int PictureFlip;		//ͼƬ·ת
    unsigned int PictureMirror;		//ͼƬҷת()
    unsigned int RejectFlicker;		//չƷ
    unsigned int EsShutter;			//Ź
    
    int ircut_mode;		//IR-CUTл 0 = ͬл 1 = Զл
    
    int dnc_thr;		//ҹתֵ
    int ae_sensitivity;	//ae
    
    int Day_nfLevel;	//noise filter ȼ0-5,0˲1-5 ֵԽ˲ЧԽ
    int Night_nfLevel;
    int Ircut_swap;		//ircut = 0        = 1
	int high_light;     //ǿƹ 0~255,Ĭ16
}SDK_CameraParam;

//
typedef struct SDK_AllCameraParam
{
    SDK_CameraParam vCameraParamAll[NET_MAX_CHANNUM];   //еͨ
}SDK_AllCameraParam;

//ع
typedef struct SDK_CameraAbility
{
    int  count;      						//֧عٶ
    unsigned int speeds[CAMERAPARA_MAXNUM]; //عٶ
    int  status;     						//״̬  >= 0     < 0 쳣
    int  elecLevel;  						//οƽֵ
    int  luminance;  						//ƽ
    char pVersion[64];						//xm 2a汾
	char isFishLens; //Ƿ۾ͷǣҪappPCͼУ
	char resv1[3];   //char͵ĳԱ
	char reserve[28];//int͵ĳԱ
}SDK_CameraAbility;

//زſ
enum SDK_LoalPlayAction
{
    SDK_Local_PLAY_PAUSE,		/*<! ͣ */
    SDK_Local_PLAY_CONTINUE,	/*<!  */
    SDK_Local_PLAY_FAST,	    /*<! ٲ */
    SDK_Local_PLAY_SLOW,	    /*<! ٲ */
    
};

//
typedef struct SDK_NetShortMsgCfg
{
    bool bEnable;       //ֻŵĹǷ
    char pDesPhoneNum[NET_MAX_RECIVE_MSG_PHONE_COUNT][16];
    int  sendTimes;     //ҪÿֻͶٴζ
}SDK_NetShortMsgCfg;
//ֻ
typedef struct SDK_NetMultimediaMsgCfg
{
    bool bEnable;				// ֻŵĹǷ
    char pDesPhoneNum[NET_MAX_RECIVE_MSG_PHONE_COUNT][16]; //ղŵֻţ֧3ֻ
    char pGateWayDomain[40];	// صַIP
    int  gateWayPort;			// ض˿
    char pMmscDomain[40];		// ŷַIP
    int  mmscPort;				// ŷ˿ں
}SDK_NetMultimediaMsgCfg;

typedef struct SDK_DASSerInfo
{
    bool enable;
    char serAddr[NET_NAME_PASSWORD_LEN];
    int  port;
    char userName[NET_NAME_PASSWORD_LEN];
    char passwd[NET_NAME_PASSWORD_LEN];
    char devID[NET_NAME_PASSWORD_LEN];
}SDK_DASSerInfo;
typedef enum UploadDataType  //ϴ
{
    VEHICLE=0,//Ϣ
    SDK_RECORD_STATE,//¼״̬
    SDK_DIGITCHN_STATE,	//ͨ״̬
    SDK_TITLE_INFO,		//ͨ
	SDK_FUNCTION_STATE, // ״̬˶¼ʱĵ
	SDK_ELECT_STATE, //
	SDK_MUSICBOX_STATE, //wifiֺ
}UploadDataType;
//************************************************************************
//״̬
enum SDK_CAR_STATUS_TYPE
{
    SDK_CAR_WORKING,             //Ƿ
    SDK_CAR_LIGHT_LEFT_TURN,     //תǷ
    SDK_CAR_LIGHT_RIGHT_TURN,    //תǷ
    SDK_CAR_DOOR_LEFT_FRONT,     //ǰǷ
    SDK_CAR_DOOR_RIGHT_FRONT,    //ǰǷ
    SDK_CAR_DOOR_LEFT_BACK,      //Ƿ
    SDK_CAR_DOOR_RIGHT_BACK,     //ҺǷ
    SDK_CAR_DOOR_BACK,           //Ƿ
    SDK_CAR_BRAKE,               //Ƿɲ
    SDK_CAR_URGENCY_ALARM,       //
    SDK_CAR_STATUS_NR, //״̬Ŀ
};

//ⲿ
enum SDK_IO_INPUT_TYPE
{
    SDK_LOCAL_ALARM_INPUT,//ر
    SDK_RS232_INPUT,      //ͨ232
    SDK_RS485_INPUT,      //ͨ485
};

//ⲿϢ복״̬ĶӦϵ
typedef struct SDK_CarStatusExchange
{
    int  statusType; //һֳ״̬ת
    bool bExist;     //Ƿи״̬Ϣ룬ݳʵ
    bool bEnable;    //Ƿ״̬
    int  inputType;  //״̬ӦϢͣIO_INPUT_TYPEöٵֵȡ
    int  addr;       //ַǱرһӦ0ڶӦ1
    int  sensorType; //(NO)򳣱(NC)inputTypeǱرʱЧ
}SDK_CarStatusExchange;

typedef struct SDK_CarStatusExchangeAll
{
    SDK_CarStatusExchange exchangeAll[16];
}SDK_CarStatusExchangeAll;

typedef struct SDK_CarStatusNum
{
    int iCarStatusNum;
}SDK_CarStatusNum;

typedef struct SDK_CarDelayTimeConfig
{
    bool bStartDelay;
    bool bCloseDelay;
    
    int timeStartDelay;		//λ:
    int timeCloseDelay;		//λ:
}SDK_CarDelayTimeConfig;
enum SDK_network_media {
    SDK_NM_WIRED = 0,  	//
    SDK_NM_WLAN,       	//Wifi
    SDK_NM_3G,         	//3G
    SDK_NM_NR,    		//
};
//ȼ
typedef struct SDK_tagNetLinkOrder
{
    int netType;  //ȡֵnetwork_media͵
    int netOrder; //ԽСȼԽ,0ȼ
}SDK_NetLinkOrder;
//ȼ
typedef struct SDK_NetOrderConfig
{
    bool         bEnable;        			//Ƿȼ
    int          netCount;       			//Ŀ
    SDK_NetLinkOrder pNetOrder[SDK_NM_NR];	//ȼ
    SDK_NetLinkOrder pReserve[7-SDK_NM_NR];	//µԤ
}SDK_NetOrderConfig;
///ȼ
typedef struct SDK_NetOrderFunction
{
    bool bNetOrder;
}SDK_NetOrderFunction;
#define  MAX_CAR_INFOR 24
/// ƺ
struct  SDK_CarPlates
{
    char sPlateName[MAX_CAR_INFOR];
};
enum NET_ISP
{
    ISP_AUTO, 		//Զѡ
    ISP_TELCOM, 	//
    ISP_UNIONCOM, 	//ͨ
    ISP_CNC,		//ͨ
    ISP_MOBILE,		//ƶͨ
    ISP_USER,		//Զ
};
//ƽ̨Ϣ
typedef struct SDK_LocalSdkNetPlatformConfig
{
    int Enable;
    int nISP;                          ///μNET_ISP
    char sServerName[32];
    char ID[32];
    char sUserName[32];
    char sPassword[32];
    CONFIG_IPAddress HostIP;		///< host ip
    int port;
}SDK_LOCALSDK_NET_PLATFORM_CONFIG;

//GPSУʱ
typedef struct SDK_GPSTimingConfig
{
    bool bEnable;      // Ƿ
    int  timeChange;   // UTCʱҪı٣λ:
    int  updatePeriod; //   λ:
}SDK_GPSTimingConfig;
//۽Ӿϵͳ
typedef struct	SDK_GodEyeConfig
{
    bool	bEnable;
    char MainSeverName[NET_NAME_PASSWORD_LEN];	//
    int MainPort;								//˿
    char ExSeverName[NET_NAME_PASSWORD_LEN]; 	//
    int ExPort;									//ö˿
}SDK_GodEyeConfig;
enum  SDK_DigManagerShowStatus
{
    SDK_DM_SHOW_NONE,
    SDK_DM_SHOW_ALL,
};


//ͨʾ״̬
typedef struct SDK_DigitalManagerShow
{
    int  nDigitalManagerShowSta;
}SDK_DigitalManagerShow;

//NAT䣬MTUֵ
typedef struct SDK_NatConfig
{
    bool bEnable;
#if 0
    bool CloudpushEnable;
#endif
    int nMTU;             		// Χ (100,1400)
    char serverAddr[64];  		//ƷIPַ
    int  serverPort;      		//ƷĶ˿;
    CONFIG_IPAddress dnsSvr1;	//ƷDNSַ
    CONFIG_IPAddress dnsSvr2;
#if 0
    char pResv[16];      		//
#endif
}SDK_NatConfig;

typedef enum SubConnType
{
    conn_realTimePlay=1,
    conn_talk,
    conn_playback
}SubConnType;
//*** */豸ע
enum SocketStyle
{
	TCPSOCKET=0,
	UDPSOCKET,	
	PLUGLANSOCKET=4,		//½
	PLUGOUTERSOCKET,		//½
	P2P_TUTKSOCKET,			//TUTK P2P
    SOCKETNR
};


enum SDK_NatStatusType
{
    SDK_NAT_STATUS_DISENABLE,	//δ
    SDK_NAT_STATUS_PROBING,  	//̽DNS
    SDK_NAT_STATUS_CONNECTING,	//ӷ
    SDK_NAT_STATUS_CONNECTED,	//ӳɹ
};
//nat״̬Ϣ
typedef struct SDK_NatStatusInfo
{
	int	iNatStatus;
	char NatInfoCode[256];//ݣӴ

}SDK_NatStatusInfo;

/// ˮӡ
typedef struct SDK_WaterMarkConfig
{
    bool	bEnable;		//  ˮӡ
    char  sKey[8];
    char sUserData[16];
}SDK_WaterMarkConfig;

typedef struct SDK_WaterMarkConfigAll
{
    SDK_WaterMarkConfig vWaterMarkConfigAll[NET_MAX_CHANNUM];
}SDK_WaterMarkConfigAll;

///̬
typedef struct SDK_EncodeStaticParam
{
    int profile;
    int level;
    int reserved1[4];
}SDK_EncodeStaticParam;


typedef struct SDK_EncodeStaticParamAll
{
    SDK_EncodeStaticParam	EncodeStaticParamAll[NET_MAX_CHANNUM];
}SDK_EncodeStaticParamAll;

enum
{
    sdk_maxCPCDataItem = 2048,
    sdk_maxCPCDataReturn = 512,
    sdk_itemtotalLength = 96,	//2λͨţ20λʼʱ䣬20λʱ䣬13λ,
    sdk_maxpack=4,// sdk_maxCPCDataItem/sdk_maxCPCDataReturn
};

typedef struct SDK_CPCDataItem	//ͳṹ
{
    int channel;				//Ӧͨ
    SDK_SYSTEM_TIME startTime;	//ʼʱ
    SDK_SYSTEM_TIME endTime;	//ʱ
    int inNum;					//
    int outNum;					//뿪
}SDK_CPCDataItem;

typedef struct SDK_CPCData
{
    int nItemNum;
    SDK_CPCDataItem CPCData[sdk_maxCPCDataReturn];
}SDK_CPCData;

typedef struct SDK_CPCDataAll
{
    int nCount;
    SDK_CPCData nCpcData[sdk_maxpack] ;
}SDK_CPCDataAll;

/// ¼洢豸ͣ͵һֻ߶
typedef struct SDK_RecordStorageType
{
    bool SATA_as;
    bool USB_as;
    bool SD_as;
    bool DVD_as;
}SDK_RecordStorageType;

//VPNṹ
typedef struct SDK_VPNConfig
{
    bool Enable;								///< Ƿ
    CONFIG_IPAddress ServiceIp;					///< IPַ
    char UserName[NET_NAME_PASSWORD_LEN];		///< û
    char Password[NET_NAME_PASSWORD_LEN];		///< 
    CONFIG_IPAddress addr;						///< źõIPַ
    char ServerName[NET_NAME_PASSWORD_LEN];		///< openvpnַ
    int port;
}SDK_VPNConfig;
//ǰVGAֱ
typedef struct SDK_VGAresolution
{
    int nHeight;
    int nWidth;
}SDK_VGAresolution;
//֧VGAֱб
typedef struct SDK_VGAResolutionAbility
{
    int vVGANum;
    char vVGAList[VGA_MAXNUM][VGA_NAME_LENGTH];
}SDK_VGAResolutionAbility;

//豸б(豸)
typedef struct SDK_NetDevList
{
    int vNetDevNum;
    SDK_CONFIG_NET_COMMON_V2 vNetDevList[DEV_LIST_SHOW];
}SDK_NetDevList;


//ݿƽ̨
/***ûϢ***/

typedef struct SDK_CONFIG_KAINENG_USERINFO
{
    char szUserName[16];           //û5ֻʮĸ;
    char szUserAddr[128];          //ûַ30ֻ60ĸ;
    char szUserAttr[16];           //ûʣ5ֻʮĸ
    
    char szBelongUnit[64];         //ܵλ15ֻ30ĸ;
    char szBelongUnitPhone[16];    //ܵλ绰14λֻ֣"-" ;
    
    char szPoliceUnit[64];         //λ15ֻ30ĸ;
    char szPoliceUnitAddr[128];    //λַ30ֻ60ĸ;
    char szPoliceUnitPhone[16];    //λ绰14λֻ֣"-";
    
    char szPolicePhone[4][16];
    char szPolOrCenPhone[2][16];   ///ĵ绰1214λֻ֣"-" ;
    
    char szFTP[64];                //FTP50ַ
    char szEMail[64];              //E-Mail: 50ַ
    CONFIG_IPAddress PoliceIP;     //ӾIPַ
    int nHttpPort;                 //ӾIP˿
}SDK_CONFIG_KAINENG_USERINFO;

/***豸Ϣ***/
//òö
typedef enum SDK_GuardType
{
    SDK_FORBID = 0,      //ֹ
    SDK_TEN_MIN,         //ʮ
    SDK_THIRTY_MIN,      //ʮ
    SDK_SIXTY_MIN,       //ʮ
    SDK_MAX,
}SDK_GUARDTYEP;


typedef struct SDK_CONFIG_KAINENG_DEVINFO
{
    char ProbeNum1;                //ÿ 1ŵ10̽ѡ ĬΪ <1̽>
    char ProbeNum2;                //ÿ 1ŵ10̽ѡ ĬΪ <1̽>
    char nProbeType;			   // ѡ3Ϊ <ֹ>  <AND>  <OR>  ĬΪ <ֹ>
    char nGuardType;               //ò, GUARDTYEP
    
    int AlarmTime;                 //ѿʱ䣺λִ000-999  ĬΪ180
    int nGuardArea;               //߷ͣλ֣ÿλС0300000000 33333333;  Ĭϣ00000000
    
    char szRemConAddr[4][4];       //ң1-4ŵַ λ16ַգ0-9  A-FĬΪգ
    char szLinDevAddr[6][4];       //豸1-6ַλ16ַգ0-9  A-FĬΪգ
    char szProbeAddr[10][4];       //̽1-10ŵַλ16ַգ0-9  A-FĬΪգ
    
    //ʱ
    char szGuardTime[3][9];        //ʱ,ÿ鶼Ϊchar [8]  00 00 00 00ɿʼʱֵʱ֣Ҫ
}SDK_CONFIG_KAINENG_DEVINFO;

/******/
//ö
typedef enum SDK_KNAlarmLink
{
    SDK_LINK_EMPTY = 0,
    SDK_LINK_SWITH,
    SDK_LINK_10S,
    SDK_LINK_30S,
    SDK_LINK_60S,
    SDK_LINK_200S,
    SDK_LINK_600S,
    SDK_LINK_METHOD_1,
    SDK_LINK_METHOD_2,
    SDK_LINK_MAX_1,
}SDK_KNALARMLINK;

typedef struct SDK_CONFIG_KAINENG_LINKINFO
{
    char eLink[10][7];        //,ȡֵΪö
}SDK_CONFIG_KAINENG_LINKINFO;

//ܶƣ3Ϣȫ
typedef struct SDK_CONFIG_KAINENG_INFO
{
    SDK_CONFIG_KAINENG_USERINFO UserInfo;
    SDK_CONFIG_KAINENG_DEVINFO DevInfo;
    SDK_CONFIG_KAINENG_LINKINFO LinkInfo;
}SDK_CONFIG_KAINENG_INFO;

//豸Э
typedef enum SDK_TransferProtocol_V2
{
    SDK_TRANSFER_PROTOCOL_NETIP,
    SDK_TRANSFER_PROTOCOL_ONVIF,
    SDK_TRANSFER_PROTOCOL_MAC,
	SDK_TRANSFER_PROTOCOL_NAT,
	SDK_TRANSFER_PROTOCOL_DAHUA,
	SDK_TRANSFER_PROTOCOL_RTSP,
	SDK_TRANSFER_PROTOCOL_NETIPV6,
    SDK_TRANSFER_PROTOCOL_NR_V2,
    SDK_TRANSFER_PROTOCOL_ONVIF_DEFAULT = 128,
    SDK_TRANSFER_PROTOCOL_ONVIF_NR_V2
}SDK_TransferProtocol_V2;

typedef struct SDK_EncodeStaticParamV2
{
    int profile; //ǰ̬
    int reserved1[4]; //ֶ
}SDK_EncodeStaticParamV2;

/*
 ==	DVR̬3
 ==	0 ֧ 1 ֧baseline 2 ֧main profile 4 ֧high profile
 ==  
 */
typedef struct SDK_EncStaticParamAbility
{
    unsigned int encStaticParam;
}SDK_EncStaticParamAbility;

//մC7ƽ̨
typedef struct SDK_C7PlatformConfig
{
    char pServerAddr[64];//ƽַ̨IPַ
    int  servPort;       //ƽ̨˿
    char pPUID[32];      //PUID
    char pPassword[32];  //
    char pStatus[64];    //״̬LocalSDKǿɶдģطֻ
    char pResv[60];      //
}SDK_C7PlatformConfig;

///
typedef struct SDK_NetKeyboardConfig
{
    bool Enable;				//Ƿ
    char sTransProtocol[4];		//Э
    int ListenPort;				//˿
    char sParserProtocol[32];
    int deviceaddr;				//豸ַ
}SDK_NetKeyboardConfig;
////// Э
typedef struct SDK_NetKeyboardAbility
{
    //ÿЭ64ַ
    int nTransPNum;
    char vTransProtocol[32][NET_MAX_PTZ_PROTOCOL_LENGTH];
    int nParserNum;
    char vParserProtocol[32][NET_MAX_PTZ_PROTOCOL_LENGTH];
}SDK_NetKeyboardAbility;

//28181Э
typedef struct SDK_ASB_NET_VSP_CONFIG
{
    bool	bCsEnable;								//ʹܱ
    char	szCsIP[64];								//ַ
    short	sCsPort;								//˿
    short	sUdpPort;								//ذudp˿
    char	szServerNo[64];							//к
    char 	szServerDn[64];							//ڵ
    char	szDeviceNO[64];							//豸к
    char 	szConnPass[64];							//豸
    int		iHsIntervalTime;						//ʱ,λ
    int		iRsAgedTime;							//·עʱλΪ
    char	Camreaid[NET_MAX_CHANNUM][64];			//豸ͷID
    int		CamreaLevel[NET_MAX_CHANNUM];			//ȼ
    char	Alarmid[NET_MAX_CHANNUM][64];			//豸ͷID
    int		AlarmLevel[NET_MAX_CHANNUM];			//ȼ
    unsigned int	uiAlarmStateGpinEnable;			//ⲿʹ
    unsigned int	uiAlarmStateLoseEnable;			//Ƶʧ澯ʹ
    unsigned int	uiAlarmStateMotionEnable;		//Ƶ̬澯ʹ
    unsigned int	uiAlarmStateBlindEnable;		//Ļڵ澯ʹ
    unsigned int	uiAlarmStatePerformanceEnable;	//ϵͳ쳣澯ʹ
    unsigned int	uiAlarmStateConnectEnable;		//ûӸ澯ʹ
}SDK_ASB_NET_VSP_CONFIG;

//ֻ
typedef struct SDK_PMSConfig
{
    bool Enable;		///< Ƿ
    char servname[64];
    int port;
    char boxid[128];
    char resume[24]; //
}SDK_PMSConfig;

//ĻʾϢ
typedef struct  SDK_OSDInfoConfig
{
    SDK_VIDEO_WIDGET OSDInfoWidget;
    char ppInfo[NET_MAX_LINE_PER_OSD_AREA][NET_CHANNEL_NAME_MAX_LEN];
}SDK_OSDInfoConfig ;

typedef enum SDK_wordEncType
{
    SDK_wordEnc_GB2312,			//ֱGB2312
    SDK_wordEnc_Unicode,		// Unicode
    SDK_wordEnc_UTF8,			//UTF-8
    SDK_wordEnc_NR,	
}SDK_wordEncType;

//ͨĻʾϢ
typedef struct  SDK_OSDInfoConfigAll
{
    SDK_OSDInfoConfig   vOSDInfoAll[NET_MAX_CHANNUM];
    int strEnc;//ʽ,ĬΪUTF-8,κδҪڿͻöٲμSDK_wordEncType
}SDK_OSDInfoConfigAll;
//
typedef struct SDK_KaiCongAlarmConfig
{
    bool Enable;								///< Ƿ
    char ServerName[NET_NAME_PASSWORD_LEN];		///< 
    int Port;									///< ˿ں
    char UserName[NET_NAME_PASSWORD_LEN];		///< û
    char Password[NET_NAME_PASSWORD_LEN];		///< 
}SDK_KaiCongAlarmConfig;
//
typedef struct SDK_VideoChannelManage
{
    int		nHVRCap;
    int		curMode;
    bool bhide[MAX_HVR_CHNCAP_CHN];
    SDK_CAPTURE_HVRCAPV2	HVRCap[MAX_HVR_CHNCAP_CHN];
}SDK_VideoChannelManage ;

//PTZ
typedef struct SDK_PTZControlAbility
{
    unsigned int nPTZPosition;
}SDK_PTZControlAbility;

typedef struct SDK_PositionPoint
{
    int iPointStart_x;
    int iPointStart_y;
    int iPointEnd_x;
    int iPointEnd_y;
}SDK_PositionPoint;

typedef struct SDK_XMHeartbeatConfig
{
    bool bEnable;								///< Ƿ
    int iInterval;								///< ʱ
    char ServerName[NET_NAME_PASSWORD_LEN];		///< 
    int Port;									///< ˿ں
    char UserName[NET_NAME_PASSWORD_LEN];		///< û
    char Password[NET_NAME_PASSWORD_LEN];		///< 
    char resume[24];
}SDK_XMHeartbeatConfig;

typedef struct SDK_MonitorPlatformConfig
{
    int Enable;		///< Ƿ
    char servname[NET_NAME_PASSWORD_LEN];
    int port;
    char resume[24];
    char agentid[128];	//ͻidƽ̨ʹ(SSJCͷ)
    char type[128];		//
}SDK_MonitorPlatformConfig;

typedef enum SDK_IMG_TYPE
{
    SDK_IMG_TYPE_DEFAULT,
    SDK_IMG_TYPE_1,
    SDK_IMG_TYPE_2,
    SDK_IMG_TYPE_NR,
}SDK_IMG_TYPE;
//ͷչ
typedef struct SDK_CameraParamEx
{
    SDK_GainCfg broadTrends;		//̬
    int style;						//enum SDK_IMG_TYPE
    unsigned int exposureTime;		//ʵЧعʱ
	int  Dis ;						//ӷ  0:ر 1:**/
	int Ldc; 						//ͷУ  0:ر 1:**/
	int AeMeansure; 				//ģʽУ  0:ƽ 1:**/
	int LowLuxMode; 				//΢ģʽ mode0 ر 1 ==only imx291
	int corridor_mode;				//1:ģʽ  0:ͨģʽ
	int res[48];					// 
}SDK_CameraParamEx;

// ͷչ
typedef struct SDK_CameraParamExAll
{
    SDK_CameraParamEx vCameraParamExAll[NET_MAX_CHANNUM];
}SDK_CameraParamExAll;

//ƽ̨ͨãԺƶ
typedef struct SDK_NetPlatformCommonCfg
{
    int	Enable;
    int Port;									///< ˿ں
    char ServerName[NET_NAME_PASSWORD_LEN];		///< 
    char ID[NET_NAME_PASSWORD_LEN];
    char UserName[NET_NAME_PASSWORD_LEN];		///< û
    char Password[NET_NAME_PASSWORD_LEN];		///< 
    char resume[128];							///Ԥ
}SDK_NetPlatformCommonCfg;

typedef enum SDK_INFO_NET_LINK_STATUS
{
    SDK_INFO_NET_LINK_OK         = 0,
    SDK_INFO_NET_LINK_FAILED     = 1,
    SDK_INFO_NET_LINK_NO_DEVICE  = 2,
    SDK_INFO_NET_LINK_INVALID    = 9,
}SDK_INFO_NET_LINK_STATUS;

typedef enum SDK_POSITIONING_DIRECTION
{
    SDK_POS_DIRECTION_EAST  = 'E',
    SDK_POS_DIRECTION_WEST  = 'W',
    SDK_POS_DIRECTION_SOUTH = 'S',
    SDK_POS_DIRECTION_NORTH = 'N'
}SDK_POSITIONING_DIRECTION;

typedef struct SDK_POSITIONING_POS//γ
{
    int  degree;     //(/1000)Ϊλ
    char direction;  //λ ȡֵöֵPOSITIONING_DIRECTIONʾ
    char res[3];
}SDK_POSITIONING_POS;
//GPS״̬
typedef struct SDK_GPSStatusInfo
{
    int             positioningStatus; //λ״̬ȡֵöSDK_INFO_NET_LINK_STATUS
    SDK_POSITIONING_POS longitudePos;      //
    SDK_POSITIONING_POS latitudePos;       //γ
    char            rev[12];
}SDK_GPSStatusInfo;

//wifi״̬
typedef struct SDK_WifiStatusInfo
{
    int  connectStatus;  //wifi״̬  öSDK_INFO_NET_LINK_STATUS
    int  strength;       //źǿ
    char rev[24];
}SDK_WifiStatusInfo;

//3G״̬
typedef struct SDK_WirelessStatusInfo
{
    int  connectStatus;  //3G״̬  öSDK_INFO_NET_LINK_STATUS
    int  strength;       //źǿ
    char rev[24];
}SDK_WirelessStatusInfo;

//ע״̬
typedef struct SDK_DASStatusInfo
{
    int  connectStatus;  //DAS״̬  öSDK_INFO_NET_LINK_STATUS
    char rev[28];
}SDK_DASStatusInfo;

typedef struct SDK_RecordStorageInfo
{
    unsigned int bStart;			//Ƿ¼־λ
    SDK_SYSTEM_TIME beginTime;		//¼ʼʱ
    SDK_SYSTEM_TIME endTime;		//¼ʱ
    unsigned int  storageCapacity;	//Ӳ
    unsigned int  useCapacity;		//ʹ
    int res[16];					//
}SDK_RecordStorageInfo;
/// ʱȼ
typedef enum SDK_DecodeDeleyTypes
{
    SDK_DecodeDeley_0 = 0,
    SDK_DecodeDeley_1,
    SDK_DecodeDeley_2,
    SDK_DecodeDeley_3,
    SDK_DecodeDeley_4,
    SDK_DecodeDeley_5,
    SDK_DecodeDeley_6,
    SDK_DecodeDeley_TYPE_NR,
}SDK_DecodeDeleyTypes;

typedef struct SDK_DecodeDeleyTimePrame
{
    unsigned int  DecodeDeleyTime[SDK_DecodeDeley_TYPE_NR];
}SDK_DecodeDeleyTimePrame;

// ͨ
typedef struct SDK_DecodeParam
{
    int iMaxDeleyTime[NET_MAX_CHANNUM];	// Ľʱ
}SDK_DecodeParam;

typedef struct SDK_RecordStateInfo
{
    int nchannel;
    int RecordState;
}SDK_RecordStateInfo;

//Ƶɫṹ
typedef struct SDK_VIDEOCOLOR_PARAM_EX
{
    int		BrightnessRef;		///< ref1ȡֵ0-100
    int		ContrastRef;		///< Աȶref1ȡֵ0-100
    int  		ContrastThRef;	///< Աȶȷֵref1ȡֵ0-100
    int		ContrastSlopeRef;	///< Աȶбref1ȡֵ0-100
    int 		DarkBlfRef;
    int		DarkNfRef;
    int		DarkEcPthRef;
    int		DarkEcMthRef;
    int		DarkDcRef;
    int		CbGain;				///high low middle
    int		CrGain;				///higg low middle
    int		reserved;			///
}SDK_VIDEOCOLOR_PARAM_EX;

typedef struct SDK_VIDEOCOLOR_PARAM_CUSTOM
{
    SDK_VIDEOCOLOR_PARAM_EX	VideoColor[3];
    int		Saturation;		///< Ͷȣȡֵ0-100
    int		Gain;			///< 棬ȡֵ0-100bit7λʾԶ棬λԡ
    int		Acutance;		///< ȣȡֵ0-100
    int		AeWight;		//ⲹ
}SDK_VIDEOCOLOR_PARAM_CUSTOM;

typedef enum SDK_FileControlType
{
    SDK_FILE_DEL,			//ɾļ
    SDK_FILE_DIR_DEL,		//ɾļ
    SDK_FILE_DIR_CLEAR,		//ļ
    SDK_FILE_NR,
}SDK_FileControlType;

typedef struct SDK_NetFileControl
{
    int iAction;			//enum FileControlType
    char strfile[256];
}SDK_NetFileControl;

typedef enum SDK_DecChnStateType
{
    SDK_DEC_STA_NONE, 			//
    SDK_DEC_STA_NOCONFIG,		//δ
    SDK_DEC_STA_NOLOGIN,		//δ½
    SDK_DEC_STA_NOCONNECT,		//δ
    SDK_DEC_STA_CONNECTED,		//
    SDK_DEC_STA_LOGIN_FAILED,	//¼ʧ
	SDK_DEC_STA_OFFLINE,		//ǰ豸
}SDK_DecChnStateType;

typedef struct SDK_DigitStateInfo
{
    int nchannel;
    int DigitState; //SDK_DecChnStateType
}SDK_DigitStateInfo;

typedef struct SDK_TitleNameInfo
{
    int nchannel;
    char titleName[256];
}SDK_TitleNameInfo;

typedef struct SDK_AbilityMask
{
    unsigned int AbilityPram;
}SDK_AbilityMask;

typedef enum SDK_Music_Play_Action
{
    SDK_MUSIC_ACTION_PLAY,
    SDK_MUSIC_ACTION_STOP,
    SDK_MUSIC_ACTION_PAUSE,
    SDK_MUSIC_ACTION_CONTINUE
}SDK_Music_Play_Action;

typedef struct SDK_LocalMusicControl
{
    int iAction;            //οSDK_Music_Play_Action
    char sFileName[20];
}SDK_LocalMusicControl;

/// ƵļбϢ
typedef struct SDK_MusicFileList
{
    int iNumFiles;		///< ļ
    char sFileName[8][20];
}SDK_MusicFileList;

typedef enum SDK_CAR_BOOT_TYPE
{
    SDK_CAR_BOOT_TYPE_SPARK,  //Ϩ𿪹ػ
    SDK_CAR_BOOT_TYPE_TIMING, //ʱػ
    SDK_CAR_BOOT_TYPE_NR,
}SDK_CAR_BOOT_TYPE;


//𿪹ػʱ
typedef struct SDK_CarSparkWork
{
    int bootDelayMinute;  //ʱ
    int shutDelayMinute;  //ػʱ
    char resv[24];        //
}SDK_CarSparkWork;

//ضʱػ
typedef struct SDK_CarTimingWork
{
    SDK_TIMESECTION workSection1; //ʱ1
    SDK_TIMESECTION workSection2; //ʱ2
    char resv[32]; //
}SDK_CarTimingWork;

typedef struct SDK_CarBootTypeConfig
{
    int           bootType;         	//ö SDK_CAR_BOOT_TYPE 
    SDK_CarSparkWork  sparkWorkConfig;  //𿪹ػ
    SDK_CarTimingWork timingWorkConfig; //ʱػʱ1
    char          resv[48];
}SDK_CarBootTypeConfig;

//IPC
typedef struct SDK_ALARM_IPCCONFIG
{
    bool	bEnable;			///< 뿪
    int		iSensorType;		///< ͳ or 
    SDK_EventHandler hEvent;	///< 
}SDK_ALARM_IPCCONFIG;
///< ͨı
typedef struct SDK_IPCAlarmConfigAll
{
    SDK_ALARM_IPCCONFIG vAlarmConfigAll[NET_DECORDR_CH];
}SDK_IPCAlarmConfigAll;

//ٶ
typedef struct SDK_BaiduCloudCfg
{
    bool	enable;
    char APIKey[NET_NAME_TOKEN_LEN];				//ӦAPIԿ
    char SecretKey[NET_NAME_TOKEN_LEN];				//ӦԿ
    char AuthorizationCode[NET_NAME_TOKEN_LEN];		//Ȩ
    char accessToken[NET_NAME_TOKEN_LEN];			//Ȩ
    char refreshToken[NET_NAME_TOKEN_LEN];			//ˢȨ
    char deviceID[NET_NAME_TOKEN_LEN];				//豸ID
    char userCode[NET_NAME_TOKEN_LEN];				//ûȨ
    char qrcodeUrl[NET_NAME_TOKEN_LEN];				//ά
    char streamID[NET_NAME_TOKEN_LEN];				//ID
    char describe[NET_NAME_TOKEN_LEN];				//豸
    int state;										//״̬
    SDK_SYSTEM_TIME	refreshTime;					//ϴˢTokenʱ
    int channelMain[NET_MAX_CHANNUM];				//Ƿ
    int channelExtra[NET_MAX_CHANNUM];				//Ƿ
    int	recordFileMode;								//¼ģʽ
    int	recordFileSize;								//¼ļС
    int	recordFileTime;								//¼ʱ
    char resume[128];								//Ԥ
}SDK_BaiduCloudCfg;

//ֻ
typedef struct SDK_PhoneInfoNum
{
    int nNum;
}SDK_PhoneInfoNum;

typedef struct SDK_LOGIN_CFG//޸ǰip¼
{
    char sUserName[NET_MAX_USER_LENGTH];		///< ½
    char sPassword[NET_MAX_USER_LENGTH];		///< ½
    int iEncryptType;			///< ܷʽ ̶ֵ 1
}SDK_LOGIN_CFG;

typedef struct SDK_IPSetCfg
{
    int ch;
    int devtype;
    SDK_CONFIG_NET_COMMON netcfg;
    SDK_LOGIN_CFG loginPram;
}SDK_IPSetCfg;

#define SDK_LONG_PATH_LEN 256	// Զ·(Դ)
#define SDK_SHORT_PATH_LEN 64	// عص
#define SDK_FS_TYPE_LEN 8	//ļϵͳ(eg: ext3)ֳ
#define SDK_USERNAME_LEN 32
#define SDK_PASSWD_LEN 32
#define SDK_MAX_NAS_NUM 8	//֧NAS
#define SDK_MAX_DEV_NUM 16	// ֱ֧豸
#define SDK_MAX_PART_NUM 4	// Ӳֵ֧ķ
struct SDK_NAS_INFO	// NASϢ
{
	char mountSrc[SDK_LONG_PATH_LEN];	// Զ·(Դ)
	char fsType[SDK_FS_TYPE_LEN];
	char mountOn[SDK_SHORT_PATH_LEN];	// عص
	char username[SDK_USERNAME_LEN];
	char password[SDK_PASSWD_LEN];
	unsigned int DirType;	//öIStorageDirectory::DIR_TYPE
};

typedef struct SDK_NAS_LIST	// NAS(samba, nfs)б
{
	unsigned int  count;
	SDK_NAS_INFO nasInfo[SDK_MAX_NAS_NUM];
}SDK_NAS_LIST;

//ά
typedef struct SDK_DimenCode
{
    int size;
    unsigned char code[3920];// 177*177/32*4=3920ֲ
}SDK_DimenCode;

typedef struct SDK_DimenCodeAll
{
    SDK_DimenCode sn;
    SDK_DimenCode appIOS;
    SDK_DimenCode appAndroid;
    SDK_DimenCode otherInfo;  //ͻԶϢ
}SDK_DimenCodeAll;

//йֻƽ̨
typedef struct SDK_MobileWatchCfg
{
    int	Enable;
    char DevID[NET_NAME_ID_LEN];			// 豸
    char DevKey[NET_NAME_ID_LEN];			// 豸֤
    char ManufacturerNo[NET_NAME_ID_LEN];	// ̱
    char Mode[NET_NAME_ID_LEN];				// 豸ͺ
    char GroupAddr[NET_NAME_URL_LEN];		// ƽַ̨
    char ProvinceAddr[NET_NAME_URL_LEN];	// ʡƽַ̨
    char NatIP[NET_NAME_ID_LEN];			// 豸ַ
    int	NatPort;							// 豸˿
    char BackupNatIP[NET_NAME_ID_LEN];		// 豸÷ַ
    int	BackupNatPort;						// 豸÷˿
    char TurnIP[NET_NAME_ID_LEN];			// TurnServerַ
    int	TurnPort;							// TurnServer˿
    char BackupTurnIP[NET_NAME_ID_LEN];		// TurnServerݷַ
    int	BackupTurnPort;						// TurnServerݷ˿
    char FtpIP[NET_NAME_ID_LEN];			// ͼƬϴFTPַ
    int	FtpPort;							// ͼƬϴFTP˿
    char FtpAccount[NET_NAME_ID_LEN];		// ͼƬϴFTPʺ
    char FtpPassword[NET_NAME_ID_LEN];		// ͼƬϴFTP
    char resume[NET_NAME_URL_LEN];			// Ԥ
}SDK_MobileWatchCfg;

typedef struct SDK_BrowserLanguageType
{
    int type;
}SDK_BrowserLanguageType;

typedef struct SDK_TimeZone
{
    int minuteswest; 	//UTCʱĲֵλӣΪ
    int FistFlag;		//ڱ֤һʹõʱʱ䲻
}SDK_TimeZone;


typedef enum SDK_TimeSynTypes
{
    SDK_TST_OFF = 0,
    SDK_TST_TIME_UTC,
    SDK_TST_TIME_LOCAL,
    SDK_TST_TIME_ALL,
    SDK_TST_NR,
}SDK_TimeSynTypes;

// ͨʱͬ
typedef struct SDK_TimeSynParam
{
    int iTimeModel[NET_MAX_CHANNUM]; //οSDK_TimeSynTypes
}SDK_TimeSynParam;

typedef struct SDK_CustomizeOEMInfo
{
    unsigned int typeMask;//: BITMSK(BURN_OEM_ID),BITMSK(BURN_OEM_PRODUCT),BITMSK(BURN_OEM_SERIAL)
    unsigned int oemID;
    unsigned int oemProduct;
    unsigned int oemSerial;
}SDK_CustomizeOEMInfo;

typedef struct SDK_DigitDevInfo
{
    bool enable; 					//Ƿã豸ʹ
    int nCapture;					//ģͨ
    int nAudio;						//Ƶͨ
    int videoFormat;				//Ƶʽ
    CONFIG_EncodeAbility ability;	//
}SDK_DigitDevInfo;

typedef struct SDK_EncodeChDisplay
{
    unsigned char displayChanelMask[NET_MAX_MSK_SIZE];	//IEʾıͨ
}SDK_EncodeChDisplay;

//Ѳ
typedef struct SDK_TourState
{
    bool bRunning;
    int  lineID;   //Ѳ·
}SDK_TourState;

//Ѳ
typedef struct SDK_PatternState
{
    bool bRunning;
    int  lineID;  //Ѳ· (δʹ)
}SDK_PatternState;

//ɨ
typedef struct SDK_ScanState
{
    bool bRunning;
    int  lineID;  //ɨ· (δʹ)
}SDK_ScanState;

//ˮƽת
typedef struct SDK_PanonState
{
    bool bRunning;
    int  lineID;  //ˮƽת· (δʹ)
}SDK_PanonState;

//תָԤõ
typedef struct SDK_PresetState
{
    bool bEnable;
    int  iPresetID;
}SDK_PresetState;

//ϵǰλ
typedef struct SDK_PoweroffState
{
    bool bEnable;
    int  iPresetID;
}SDK_PoweroffState;

//һ̨ͨ״̬
typedef struct SDK_PtzState
{
    SDK_TourState    tourState;
    SDK_PatternState patternState;
    SDK_ScanState    scanState;
    SDK_PanonState   panonState;
    SDK_PresetState  presetState;
    SDK_PoweroffState poweroffState;
}SDK_PtzState;

//ָ֮ǰ̨״̬
typedef struct SDK_ResumePtzState
{
    bool     bEnable;                    //Ƿ豸ָ̨״̬
    SDK_PtzState ptzStateAll[NET_MAX_CHANNUM];
}SDK_ResumePtzState;

/// ٶȱ
typedef enum SDK_SpeedAlarmTypes
{
    SDK_SPEED_ALARM_HIGH,		// ٱ
    SDK_SPEED_ALARM_LOW,		// ٱ
    SDK_SPEED_ALARM_NR
}SDK_SpeedAlarmTypes;

///< ٶȱ
typedef struct SDK_SpeedAlarmConfig
{
    bool	bEnable;			///< ٶȱ
    int		iSpeed;				///< ٶ
    SDK_EventHandler hEvent;	///< ٶȱ
}SDK_SpeedAlarmConfig;

/// ȫ͵ٶȱ
typedef struct SDK_SpeedAlarmConfigAll
{
    SDK_SpeedAlarmConfig vSpeedAlarmAll[SDK_SPEED_ALARM_NR];
}SDK_SpeedAlarmConfigAll;

typedef struct SDK_CorrespondentOwnInfo
{
    char brand[64];
    char pModel[32];
    char pFirmwareVersion[32];
    char pHardwareId[32];
    int port;
	int scopeNum;
	char vScopeInfo[32][64];
}SDK_CorrespondentOwnInfo;

typedef struct SDK_OSDInfo
{
    int index;//ͨʱ֮ȡֵ01
    int nX;//Χ0-1000
    int nY;//Χ0-1000
    int nChannel;//Ҫõͨ
    char pOSDStr[1024];//Ҫӵַ
}SDK_OSDInfo;

typedef struct SDK_AppDownloadLink
{
    bool IOSEnable;    		//Ƿʾiphoneͻ˶ά
    bool AndroidEnable;		//Ƿʾ׿ͻ˶ά
    bool SNEnable;    		//ǷʾкŶӦĶά
    bool OtherEnable;  		//ǷʾͻԶά
    char inkIOS[128];
    char linkAndroid[128];
    char nameOther[128];  	//ͻԶά
    char linkOther[128];  	//ͻԶά
}SDK_AppDownloadLink;

typedef struct SDK_UserMap
{
    int size;
    USER_INFO UserCfg[64];
}SDK_UserMap;

//ϴݵָ
typedef struct SDK_NetTransCommData
{
    bool bEnable;								///< Ƿ
    int SerialType;  							//ͣ0ʾRS2321ʾRS485
    int ServerType;								///Э,0ʾTCP1ʾUDP
    char ServerAddr[NET_NAME_PASSWORD_LEN];  	//IPַ
    int  ServerPort;							//˿;
	int ReportTime;								//״̬Ϣͼʱ䣬λ
}SDK_NetTransCommData;

//Netinfo_cctvͻӴݵָ
typedef struct SDK_NetinfoNetTransComm
{
	char LastReportTime[32];	//һαʱ
	char KeyPadNu[16];			//豸
	int ConnStatus;				//״̬(1:ӳɹ0:δ)
	int  ReportTime;			//״̬Ϣͼʱ䣬λ
} SDK_NetinfoNetTransComm;

typedef struct SDK_PhoneInfo
{
    char command[NET_NAME_PASSWORD_LEN];
    char type[12];
    char asid[128];
    char username[NET_NAME_PASSWORD_LEN];
    char password[NET_NAME_PASSWORD_LEN];
    char acme[NET_NAME_PASSWORD_LEN];
    char resume[24];
}SDK_PhoneInfo;

#define SDK_MAX_VERSION_NUM 20

typedef struct SDK_CloudUpgradeVersion
{
    char name[128];			// 汾
    char date[12];			//汾ڣʽ:"2014-08-26"
    unsigned int length;	// ļ
}SDK_CloudUpgradeVersion;

typedef struct SDK_CloudUpgradeList
{
    int num;
    SDK_CloudUpgradeVersion versions[SDK_MAX_VERSION_NUM];
}SDK_CloudUpgradeList;

//ͻdemo
typedef struct SDK_NetUseProgram
{
    bool bEnable;   							///Ƿ
    char UserName[NET_NAME_PASSWORD_LEN];		///< û
    char Password[NET_NAME_PASSWORD_LEN];		///< 
    int Port;									///< ˿ں
    char ServerAddr[NET_NAME_PASSWORD_LEN];  	///IPַ
    char Describe[NET_MAX_RIGTH_NUM];			///豸
}SDK_NetUseProgram;

typedef struct I_VERSION_INFO_T
{
    char name[128];			// 汾
    char date[12];			//汾ڣʽ:"2014-08-26"
    unsigned int length;	// ļ
}I_VERSION_INFO_T;


//wifiģʽãг¼ԶлAPģʽ
typedef struct SDK_NetWifiMode
{
    int autoSwitchAPMode; //ȡֵ  1:ԶлAPģʽ(ģʽ)  0:Զл
    int reserve[7];
}SDK_NetWifiMode;

//Ʒ¼Ƶ״̬
typedef struct SDK_FbExtraStateCtrl
{
    int ison;
}SDK_FbExtraStateCtrl;

typedef struct SDK_AutoSwitch
{
    int  nStartTime;
    int  nStopTime;
    int  nStartDay;
    int  nStopDay;
    bool bEnable;
}SDK_AutoSwitch;

typedef struct SDK_AutoSwitchAll
{
    SDK_AutoSwitch Aswitch[10];
}SDK_AutoSwitchAll;

typedef struct SDK_tagPoint
{
	int x;
	int y;
}SDK_Point;

typedef struct SDK_TitleDot
{
	int width;
	int height;
	char pDotBuf[NET_MAX_TITLE_DOT_BUF_LEN];
}SDK_TitleDot;

typedef struct SDK_PowerSocketSet
{
    int nSwitch;
    int nLight;
}SDK_PowerSocketSet;

typedef struct SDK_ClientInfo
{
    char Description[NET_NAME_PASSWORD_LEN];
    char Uuid[NET_NAME_PASSWORD_LEN];
    char Phone[NET_NAME_PASSWORD_LEN];
    char LoginTime[NET_NAME_PASSWORD_LEN];
    char Number[NET_NAME_PASSWORD_LEN];
    int  Permission;
    bool DeleThisClient;
    
}SDK_ClientInfo;

typedef struct SDK_ClientInfoAll
{
    SDK_ClientInfo info[10];
}SDK_ClientInfoAll;

typedef struct SDK_Authority
{
    int Level;
	int Ability;
}SDK_Authority;

typedef struct SDK_Arm
{
    int Guard;
}SDK_Arm;

typedef struct SDK_AlarmInfo_V2
{
    char Descrip[64];
    char SerialID[64];
    char Type[32];
    char iEvent[20];
    char iStatus[20];
    SDK_SYSTEM_TIME SysTime;
}SDK_AlarmInfo_V2;

/// û½ʽ
typedef enum SDK_LoginType
{
    H264_DVR_LOGIN_TYPE_WEB,			///< WEB½(Ĭ)
    H264_DVR_LOGIN_TYPE_LOCALUPGRADE,	///< ()½
    H264_DVR_LOGIN_TYPE_CLOUDUPGRADE,	///< ½
    H264_DVR_LOGIN_TYPE_PCCLIENT,		///< PCͻ˵½
    H264_DVR_LOGIN_TYPE_MOBILE,			///< ƶնˣIPhone½
	H264_DVR_LOGIN_TYPE_FUTRUE_HOME,	///δͥͻ˵½
	H264_DVR_LOGIN_TYPE_XM030,			///xmeyeͻ˵½
    H264_DVR_LOGIN_TYPE_NR,				///< ½
}SDK_LoginType;

typedef struct SDK_Xpms_Search_AlarmInfo_Req
{
    char Uuid[100];
    char authCode[100];
    SDK_SYSTEM_TIME StarTime;	//Ϣѯʼʱ
    SDK_SYSTEM_TIME EndTime;	//Ϣѯʱ䣬ȫ0ʾǰʱ
    int Channel;				//Channel < 0 ʾȫѯͨǴ0ʼ
    int AlarmType;				//(ʱ)
    int Number;					//Ҫı Number <= 0 ʾȫ
    int Index;					//ҪӲѯĽһʼȡ
    char Res[32];
}SDK_XPMS_SEARCH_ALARMINFO_REQ;


typedef struct SDK_Xpms_Search_AlarmPic_Req
{
    char Uuid[100];
    char authCode[100];
#ifdef WIN32
    __int64 ID;
#else
    long long ID;		//ϢID
#endif
    char Res[32];
}SDK_XPMS_SEARCH_ALARMPIC_REQ;

// ̩ƽ̨
typedef struct SDK_CONFIG_NET_BJHONGTAIHENG
{
    bool bEnable;
    char ServerUrl[64]; //ַ
    char DevID[16];     //豸id
    char Password[16];  //豸֤
    char DevModel[16];	//豸ͺ
    char SerialNo[20]; 	//豸к
}SDK_CONFIG_NET_BJHONGTAIHENG;

typedef enum
{
    SDK_LocalAlarm = (int)0x00001,
    SDK_MotionDetect = (int)0x00002,
}SDK_AlarmRecType;

//ƴ洢ؽṹ
typedef struct SDK_CloudRecordConfig
{
    int EnableMsk;			//0ȫ棬1Ƕʱ棬2棬3ʱ&& 
    int StreamType;			//
    int AlarmRecTypeMsk;	//Ҫϴ¼ıͣAlarmRecType
    SDK_CONFIG_WORKSHEET wcWorkSheet;	//ͨ¼洢ʱ
}SDK_CloudRecordConfig;

typedef struct SDK_CloudRecordConfigAll
{
    SDK_CloudRecordConfig vRecordConfigAll[NET_MAX_CHANNUM];
}SDK_CloudRecordConfigAll;

// ж
typedef struct SDK_PtzIdleState
{
    bool bEnable;		// жʹλ
    int iTime;			// ʱ λ: 
    int iIdleState;		// ж
    int iId;			// Ӧж͵Ķ
}SDK_PtzIdleState;
typedef struct SDK_PtzIdleStateAll
{
    SDK_PtzIdleState pPtzIdleStateAll[NET_MAX_CHANNUM];
}SDK_PtzIdleStateAll;

typedef struct SDK_CameraClearFog
{
    bool enable; //0 򿪣1 
    int  level ; // ǿȵȼ[0,100]
    char rev[4];
}SDK_CameraClearFog;
typedef struct SDK_CameraClearFogAll
{
    SDK_CameraClearFog vCameraClearFogAll[NET_MAX_CHANNUM];
}SDK_CameraClearFogAll;
//
typedef struct SDK_CameraMotorCtrl
{
	bool UDDireOverturn;   //·ת
	bool LRDireOverturn;   //ҷת
	bool UDRestOverturn;   //λת
	bool LRRestOverturn;   //λת
	int  rev[8];
}SDK_CameraMotorCtrl;

typedef struct SDK_EncodeAddBeep
{
	int Enable;       //1 Ƶÿ30beep0ûд˹ 
	char res[4];
}SDK_EncodeAddBeep;

typedef struct SDK_DataLinkConfig
{
	int DoProgramEnable;
	int NIP2Enable;
}SDK_DataLinkConfig;
//װλ
typedef enum SDK_FISHEYE_APP_TYPE_E
{
	SDK_FISHEYE_APP_CEIL = 0, //컨
	SDK_FISHEYE_APP_TABL = 1, //
	SDK_FISHEYE_APP_WALL = 2, //ǽ
}SDK_FISHEYE_APP_TYPE_E;

//ģʽ
typedef enum SDK_FISHEYE_SECENE_E
{
	SDK_FISHEYE_SECENE_ORIG	= 0,
	SDK_FISHEYE_SECENE_R = 1,
	SDK_FISHEYE_SECENE_P180_ALL = 2,
	SDK_FISHEYE_SECENE_P180_ONE = 3,
	SDK_FISHEYE_SECENE_P180_TWO = 4,
	SDK_FISHEYE_SECENE_P360_FULL = 5,
	SDK_FISHEYE_SECENE_P360_SEPE = 6,
	SDK_FISHEYE_SECENE_P360_HALF = 7,
	SDK_FISHEYE_SECENE_ROP_R = 8,
	SDK_FISHEYE_SECENE_RORR_R = 9,
	SDK_FISHEYE_SECENE_RRRR_R = 10,
	SDK_FISHEYE_SECENE_RRP_R = 11
}SDK_FISHEYE_SECENE_E;


typedef struct SDK_FishEyeParam
{
	int appType;	//öFISHEYE_APP_TYPE_E
	int secene;		//öFISHEYE_SECENE_E
	int duty;		//  0~100
	unsigned int reserv[7];
}SDK_FishEyeParam;

//ǷOSD logo
typedef struct SDK_SetLogo
{
	int Enable;
	int	reserve[8];
}SDK_SetLogo;

typedef struct SDK_SparshHeartbeat
{
	bool bEnable;							///Ƿ
	int  IntevalTime; 						///ϱʱ
	char AlarmType[NET_NAME_PASSWORD_LEN];	///
}SDK_SparshHeartbeat;
typedef struct SDK_SDevicesState
{
    int 	num;	  	//豸
    char uuid[32][32];	//32к
    int state[32];    	//0:ߣ1:
}SDK_SDevicesState;

typedef enum SDK_EncMode
{
	WIFI_ENC_OPEN = 0,
	WIFI_ENC_AES = 1,
	WIFI_ENC_TKIP = 2,
	WIFI_ENC_WEP =3
}SDK_EncMode;

typedef struct SDK_SWifiInfo
{
	char wifiSsid[64];
	char wifiPassword[64];
	char wifiMac[64];       // :ָʮַ
	char wifiGateWay[64];   // 
	char wifiSubmark[64];   // 
	char wifiDNS1[64];      // DNS1
	char wifiDNS2[64];      // DNS2
	int  wifiEncMode;       // ܷʽ--EncMode
	char mobileIp[32];
	char mobileMac[32];
}SDK_SWifiInfo;

//ͻnas
typedef struct SDK_SPVMN_NAS_SERVER
{
	char ServerIP[16];
	int Port;
	char RootDir[256];
	char DowloadIP[16];	
	char DowloadPath[256];
}SDK_SPVMN_NAS_SERVER;

//IEȡ汾Ϣ
typedef struct SDK_CloudUpgradeVersionReq
{
	char uuid[20];				//豸к
	char  devID[32];			//豸͵ID
	char  curVersion[16];		//ǰ汾
	char Language[32];			//
	char devType;				//
	char expect;				//0ʾ°汾1ʾѯҪ汾
	char		manual;			//1ʾֶѯ0ʾԶѯ
	char		rev;
}SDK_CloudUpgradeVersionReq;

//˻ظIE˻ȡ汾Ϣ
typedef struct SDK_CloudUpgradeVersionRep
{
	char FileName[128];			//ļʱֵ
	char DevID[32];				//豸͵ID
	char Date[16];				//汾
	int 		   FileSize;	//ļĴС
	int		  FileLevel;		//汾Ҫ̶
	char ChangeLog[512];		//change log,ӵ512ֽ,־кܶ
}SDK_CloudUpgradeVersionRep;

//web˷͸˵
typedef struct SDK_CloudUpgradeStartReq
{
	char uuid[20];				//豸к
	char DevID[32];				//豸ID
	char FileName[128];			//ļ
	char Date[16];				//汾
	bool 	manual;				//1ʾûֶ0ʾԶֻ˸ֵһ㴫1
}SDK_CloudUpgradeStartReq;

//ipv6
typedef struct SDK_IPAddressV6
{
	bool bEnable;				//Ƿipv6
	char pLocalLinkAddr[32];	//·ַ
	char pAddr[64];				//ipv6ַ
	char pGateway[64];			//
	int	iPrefix;  				//ipv6ǰ׺
} SDK_IPAddressV6;

typedef struct SDK_OnlineUpgradeCfg
{
	char cEnable; 				//Ƿ
	char pServerAddr[63];
	int  serverPort;
	char cAutoCheck;		//ǷԶ
	char cAutoUpgradeImp;		//ֻԶҪ
	char cIgnoreAllVersion;		//а汾ҳʾ
	char cIgnoreCurVersion;		//Եǰ汾ҳʾָµİ汾Ҳֻʾһ
	unsigned int IgnoreCurTime;	//Եĵǰ汾ʱ䣬 bIgnoreCurVersion
	char cJustImpVersion;		//ֻҪ汾ʾ
	char rev[3];
} SDK_OnlineUpgradeCfg;

//òƷ433
typedef struct SDK_ConsSensorAlarmCfg
{
	bool bEnable;				// ̬⿪  
	SDK_EventHandler hEvent;	// ̬ 
} SDK_ConsSensorAlarmCfg;

///<Ӳ̳¼ṹ
typedef struct SDK_StorageFailConfig
{
	bool 	bEnable;
	SDK_EventHandler hEvent;	///< 
	bool	bRebootEnable;		//ϵͳȫ:hutianhao
	int		bRebooted;			//Ƿ;0:δ;0:
	int		NoBitRateCnt;		//豸Զ
}SDK_StorageFailConfig;

//CMSͻ˶˷Ļָ
typedef struct SDK_SplitControl
{
	int iSplitChannel;//ָͨ
	int iSplitWinType;//ָ(:ͨ)
	char rev[8];
}SDK_SplitControl;

typedef enum _SDK_EXCEPTION_TYPE
{
	SDK_EXCEPTION_DISCONNECTED,//豸
	SDK_EXCEPTION_RECCONNECTED,//豸ָ
}SDK_EXCEPTION_TYPE;

//豸Ϣ
typedef struct SDK_ReconInfo
{
	LPH264_DVR_DEVICEINFO deviceInfo; //µ¼豸Ϣлģʽ豸ͨϢܻ䣨ͨģʽ仯ˣ,ɹҪس
	void* pWnd;			//ƵʱͨӦĴھ
	int nType;			//öSDK_EXCEPTION_TYPE
}SDK_ReconInfo;

//豸Ϣ
typedef struct SDK_SubConnectInfo
{
	long lRealHandle;	//ԤƵӶϿƵɹĲž
	bool bSubOnline;	//ԤƵǷ,true
	void* pWnd;			//ԤƵӶϿƵʱͨӦĴھbSubOnlineΪtrieʱH264_DVR_RealPlayʱ봰ھʱpWndֵΪNULL
}SDK_SubConnectInfo;

typedef struct SDK_IntelBrasSpecialInfo
{
	int TCPPort;			///< TCP˿
	char  bEnableCloud;	//interbras ƹ
	char rev2[3];
	int rev[14];
}SDK_IntelBrasSpecialInfo;

//sip 豸忨ַ
typedef struct SDK_SIP_NET_IP_CONFIG
{
	char	SIPDevIP[64]; 

}SDK_SIP_NET_IP_CONFIG;
typedef struct SDK_registersercfg
{
	bool enable;
	char serAddr[NET_NAME_PASSWORD_LEN];//PAG
	int  port;
	int  factorycode;//̴
	char userName[NET_NAME_PASSWORD_LEN];
	char passwd[NET_NAME_PASSWORD_LEN];
	char puid[NET_NAME_PASSWORD_LEN];//豸id
	char mainid[NET_NAME_PASSWORD_LEN];//id
	int TaskID;//洢
	int TaskName;//洢
	char MainRecordPath[256];//õַ
	char BakRecordPath[256];//õַ
	int FileMode;//ļʽ   0ʱ1С
	int FileLength;//ļֵ10FileModeΪ0ʾ10ӣΪ1ʱʾ10M
	int VideoTransMode;//ʵʱƵģʽʵʱƵģʽ(0-UDP ,1-TCP)
	char Reserved[NET_NAME_PASSWORD_LEN];
}SDK_GbEyesCfg;

//AHDLͨ룬ͨΪAHDL1
typedef struct SDK_AHDEncodeLMask
{
	unsigned char AHDLMask[NET_MAX_MSK_SIZE];
}SDK_AHDEncodeLMask;

typedef struct SDK_PortService
{
	BOOL Enable;		///< Ƿ
	int port;
}SDK_PortService;

/// ĬӦʽ
typedef struct SDK_DefaultResponse
{
	unsigned int uiSessionId;		///< ỰID
	int iRet;				///< ֵ
	char sName[64];		///< 
}SDK_DefaultResponse;

typedef enum SDK_CloudRecType
{
	SDK_TimeRec = (int)0x00001,
	SDK_AlarmRec = (int)0x00002,
}SDK_CloudRecType;

//۾ͷö
typedef enum SDK_E_FISH_LENS_TYPE
{
	SDK_FISH_LENS_NORMAL,  //ͨͷappͼУ
	SDK_FISH_LENS_360VR,
	SDK_FISH_LENS_360LVR,
	SDK_FISH_LENS_180VR,
	SDK_FISH_LENS_DUAL_360VR,
	SDK_FISH_LENS_DUAL_180VR,
	SDK_FISH_LENS_NR,
}SDK_E_FISH_LENS_TYPE;

//۾ͷò
typedef struct SDK_FishLensParam
{
	char  lensType;      //ͷͣöSDK_E_FISH_LENS_TYPE
	char  correctingWay; //Уʽ   0:ӲУ   1:У
	short centerOffsetX; //Բƫ  λ:ص
	short centerOffsetY; //Բƫ  λ:ص
	short radius;        //뾶  λ:ص
	short imageWidth;    //ͼ  λ:ص
	short imageHeight;	 //ͼ߶  λ:ص
	char  viewAngle;	 //ӽ  0:   1:ƽ
	char  viewMode;		 //ʾģʽ(ͷΪ360ӲУʱЧ)   0:360VR  1:Ĺ
	char  resv[10];
} SDK_FishLensParam;

//ͨ۾ͷ
typedef struct SDK_FishLensParamAll
{
	SDK_FishLensParam vLensParamAll[NET_MAX_CHANNUM];
}SDK_FishLensParamAll;

// ϴͨصԭ
typedef void (CALL_METHOD *fUploadDataCallBack) (long lLoginID, long UploadType, char *pBuffer, unsigned long dwBufSize, unsigned long dwUser);

// ͸ڻصԭ
typedef void (CALL_METHOD *fTransComCallBack) (long lLoginID, long lTransComType, char *pBuffer, unsigned long dwBufSize, unsigned long dwUser);
//Ͽصԭ
typedef void (CALL_METHOD *fDisConnect)(long lLoginID, char *pchDVRIP, long nDVRPort, unsigned long dwUser);
//ԭʼݻصԭ
typedef int(CALL_METHOD *fRealDataCallBack) (long lRealHandle, long dwDataType, unsigned char *pBuffer,long lbufsize,long dwUser);
typedef int(CALL_METHOD *fRealDataCallBack_V2) (long lRealHandle, const PACKET_INFO_EX *pFrame, unsigned int dwUser);

// ط¼Ȼصԭ
typedef void(CALL_METHOD *fDownLoadPosCallBack) (long lPlayHandle, long lTotalSize, long lDownLoadSize, long dwUser);

//Ϣ,עᣩصԭ
/*
	1.,pBuf˵,
	SDK_AlarmInfo alarmInfo;
	memcpy ( &alarmInfo, pBuf, dwBufLen );
	2.ע,pBuf˵,
	H264_DVR_ACTIVEREG_INFO activeInfo;
	memcpy ( &alarmInfo, pBuf, dwBufLen );
*/
typedef bool (CALL_METHOD *fMessCallBack)(long lLoginID, char *pBuf,
                                          unsigned long dwBufLen, long dwUser);

//豸صԭ
/*
	nSendSize = -1 ˵  
	nSendSize = -2 ˵
	nTotalSize = -1ʱ, nSendSize:1-99 
	nTotalSize =0ʱ,nSendSize = H264_DVR_NOENOUGH_MEMORY-H264_DVR_INVALID_WIFI_DRIVE 
	Ƿͽ
	һ:nTotalSize=-2ʱnSendSize:0 - 100=ؽ,ûзͽ
*/
typedef void(CALL_METHOD *fUpgradeCallBack) (long lLoginID, long lUpgradechannel,
                                             int nTotalSize, int nSendSize, long dwUser);


// ԽƵݻصԭ
typedef void (CALL_METHOD *pfAudioDataCallBack)(long lVoiceHandle, char *pDataBuf,
                                                long dwBufSize, char byAudioFlag, long dwUser);


//زŽصԭ
typedef void (CALL_METHOD * fLocalPlayFileCallBack)(long lPlayHand, long nUser);

//Ϣ֡ص
typedef void (CALL_METHOD  *InfoFramCallBack)(long lPlayHand, long nType, LPCSTR pBuf,long nSize, long nUser);

//Ӷ߻ص
typedef void (CALL_METHOD *fSubDisConnectCallBack)(long lLoginID, SubConnType type, long nChannel, long dwUser);

#ifdef WIN32
//RigisterDrawصԭ
typedef void (CALL_METHOD * fPlayDrawCallBack)(long lPlayHand,HDC hDc,long nUser);
#else//linuxûõص
typedef void (CALL_METHOD * fPlayDrawCallBack)(long lPlayHand,void* hDc,long nUser);
#endif // WIN32

/*
	:SDKʼ
	:
		cbDisConnect[out]:߻ص
		dwUser[in]:ص
	ֵ:
		=1: ɹ
		<=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_Init(fDisConnect cbDisConnect, unsigned long dwUser);

/*
	:SDK˳
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_Cleanup();

/*
	:ȡϢ
	ֵ:
			
*/
H264_DVR_API long CALL_METHOD H264_DVR_GetLastError();

/*
	:õ¼豸ʱʱͳԴ
	:	
		nWaitTime[in]:λmsʱĬ5000ms,
		nTryTimes[in]:,ʱĬ3
*/

H264_DVR_API bool CALL_METHOD H264_DVR_SetConnectTime(long nWaitTime, long nTryTimes);

/*
	:½豸
	:
		sDVRIP[in]:		  ip
		wDVRPort[in]:	  ˿
		sUserName[in]:    û
		sPassword[in]:    
		lpDeviceInfo[out]:豸Ϣ
		error[out]:		  ص½
		socketType[in]:	  ½ʽ
	ֵ:
		>0:	   ɹ,1ʼn,ÿε¼һ̨豸ֵ+1
		=0:	   ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_Login(char *sDVRIP, unsigned short wDVRPort, char *sUserName, char *sPassword,
                                             LPH264_DVR_DEVICEINFO lpDeviceInfo, int *error,int socketType DEF_PARAM(0));

/*
	:½豸չӿ
	:
		sDVRIP[in]:		  ip
		wDVRPort[in]:	  ˿
		sUserName[in]:    û
		sPassword[in]:    
		lpDeviceInfo[out]:豸Ϣ
		nType[in]:		  ½,0==web 1 == 2 ==   102 == ⲿܣڲͲü
		error[out]:		  ص½
	ֵ:
		>0:	   ɹ
		=0:	   ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_LoginEx(char *sDVRIP, unsigned short wDVRPort, char *sUserName, char *sPassword,
							   LPH264_DVR_DEVICEINFO lpDeviceInfo, int nType, int *error);

/*
	:½ӿV2汾,ָͻ͵½
	:
		sDVRIP[in]:		  ip
		wDVRPort[in]:	  ˿
		sUserName[in]:    û
		sPassword[in]:    
		lpDeviceInfo[out]:豸Ϣ
		nType[in]:		  ½ͣenum SDK_LoginType
		error[out]:		  ص½
		socketType[in]:	  ½ʽ
	ֵ:
		>0:	   ɹ
		=0:	   ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_LoginEx_V2(char *sDVRIP, unsigned short wDVRPort, char *sUserName, char *sPassword,
												  LPH264_DVR_DEVICEINFO lpDeviceInfo, int nType, int *error,int socketType);
/*
	:ͻƵ½ӿ
	:
		sDVRIP[in]:		  豸к
		wDVRPort[in]:	  ˿
		sUserName[in]:    û
		sPassword[in]:    
		lpDeviceInfo[out]:豸Ϣ
		error[out]:		  ص½
		uuid[in]:		  uuid
	ֵ:
		>0:    ɹ
		=0:	   ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_Login_Cloud(char *sDVRIP, unsigned short wDVRPort, char *sUserName, char *sPassword,
												   LPH264_DVR_DEVICEINFO lpDeviceInfo, int *error,char* uuid);
/*
	:豸עǳ豸
	:
		lLoginID[in]:½
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_Logout(long lLoginID);

/*
	:ýDVRϢص, 籨Ϣ,ID
	:
		cbAlarmcallback[out]:ص
		lUser[in]:			 ص
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SetDVRMessCallBack(fMessCallBack cbAlarmcallback, unsigned long lUser);

/*
	:ϴͨ
	:
		lLoginID[in]:½
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_SetupAlarmChan(long lLoginID);

/*
	:رձϱ
	:
		lLoginID[in]:½
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_CloseAlarmChan(long lLoginID);

/*
	:Զ̻ȡò
	:
		lLoginID[in]:	     ½
		dwCommand[in]:		 ,enum SDK_CONFIG_TYPE
		nChannelNO[in]:		 -1ȫͨ,0-nͨ
		lpOutBuffer[out]:	 ջ
		dwOutBufferSize[in]: ջС
		lpBytesReturned[out]:صݴС
		waittime[in]:		 ȴʱ 
	ֵ:
		=1:ɹ
		<0:ʧ
*/
H264_DVR_API long  CALL_METHOD H264_DVR_GetDevConfig(long lLoginID, unsigned long dwCommand, int nChannelNO, char * lpOutBuffer, unsigned long dwOutBufferSize, unsigned long* lpBytesReturned,int waittime DEF_PARAM(1000));

/*
	:Զò
	:
		lLoginID[in]:	     ½
		dwCommand[in]:		 ,enum SDK_CONFIG_TYPE
		nChannelNO[in]:		 -1ȫͨ,0-nͨ
		lpInBuffer[out]:	 뻺
		dwInBufferSize[in]:  뻺С
		waittime[in]:		 ȴʱ 
	ֵ:
		=1:ɹ
		<0:ʧ
*/
H264_DVR_API long  CALL_METHOD H264_DVR_SetDevConfig(long lLoginID, unsigned long dwCommand, int nChannelNO, char * lpInBuffer, unsigned long dwInBufferSize, int waittime DEF_PARAM(1000));

/*
	:豸ãĿǰֶֻ֧ý 
	:
		dwCommand[in]:	   E_SDK_CONFIG_SYSNET
		nChannelNO[in]:	   1ʱ,Ϊñ
		lpInBuffer[in]:	   SDK_CONFIG_NET_COMMON_V3ṹַ
		dwInBufferSize[in]:sizeof(SDK_CONFIG_NET_COMMON_V3)
		waittime[in]:	   ȴʱ
	ֵ:
		=0:ɹ
		<0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_SetConfigOverNet(unsigned long dwCommand, int nChannelNO, char * lpInBuffer, unsigned long dwInBufferSize, int waittime DEF_PARAM(1000));

/*
	:־ѯ
	:
		lLoginID[in]:½
		pFindParam[in]:ѯ
		pRetBuffer[out]:־Ϣ
		lBufSize[in]:־ϢС
		waittime:ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_FindDVRLog(long lLoginID, SDK_LogSearchCondition *pFindParam, SDK_LogList *pRetBuffer, long lBufSize, int waittime DEF_PARAM(2000));

/*
	:ʵʱԤ
	:
		lLoginID[in]:	 ½
		lpClientInfo[in]:Ϣ
	ֵ:
		>0<0:ɹԤž
		=0:ʧ,ֵĴ-11202ĵ
*/
H264_DVR_API long CALL_METHOD H264_DVR_RealPlay(long lLoginID, LPH264_DVR_CLIENTINFO lpClientInfo);

/*
	:ֹͣʵʱԤ
	:
		lRealHandle[in]: Ԥž
		lpClientInfo[in]:Ϣ
	ֵ:
		>0<0:ɹ
		=0:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopRealPlay(long lRealHandle,void*hWnd DEF_PARAM(0));

/*
	:ʵʱԤ
	:
		lRealHandle[in]:Ԥž
		bPause[in]:	    ͣ 1-ͣ 0-
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_PauseRealPlay(long lRealHandle, bool bPause);

/*
	:ݻص
	:
		lRealHandle[in]:Ԥž
		cbRealData[out]:ʵʱݻص
		dwUser[in]:		ص
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SetRealDataCallBack(long lRealHandle,fRealDataCallBack cbRealData, long dwUser);

/*
	:ݾ֡ľϢ,H264_DVR_SetRealDataCallBackͬ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SetRealDataCallBack_V2(long lRealHandle,fRealDataCallBack_V2 cbRealData, long dwUser);

/*
	:ص,úҪH264_DVR_StopRealPlayǰ
	:
		lRealHandle[in]:Ԥž
		cbRealData[in]: ʵʱص
		dwUser[in]:	    ʵʱص
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_DelRealDataCallBack(long lRealHandle,fRealDataCallBack cbRealData, long dwUser);

/*
	:صV2汾
	:
		lRealHandle[in]:Ԥž
		cbRealData[in]: ʵʱصV2汾
		dwUser[in]:	    ʵʱص
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_DelRealDataCallBack_V2(long lRealHandle,fRealDataCallBack_V2 cbRealData, long dwUser);

/*
	:ļѯ¼
	:
		lLoginID[in]:½
		lpFindInfo[in]:ѯ
		lpFileData[out]:ѯ
		lMaxCount[in]:ѯ¼
		findcount[out]:ѯ¼
		waittime[in]:ȴʱ
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_FindFile(long lLoginID, H264_DVR_FINDINFO* lpFindInfo, H264_DVR_FILE_DATA *lpFileData, int lMaxCount, int *findcount, int waittime DEF_PARAM(5000));

/*
	:ʱѯ¼ļ
	:
		lLoginID[in]:½
		lpFindInfo[in]:ѯ
		lpFileData[out]:ѯ
		waittime[in]:ȴʱ
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_FindFileByTime(long lLoginID, SDK_SearchByTime* lpFindInfo, SDK_SearchByTimeResult *lpFileData, int waittime DEF_PARAM(10000));

/*
	:ļط¼
	:
		lLoginID[in]:	   ½
		sPlayBackFile[in]: طŵļ
		cbDownLoadPos[out]:Ȼصû֪ͨû豸ǷѾݷϣصеlDownLoadSize=-1ݷ
						   ͻʵʱʾȣӦôȡʱ粿ֲԵǰݴС/ܴСȵĻǺ׼ӦԵǰʱ䣬ݿʼʱͽʱ
		fDownLoadDataCallBack[out]:طݻص
		dwDataUser[in]:			   ݻص
	ֵ:
		>0<0:ɹ
		=0:	   ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_PlayBackByName(long lLoginID, H264_DVR_FILE_DATA *sPlayBackFile, fDownLoadPosCallBack cbDownLoadPos, fRealDataCallBack fDownLoadDataCallBack, long dwDataUser);

/*
	:ļط¼
	:
		lLoginID[in]:	   ½
		sPlayBackFile[in]: طŵļ
		cbDownLoadPos[out]:Ȼصû֪ͨû豸ǷѾݷϣصеlDownLoadSize=-1ݷ
						   ͻʵʱʾȣӦôȡʱ粿ֲԵǰݴС/ܴСȵĻǺ׼ӦԵǰʱ䣬ݿʼʱͽʱ
		fDownLoadDataCallBack[out]:طݻص,ݾ
		dwDataUser[in]:			   ݻص
	ֵ:
		>0<0:ɹ
		=0:	   ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_PlayBackByName_V2(long lLoginID, H264_DVR_FILE_DATA *sPlayBackFile, fDownLoadPosCallBack cbDownLoadPos, fRealDataCallBack_V2 fDownLoadDataCallBack, long dwDataUser);

/*
	:ʱط¼
	:
		lLoginID[in]:      ½
		lpFindInfo[in]:    ѯ¼
		cbDownLoadPos[out]:Ȼصû֪ͨû豸ǷѾݷϣصеlDownLoadSize=-1ݷ
		fDownLoadDataCallBack[out]:طݻص
		dwDataUser[in]:			   ݻص
	ֵ:
		>0<0:ɹ
		=0:	   ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_PlayBackByTime(long lLoginID, H264_DVR_FINDINFO* lpFindInfo, fDownLoadPosCallBack cbDownLoadPos, fRealDataCallBack fDownLoadDataCallBack, long dwDataUser);


/*
	:ʱط¼Ex,ȻصݻصòͬĻص,H264_DVR_PlayBackByTimeͬ
	
*/
H264_DVR_API long CALL_METHOD H264_DVR_PlayBackByTimeEx(long lLoginID, H264_DVR_FINDINFO* lpFindInfo,fRealDataCallBack fDownLoadDataCallBack, long dwDataUser,
											fDownLoadPosCallBack cbDownLoadPos, long dwPosUser);
/*
	:fDownLoadDataCallBackݻصݵH264_DVR_PlayBackByTimeExͬ
*/
H264_DVR_API long CALL_METHOD H264_DVR_PlayBackByTime_V2(long lLoginID, H264_DVR_FINDINFO* lpFindInfo,fRealDataCallBack_V2 fDownLoadDataCallBack, long dwDataUser,
											fDownLoadPosCallBack cbDownLoadPos, long dwPosUser);

/*
	:ֹͣ¼ط
	:
		lPlayHandle[in]:طž
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopPlayBack(long lPlayHandle);

/*
	:طſ
	:
		lPlayHandle[in]:طž
		lControlCode[in]:,enum SDK_PlayBackAction
		lCtrlValue[in]:ֵ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_PlayBackControl(long lPlayHandle, long lControlCode,long lCtrlValue);

/*
	:ļ,ûԲʹûصԼͨH264_DVR_GetDownloadPosȡ
	:
		lLoginID[in]:	    ½
		sPlayBackFile[in]:  ص¼Ϣ
		sSavedFileName[in]: ļ·
		cbDownLoadPos[out]:ؽȻص
		dwDataUser[in]:    ص
		fDownLoadDataCallBack[out]:ݻص
	ֵ:
		<0>0:ɹ
		=0:	   ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_GetFileByName(long lLoginID,H264_DVR_FILE_DATA *sPlayBackFile,char *sSavedFileName,
                                                     fDownLoadPosCallBack cbDownLoadPos DEF_0_PARAM, long dwDataUser DEF_0_PARAM,fRealDataCallBack fDownLoadDataCallBack DEF_0_PARAM);

/*
	:ļV2汾,ݻصǾ,H264_DVR_GetFileByNameͬ
*/
H264_DVR_API long CALL_METHOD H264_DVR_GetFileByName_V2(long lLoginID,H264_DVR_FILE_DATA *sPlayBackFile,char *sSavedFileName,
													 fDownLoadPosCallBack cbDownLoadPos DEF_0_PARAM, long dwDataUser DEF_0_PARAM,fRealDataCallBack_V2 fDownLoadDataCallBack_V2 DEF_0_PARAM);

/*
	:ʱV2汾
	:
		lLoginID[in]:			  ½
		lpFindInfo[in]:           ¼ѯ
		sSavedFileDIR[in]:		  ¼ļ·
		bMerge[in]:				  ļǷϲ
		cbDownLoadPos[out]:		  Ȼص,û֪ͨû豸ǷѾݷϣصеlDownLoadSize=-1ݷ
		dwDataUser[in]:			  ص
		fDownLoadDataCallBack[in]:ݻص
	ֵ:
		>0<0:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_GetFileByTime(long lLoginID, H264_DVR_FINDINFO* lpFindInfo, char *sSavedFileDIR, bool bMerge DEF_PARAM(0),
                                                     fDownLoadPosCallBack cbDownLoadPos DEF_0_PARAM, long dwDataUser DEF_0_PARAM,fRealDataCallBack fDownLoadDataCallBack DEF_0_PARAM);

/*
	:ݻصݵ,H264_DVR_GetFileByTimeͬ
*/
H264_DVR_API long CALL_METHOD H264_DVR_GetFileByTime_V2(long lLoginID, H264_DVR_FINDINFO* lpFindInfo, char *sSavedFileDIR, bool bMerge
														,fDownLoadPosCallBack cbDownLoadPos DEF_0_PARAM,long dwDataUser DEF_0_PARAM,fRealDataCallBack_V2 fDownLoadDataCallBack_V2 DEF_0_PARAM);

/*
	:ֹͣļ
	:
		lFileHandle[in]:ļ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopGetFile(long lFileHandle);


/*
	:ؿ
	:
		lPlayHandle[in]: ؾ
		lControlCode[in]:,enum SDK_PlayBackAction
		bDown[in]:		 ǷλأĬΪ1
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_GetFileControl(long lPlayHandle, long lControlCode, bool bDown DEF_PARAM(1));

/*
	:ȡؽ
	:
		lFileHandle[in]:ؾ
	ֵ:
		>=0:ؽ
		<0:	ʧ
*/
H264_DVR_API int CALL_METHOD H264_DVR_GetDownloadPos(long lFileHandle);

/* 
	:
	:
		lLoginID[in]: ½
		sFileName[in]:ļ·
		nType[in]:	  ,1-ʼ 0-ֹ
		cbUpgrade[in]:Ȼص
		dwUser[in]:	  ص
	ֵ:
		>0<0: ɹ
		=0:		ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_Upgrade(long lLoginID, char *sFileName, int nType DEF_0_PARAM, fUpgradeCallBack cbUpgrade DEF_0_PARAM, long dwUser DEF_0_PARAM);

/*
	:õ״̬
	:
		lUpgradeHandle[in]:
	ֵ:
		1:ɹ
		2:
		3:ʧ
*/
H264_DVR_API int CALL_METHOD H264_DVR_GetUpgradeState(long lUpgradeHandle);

/*
	:ͷ
	:
		lUpgradeHandle[in]:
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_CloseUpgradeHandle(long lUpgradeHandle);


/* 
	:̨
	:
		lLoginID[in]:	½
		nChannelNo[in]:	ͨ
		lPTZCommand[in]:enum PTZ_ControlType
		bStop[in]:		Ƿֹͣ
		lSpeed[in]:		ٶ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_PTZControl(long lLoginID,int nChannelNo, long lPTZCommand, bool bStop  DEF_PARAM(0), long lSpeed DEF_PARAM(4));

/*
	:1ãɾתԤõʱlParam1ΪԤõֵ
		 2Ԥõ㵽ѲɾѲԤõʱlParam1ΪѲ·ֵlParam2ΪԤõֵ,lParam3Ϊʱ
		 3ʼѲֹͣѲѲ·ʱlParam1ΪѲ·ֵ
		 4̨ʱlParam1ΪˮƽlParam2Ϊֱ
	:
		lLoginID[in]:	½
		nChannelNo[in]:	ͨ
		lPTZCommand[in]:enum PTZ_ControlType
		lParam1[in]:	1
		lParam2[in]:	2
		lParam3[in]:	3
		bStop[in]:		Ƿֹͣ
	ֵ:
		true: ɹ
		false:ʧ
 */
H264_DVR_API bool CALL_METHOD H264_DVR_PTZControlEx(long lLoginID,int nChannelNo, long lPTZCommand,
                                                    long lParam1, long lParam2, long lParam3, bool bStop DEF_0_PARAM);

/*
	:豸 
	:
		lLoginID[in]:½
		type[in]:	 ,0 豸1 ־ 2 ػ 3.ָ¼־ 4.ֹͣ¼־
		waittime[in]:ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_ControlDVR(long lLoginID, int type, int waittime DEF_PARAM(2000));
	
/*
	:ڵ豸 
	:
		szBuf[out]:		ջ
		nBufLen[in]:	ջС,sizeof(SDK_CONFIG_NET_COMMON_V2)*n
		pRetLen[in]:	صĴС
		nSearchTime[in]:ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SearchDevice(char* szBuf, int nBufLen, int* pRetLen, int nSearchTime);

typedef  void ( CALL_METHOD *pfSearchDeviceCallBack)(SDK_CONFIG_NET_COMMON_V2  *pNetCom , unsigned long userData);
//
/*
	:ڵ豸,ڵ豸V2汾
	:
		pfNetCom[out]:	ص
		userData[in]:	ص
		nSearchTime[in]:ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SearchDevice_V2(pfSearchDeviceCallBack pfNetCom,unsigned long userData, int nSearchTime);

/*
	:ʼԽ
	:
		lLoginID[in]:  ½
		pVcb[out]:	   նԽݻص	
		dwDataUser[in]:ص
	ֵ:
		>0<0: ɹ
		=0:		ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_StartVoiceCom_MR(long lLoginID, pfAudioDataCallBack pVcb, long dwDataUser);

/*
	:ͶԽ
	:
		lVoiceHandle[in]:Խ
		pSendBuf[in]:	 Խ
		lBufSize[in]:	 ԽݴС
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_VoiceComSendData(long lVoiceHandle, char *pSendBuf, long lBufSize);

/*
	:ֹͣԽ
	:
		lVoiceHandle[in]:Խ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopVoiceCom(long lVoiceHandle);

/*	
	:öԽƵ뷽ʽûԲãĬΪG711A
	:
		lLoginID[in]:  ½
		pTalkMode[in]: ͨ,-1ȫͨ0-nͨ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SetTalkMode(long lLoginID, SDK_AudioInFormatConfig* pTalkMode);

/*	
	:¼ģʽ
	:
		lLoginID[in]:  ½
		nChannelNo[in]: ͨ,-1ȫͨ0-nͨ
		lRecordType[in]:¼ģʽ,enum SDK_RecordModeTypes
	ֵ:
		true: ɹ
		false:ʧ
*/ 
H264_DVR_API bool CALL_METHOD H264_DVR_StartDVRRecord(long lLoginID, int nChannelNo ,long lRecordType);

/*	
	:ر¼
	:
		lLoginID[in]:  ½
		nChannelNo[in]: ͨ,-1ȫͨ0-nͨ
	ֵ:
		true: ɹ
		false:ʧ
*/ 
H264_DVR_API bool CALL_METHOD H264_DVR_StopDVRRecord(long lLoginID, int nChannelNo);

/*	
	:豸ϵͳʱ
	:
		lLoginID[in]:½
		pSysTime[in]:ʱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SetSystemDateTime(long lLoginID, SDK_SYSTEM_TIME *pSysTime);

/*	
	:õ豸Ĺ״̬
	:
		lLoginID[in]:   ½
		pWorkState[out]:豸Ĺ״̬
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_GetDVRWorkState(long lLoginID, SDK_DVR_WORKSTATE *pWorkState);

/*	
	:̣ʹ÷ClientDemo
	:
		lLoginID[in]:     ½
		pKeyBoardData[in]:̲
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_ClickKey(long lLoginID, SDK_NetKeyBoardData *pKeyBoardData);

/*	
	:Ӳ̽з,ʽȵȲ
	:
		lLoginID[in]:   ½
		pStorageCtl[in]:
	ֵ:
		=1: ɹ
		<=0:ʧ
*/
H264_DVR_API int CALL_METHOD H264_DVR_StorageManage(long lLoginID, SDK_StorageDeviceControl *pStorageCtl);

/*
	:籨Ϣ
	:
		lLoginID[in]:  ½
		pAlarmInfo[in]:籨
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SendNetAlarmMsg(long lLoginID, SDK_NetAlarmInfo *pAlarmInfo);

/*
	:豸ץͼ,ץ豸˷ļʱһͼƬڴbuf
		1.Ҫ豸ץͼѡýӿڲЧ
		2.1ĬץķֱD1ץƵֱһͼƬҪ޸ıץͼֱʣ
		  ûץͼֱѡҪָ֧ĳ
    :
		lLoginID[in]: ½
		nChannel[in]: ͨ
		sFileName[in]:·
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_CatchPic(long lLoginID, int nChannel, char *sFileName);

/*
	:豸ץͼ,ץ豸˷ļʱһͼƬڴbufⲿļ
		1.Ҫ豸ץͼѡýӿڲЧ
		2.1ĬץķֱD1ץƵֱһͼƬҪ޸ıץͼֱʣ
		  ûץͼֱѡҪָ֧ĳ
    :
		lLoginID[in]:½
		nChannel[in]:ͨ
		pBuffer[out]:ջ
		nBufLen[in]:ջĴС
		pPicLen[in]:ʵʷصĴС
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_CatchPicInBuffer(long lLoginID, int nChannel, char *pBuffer, int nBufLen, int *pPicLen);

/*
	:ļ(÷AlarmCenter demo)
	:
		nPort[in]:		   ˿ں
		cbAlarmCenter[out]:ݻص
		dwDataUser[in]:    ص
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StartAlarmCenterListen(int nPort, fMessCallBack cbAlarmCenter, unsigned long dwDataUser);

/*
	:رձļ(÷AlarmCenter demo)
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopAlarmCenterListen();

/*
	:ͨ豸д
	:
		lLoginID[in]:½
		nType[in]:	 
		pBuffer[in]: 
		nBufLen[in]: ݳ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SerialWrite(long lLoginID, SERIAL_TYPE nType, char *pBuffer, int nBufLen);

/*
	:ͨڴ豸
	:
		lLoginID[in]: ½
		nType[in]:	  
		pBuffer[out]: 
		nBufLen[in]:  ݳ
		pReadLen[out]:յݳ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SerialRead(long lLoginID, SERIAL_TYPE nType, char *pBuffer, int nBufLen, int *pReadLen);

/*
	:ȡDDNSϢ÷ClientDemo
	:
		searchmode[in]:Ϣ
		pDevicInfo[out]:DDNSϢ
		maxDeviceNum[in]:豸
		nretNum[out]:õ豸
	ֵ:
		=1:ɹ
		<0:ʧ
*/
H264_DVR_API int CALL_METHOD H264_DVR_GetDDNSInfo(SearchMode &searchmode, DDNS_INFO *pDevicInfo, int maxDeviceNum, int &nretNum);

/*
	:ǿI֡
	:
		lLoginID[in]:½
		nChannel[in]:ͨ
		nStream[in]: ,0ʾΪ1ʾ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_MakeKeyFrame(long lLoginID, int nChannel, int nStream);

/*
	:ȡOEMϢ
	:
		lLoginID[in]:	 ½
		pOEMInfo[out]:	 OEMϢ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_GetOEMInfo(long lLoginID, SDK_OEMInfo *pOEMInfo);

/*
	:͸ͨ
	:
		lLoginID[in]:	 ½
		TransInfo[in]:	 ͸ڲ
		cbTransCom[out]: 豸ݻص
		lUser[in]:		 ص
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_OpenTransComChannel(long lLoginID, TransComChannel *TransInfo, fTransComCallBack cbTransCom, unsigned long lUser);

/*
	:ر͸ͨ
	:
		lLoginID[in]:	 ½
		nType[in]:		 ͸
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_CloseTransComChannel(long lLoginID, SERIAL_TYPE nType);
//ȡ״̬Ϣ
H264_DVR_API bool CALL_METHOD H264_DVR_GetDeviceState(long lLoginID, SDK_State_Type type, char *pState);

/*
	:ȡuiͼƬ
	:
		lLoginID[in]:	 ½
		saveFileName[in]:ͼƬ·
		type[in]:		 ͼƬ,1:ΪȫͼƬ 2:ͼƬ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_CatchPicUI(long lLoginID,char *saveFileName,int type DEF_PARAM(1));

#ifdef WIN32

/*
	:ͨƵ,Ԥ/ط/زһ
	:
		lHandle[in]:ž
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_OpenSound(long lHandle);

/*
	:رͨƵ,Ԥ/ط/زһ
	:
		lHandle[in]:ž
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_CloseSound(long lHandle);

/*
	:ץͼƬ,Ԥ/ط/زһ
	:
		lHandle[in]:ž
		szSaveFileName[in]:ͼƬ·
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_LocalCatchPic(long lHandle,char*szSaveFileName);

/*
	:򿪶Խ
	:
		lLoginID[in]:½
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_StartLocalVoiceCom(long lLoginID);

/*
	:ʼ¼
	:
		lRealHandle[in]:ž
		szSaveFileName[in]:¼·
		type[in]:¼
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StartLocalRecord(long lRealHandle,char*szSaveFileName,long type=0);

/*
	:رձ¼
	:
		lRealHandle[in]:ž
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopLocalRecord(long lRealHandle);

/*
	:űļ
	:
		pFileName[in]:	  ¼ļ·
		hWnd[in]:		  Ŵھ
		drawCallBack[out]:ص
		user[in]:		  ص
	ֵ:زž
		>0<0:ɹ
		=0:	   ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_StartLocalPlay(char*pFileName,void* hWnd,fPlayDrawCallBack drawCallBack=0,long user=0);

/*
	:رձز
	:
		lPlayHandle[in]:زž
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopLocalPlay(long lPlayHandle);

/*
	:ȡλãٷֱȣڻطźͱز,طʱھýӿڲЧ
	:
		lPlayHandle[in]:طž򱾵زž
	ֵ:Ž
*/
H264_DVR_API float CALL_METHOD H264_DVR_GetPlayPos(long lPlayHandle);

/*
	:òλãٷֱȣ,ڻطţز(ػطʱھýӿڲЧ)
	:
		lPlayHandle[in]:طž򱾵زž
		fRelativPos[in]:Ž
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SetPlayPos(long lPlayHandle,float fRelativPos);

/*
	:ſƣţָֹͣ췢ţ
	:
		lPlayHandle[in]:طž򱾵زž
		action[in]:		ſ
		lCtrlValue[in]: ٶ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_LocalPlayCtrl(long lPlayHandle,SDK_LoalPlayAction action,long lCtrlValue);

/*
	:ñزŽص
	:
		lPlayHandle[in]:طž򱾵زž
		callBack[out]:	Žص
		user[in]:		ص
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SetFileEndCallBack(long lPlayHandle,fLocalPlayFileCallBack callBack,long user);

/*
	:Ϣ֡ص
	:
		lPlayHandle[in]:ʵʱž߻طž򱾵زž
		callback[out]:	Ϣ֡ص
		user[in]:		ص
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SetInfoFrameCallBack(long lPlayHandle,InfoFramCallBack callback,long user);

/*
	:ȡɫԤ/ط/زһ
	:
		lHandle[in]:     ʵʱž߻طž򱾵زž
		nRegionNum[in]:  ʾ,ֻһʾ(ͨ)Ϊ0
		pBrightness[out]:	  
		pContrast[out]:	 Աȶ
		pSaturation[out]:Ͷ
		pHue[out]:		 ɫ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_LocalGetColor(long lHandle, DWORD nRegionNum, LONG *pBrightness, LONG *pContrast, LONG *pSaturation, LONG *pHue);

/*
	:ɫƣԤ/ط/زһ
	:
		lHandle[in]:     ʵʱž߻طž򱾵زž
		nRegionNum[in]:  ʾ,ֻһʾ(ͨ)Ϊ0
		pBrightness[in]:	  
		pContrast[in]:	 Աȶ
		pSaturation[in]:Ͷ
		pHue[in]:		 ɫ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_LocalSetColor(long lHandle, DWORD nRegionNum, LONG nBrightness, LONG nContrast, LONG nSaturation, LONG nHue);
#endif
/*
	:ñip,socketͨ׽ְ󶨵ip
	:
		szIP[in]:ip
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SetLocalBindAddress(char*szIP);

/*
	:ϱ,Ϣγ/¼״̬/ͨ״̬/ͨ
	:
		lLoginID[in]:½
		upLoadType[in]:ϱ
		callBack[out]:ϱݻص
		lUser[in]:ص
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StartUploadData(long lLoginID,UploadDataType upLoadType,fUploadDataCallBack callBack,long lUser);

/*
	:ֹͣϱ
	:
		lLoginID[in]:½
		upLoadType[in]:ϱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopUploadData(long lLoginID,UploadDataType upLoadType);

/*
	:ʼע
	:
		nPort[in]:˿ں,0<=nPort<=65535
		cbFunc[out]: ע߻ص
		dwDataUser[in]:ص
	ֵ:
		true:ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StartActiveRigister(int nPort, fMessCallBack cbFunc, unsigned long dwDataUser);


/*
	:رע
	ֵ:
		true:ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopActiveRigister();

/*
	:쳣Ͽ
	:
		callBack[out]:ӶϿص
		userData[in]: ص
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_SetSubDisconnectCallBack(fSubDisConnectCallBack callBack,DWORD userData);

/*
	:ñʱ,perKeeplifeTime():Ĭ10,detectDisconTime(߼ʱ):Ĭ60
	:
		lLoginID[in]:	     ½
		perKeeplifeTime[in]: ʱ
		detectDisconTime[in]:߼ʱ
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_SetKeepLifeTime(long lLoginID,unsigned int perKeeplifeTime,unsigned int detectDisconTime);

/*
	:MACǷõ
	:
		pMac[in]:MACַ
	ֵ:
		true: 
		false:ûм
*/
H264_DVR_API bool CALL_METHOD H264_DVR_CheckEncrypt(char *pMac);

/*
	:豸豸豸ͬһ豸,豸ȥȻ󷵻ؽ(H264_DVR_SearchDeviceӿsdkȥ,߷صĽһµ)
	:
		lLoginID[in]:		 ½
		pDevlist[out]:		 豸б
		transferProtocol[in]:Э,enum SDK_TransferProtocol_V2
		waittime[in]:		 ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_SearchDeviceEX(long lLoginID,SDK_NetDevList *pDevlist,SDK_TransferProtocol_V2 transferProtocol DEF_PARAM(SDK_TRANSFER_PROTOCOL_NETIP),int waittime DEF_PARAM(15000));

/*
	:̨ٶλ,ʹǰжǷ֧
	:
		lLoginID[in]:		½
		nChannel[in]:		ͨ
		pPositionPoint[in]:λ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_PTZPostion(long lLoginID,int nChannel,SDK_PositionPoint *pPositionPoint);

/* 
	:NVRӵǰ˶Խ,ùҪⶨƳ
	:
		lLoginID[in]:½
		nChannel[in]:ͨ
		waittime[in]:ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StartDevTalk(long lLoginID,int nChannel,int waittime DEF_PARAM(2000));

/* 
	:ֹͣNVRӵǰ˶Խ
	:
		lLoginID[in]:½
		nChannel[in]:ͨ
		waittime[in]:ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_StopDevTalk(long lLoginID,int nChannel,int waittime DEF_PARAM(2000));

/*
	:ѯӲ¼Ϣ
	:
		lLoginID[in]:   ½
		lpFindInfo[in]: ѯ
		lpFileData[out]:ҵ¼ݣⲿڴ
		waittime[in]:	ѯʱʱ
	ֵ:
		=1:ɹ
		=0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_RecordInfo(long lLoginID, SDK_SearchByTime* lpFindInfo, SDK_RecordStorageInfo *lpRecordData, int waittime DEF_PARAM(15000));

/*
	:豸ļ
	:
		lLoginID[in]:	   ½
		lpFileControl[in]:ҪƵļͿ
		waittime[in]:      ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
 */
H264_DVR_API bool CALL_METHOD H264_DVR_ControlFile(long lLoginID,SDK_NetFileControl *lpFileControl,int waittime DEF_PARAM(15000));

/*
	:ѯ¼豸Ƶļ8
	:
		lLoginID[in]:	½
		lpFileList[out]:ҵƵ
		waittime[in]:	ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_FindAudioFile(long lLoginID, SDK_MusicFileList* lpFileList, int waittime DEF_PARAM(5000));

/*
	:Ʋ豸Ƶļ
	:
		lLoginID[in]:	   ½
		lpMusicControl[in]:ҪŵļͿ
		waittime[in]:      ȴʱ
	ֵ:
		true: ɹ
		false:ʧ
 */
H264_DVR_API bool CALL_METHOD H264_DVR_ControlAudio(long lLoginID, SDK_LocalMusicControl *lpMusicControl, int waittime DEF_PARAM(2000));

/*
	:޸ƴ͸ַ
	:
		ntype[in]:	  ò
		pUserData[in]:ַ
		nlen[in]:     ò
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_UserData(int ntype,char *pUserData, long nlen);
/*
	:ʼ
	:
		lLoginID[in]:½
		sUpgradeVer[in]:ļϢ
	ֵ:
		=0:ɹ
		<0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_Upgrade_Cloud(long lLoginID, SDK_CloudUpgradeVersion *sUpgradeVer, int nType DEF_0_PARAM, fUpgradeCallBack cbUpgrade DEF_0_PARAM, long dwUser DEF_0_PARAM);
/*
	:µ
	:
		lLoginID[in]:½
		sUpgradeVer[in]:ļϢ
	ֵ:
		=0:ɹ
		<0:ʧ
		غ:H264_DVR_GetUpgradeVersion
*/
H264_DVR_API long CALL_METHOD H264_DVR_Upgrade_Cloud_V2(long lLoginID, SDK_CloudUpgradeStartReq *sUpgradeVer, int nType DEF_0_PARAM, fUpgradeCallBack cbUpgrade DEF_0_PARAM, long dwUser DEF_0_PARAM);
/*
	:ֹͣ
	:
		lHandle[in]:
	ֵ:
		=0:ɹ
		<0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_StopUpgrade_Cloud(long lHandle);
/*
	:ѯĳ豸ip
	:
		uuid[in]:豸к
		ip[out]: ip
	ֵ:
		=1: ɹ
		<=0:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_Get_OutNet_IP(const char *uuid, char* ip);

/*
	:ȿԻȡҲ豸
	:
		lLoginID[in]:		 ½
		nCmdReq[in]:		 
		szCmd[in]:			 json
		lpOutBuffer[out]:	 json
		dwOutBufferSize[in]: ջС(ֽ)
		lpBytesReturned[out]:յjsonС
		nTimeout[in]:		 ȴʱ
		pInParam[in]:		 ʱʹõjsonַ
		nInParamLen[in]:	 ʱjsonС(ֽ)
	ֵ:
		=0:ɹ
		<0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_CmdGeneral(long lLoginID, int nCmdReq, const char *szCmd, void *lpOutBuffer, unsigned long dwOutBufferSize, unsigned long* lpBytesReturned, int nTimeout, char *pInParam DEF_PARAM(0), int nInParamLen DEF_PARAM(0), int nCmdRes DEF_PARAM(-1));


#ifndef WIN32
/*
	:ַͶ˿
	:
		ip[in]:  ַ
		port[in]:˿
	ֵ:
		=0: ɹ
		<0:ʧ
*/

H264_DVR_API int  CALL_METHOD H264_DVR_SetServerAddr(const char *ip, int port);
/*
	:õļб
	:
		id[in]:id
		VersionList[out]:ݻ,Сsizeof(I_VERSION_INFO_T)*n
		num[out]:ȡļ
	ֵ:
		=0:ɹ
		<0:ʧ
*/
H264_DVR_API int  CALL_METHOD H264_DVR_GetUpgradeFileList(const char *id, char *VersionList,int &num);

typedef void (*IDownProcess)(int nProcess,int userData);
typedef void (*IDownData)(unsigned char* data, unsigned int length, int nUserData);

/*
	:ļ
	:
		strSaveFilePath[in]:ļ·
		id[in]:				id
		date:				ļ
		name:				ļ
		length:				ļС
		ProgressCallback[out]:ļؽȻص
		IDownData[out]:		ļݻص
		userData[out]:		ص
	ֵ:
		=0:ɹ
		<0:ʧ
		
*/
H264_DVR_API int CALL_METHOD H264_DVR_StartDownload(const char* strSaveFilePath, const char *id, const char *date,const char *name,unsigned int length,IDownProcess ProgressCallback,IDownData DataCallback,int userData);
/*
	:ȡļ
	ֵ:
		=0:ɹ
		<0:ʧ
		
*/
H264_DVR_API int CALL_METHOD H264_DVR_CancelDownload();

/*
	:ȡƴ͸ip
	:
		_serverip[out]:ƴ͸ip
	ֵ:
		true: ɹ
		false:ʧ
*/
H264_DVR_API bool CALL_METHOD H264_DVR_GetServerIp(char* _serverip);

H264_DVR_API int CALL_METHOD H264_DVR_AuthDevice_Init(char *uuid,char *ip,int port);
H264_DVR_API int CALL_METHOD H264_DVR_AuthDevice_Register();
H264_DVR_API int CALL_METHOD H264_DVR_AuthDevice_UnRegister();
H264_DVR_API int CALL_METHOD H264_DVR_AuthDevice_GetUpdateServer(char *ip,int size);


H264_DVR_API int CALL_METHOD H264_DVR_AlarmInit(char* uuid,char*ip,char* serIP);

typedef int (*MpsDevAuth)(char *buffer,int size);	//Ȩ
typedef int (*MpsDevDataRecv)(char *buffer,int size,int clientID);	//ɿͻ˷豸

H264_DVR_API int CALL_METHOD H264_DVR_AlarmPush(char* buffer,int size);
H264_DVR_API int CALL_METHOD H264_DVR_AlarmStart(char* uuid,char* serIP,MpsDevAuth  AuthCb, MpsDevDataRecv DataRecvCb);

/*
	:ȡ͸İ汾Ϣ
	:
		version[out]:͸汾Ϣ
		size[i]:	 С
*/
H264_DVR_API void CALL_METHOD H264_VV_NAT_GetVersion(char *version, int size);
/*
	:ǿת
	:
		skipP2P[in];1-ǿת;0-
*/
H264_DVR_API void CALL_METHOD H264_Direct_Proxy(int skipP2P);
/*
	:ж豸ǾƷǷǾƷ
	ֵ:
		=1:Ʒ豸
		=0:ͨ豸	
*/
H264_DVR_API int CALL_METHOD H264_XM_Unique();
/*
	:õͶָ,ֻ
	ֵ:
		mpsͿIMpsAlarmClientָ
*/
H264_DVR_API void* get_MpsAlarmClient_Instance();

/*
	:õõjsonʽ
	:
		lLoginID[in]:	     ½
		dwCommand[in]:	     json
		nChannelNO[in]:		 ͨ,-1:õȫͨ,0-n:õͨ,0ʼ
		lpOutBuffer[out]:	 json
		dwOutBufferSize[in]: ջС
		lpBytesReturned[out]:õĻС(ֽ)
		waittime[in]:		 ȴʱ
	ֵ:
		=1:ɹ
		<0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_GetDevConfig_Json(long lLoginID, const char* dwCommand, int nChannelNO,char * lpOutBuffer,unsigned long dwOutBufferSize,unsigned long* lpBytesReturned,int waittime DEF_PARAM(1000));
/*
	:õjsonʽ
	:
		lLoginID[in]:	     ½
		dwCommand[in]:	     json
		nChannelNO[in]:		 ͨ,-1:õȫͨ,0-n:õͨ,0ʼ
		lpOutBuffer[in]:	 õjsonַ
		waittime[in]:		 ȴʱ
	ֵ:
		=1:ɹ
		<0:ʧ
*/
H264_DVR_API long CALL_METHOD H264_DVR_SetDevConfig_Json(long lLoginID,const char* dwCommand, int nChannelNO, char * lpInBuffer,int waittime DEF_PARAM(1000));


typedef void (*PFunOnWifiConfigResult)(int nResult, SDK_CONFIG_NET_COMMON_V2 *pConfig);
/*
	:ʼwifiһ
	:
		pInfo[i]:	   wifiһЩϢ
		pOnResult[out]:wifiɹ󷵻ص豸
	ֵ:
		=1:ɹ
		<0:ʧ
*/
H264_DVR_API int CALL_METHOD H264_DVR_StartWifiConfig(SDK_SWifiInfo *pInfo, PFunOnWifiConfigResult pOnResult);
/*
	:ֹͣwifiһ
*/
H264_DVR_API void CALL_METHOD H264_DVR_StopWifiConfig();
/*
	:֤û
	:
		userName[in]:û
		password[in]:
	ֵ:
		=0:ɹ
		<0:ʧ
*/
H264_DVR_API int CALL_METHOD H264_DVR_SetAuthUserInfo(const char *userName, const char *password);

#endif

/*
	:ȡ豸Ϣ
	: 
	lLoginID[int]:¼
	versionInfo	[int]	:Ϣ
	lpOutBuffer[out];豸汾Ϣ
	dwOutBufferSize[out]:豸汾ĴС
	lpBytesReturned[out]:յĴС
	waittimeȴʱ
	ֵ:
	=0:ɹ
	<0:ʧ
	غH264_DVR_Upgrade_Cloud_V2
*/
H264_DVR_API long CALL_METHOD H264_DVR_GetUpgradeVersion(long lLoginID,SDK_CloudUpgradeVersionReq* versionInfo, 
	
														 char * lpOutBuffer,unsigned long dwOutBufferSize,unsigned long* lpBytesReturned,int waittime/*=500*/);


typedef int (*OnFoundDevCB)(char * uuid,int state,int userData);
/*
	:ѯ豸ǷV2汾
	:
		pStates[out]: ҪѯĶ豸Ϣ,᷵豸״̬
		nTimeout[in]: ȴʱ
		decCb[out]:   豸Ļص
		userData[out]:ص
	ֵ:
		=0:ɹ
		<0:ʧ
*/
H264_DVR_API int CALL_METHOD H264_DVR_Check_Device_Exist_V2(SDK_SDevicesState *pStates, int nTimeout,OnFoundDevCB decCb,int userData);
/*
	öοƷuuid
	
		uuid[in]: ͻuuid
*/
H264_DVR_API bool CALL_METHOD H264_DVR_Set_UUid(char* uuid);

#ifdef _NAMESPACE_
}
#endif

#endif
